/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.discovery.DiscoCache;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.GridCachePartitionExchangeManager;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsExchangeFuture;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsFullMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionsSingleRequest;
import org.apache.ignite.internal.util.future.GridCompoundFuture;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class InitNewCoordinatorFuture
extends GridCompoundFuture {
    private GridDhtPartitionsFullMessage fullMsg;
    private Set<UUID> awaited = new HashSet<UUID>();
    private Map<ClusterNode, GridDhtPartitionsSingleMessage> msgs = new HashMap<ClusterNode, GridDhtPartitionsSingleMessage>();
    private Map<UUID, GridDhtPartitionsSingleMessage> joinExchMsgs;
    private GridFutureAdapter restoreStateFut;
    private final IgniteLogger log;
    private AffinityTopologyVersion initTopVer;
    private Map<UUID, GridDhtPartitionExchangeId> joinedNodes;
    private boolean restoreState;

    InitNewCoordinatorFuture(GridCacheSharedContext cctx) {
        this.log = cctx.logger(this.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(GridDhtPartitionsExchangeFuture exchFut) throws IgniteCheckedException {
        this.initTopVer = exchFut.initialVersion();
        GridCacheSharedContext cctx = exchFut.sharedContext();
        this.restoreState = GridCachePartitionExchangeManager.exchangeProtocolVersion(exchFut.context().events().discoveryCache().minimumNodeVersion()) > 1;
        boolean newAff = exchFut.localJoinExchange();
        IgniteInternalFuture<?> fut = cctx.affinity().initCoordinatorCaches(exchFut, newAff);
        if (fut != null) {
            this.add(fut);
        }
        if (this.restoreState) {
            DiscoCache curDiscoCache = cctx.discovery().discoCache();
            DiscoCache discoCache = exchFut.events().discoveryCache();
            ArrayList<ClusterNode> nodes = new ArrayList<ClusterNode>();
            InitNewCoordinatorFuture initNewCoordinatorFuture = this;
            synchronized (initNewCoordinatorFuture) {
                for (ClusterNode node : discoCache.allNodes()) {
                    if (!node.isLocal() && cctx.discovery().alive(node)) {
                        this.awaited.add(node.id());
                        nodes.add(node);
                        continue;
                    }
                    if (node.isLocal() || !this.log.isInfoEnabled()) continue;
                    this.log.info("Init new coordinator future will skip remote node: " + node);
                }
                if (exchFut.context().mergeExchanges() && !curDiscoCache.version().equals(discoCache.version())) {
                    for (ClusterNode node : curDiscoCache.allNodes()) {
                        if (discoCache.node(node.id()) != null) continue;
                        if (GridCachePartitionExchangeManager.exchangeProtocolVersion(node.version()) == 1) break;
                        this.awaited.add(node.id());
                        nodes.add(node);
                        if (this.joinedNodes == null) {
                            this.joinedNodes = new HashMap<UUID, GridDhtPartitionExchangeId>();
                        }
                        GridDhtPartitionExchangeId exchId = new GridDhtPartitionExchangeId(node.id(), 10, new AffinityTopologyVersion(node.order()));
                        this.joinedNodes.put(node.id(), exchId);
                    }
                }
                if (this.joinedNodes == null) {
                    this.joinedNodes = Collections.emptyMap();
                }
                if (!this.awaited.isEmpty()) {
                    this.restoreStateFut = new GridFutureAdapter();
                    this.add(this.restoreStateFut);
                }
            }
            if (this.log.isInfoEnabled()) {
                this.log.info("Try restore exchange result [awaited=" + this.awaited + ", joined=" + this.joinedNodes.keySet() + ", nodes=" + U.nodeIds(nodes) + ", discoAllNodes=" + U.nodeIds(discoCache.allNodes()) + ']');
            }
            if (!nodes.isEmpty()) {
                GridDhtPartitionsSingleRequest req = GridDhtPartitionsSingleRequest.restoreStateRequest(exchFut.exchangeId(), exchFut.exchangeId());
                for (ClusterNode node : nodes) {
                    try {
                        GridDhtPartitionsSingleRequest sndReq = req;
                        if (this.joinedNodes.containsKey(node.id())) {
                            sndReq = GridDhtPartitionsSingleRequest.restoreStateRequest(this.joinedNodes.get(node.id()), exchFut.exchangeId());
                        }
                        cctx.io().send(node, (GridCacheMessage)sndReq, (byte)2);
                    }
                    catch (ClusterTopologyCheckedException e) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug("Failed to send partitions request, node failed: " + node);
                        }
                        this.onNodeLeft(node.id());
                    }
                }
            }
        }
        this.markInitialized();
    }

    boolean restoreState() {
        return this.restoreState;
    }

    Map<ClusterNode, GridDhtPartitionsSingleMessage> messages() {
        return this.msgs;
    }

    Map<UUID, GridDhtPartitionsSingleMessage> mergedJoinExchangeMessages() {
        return this.joinExchMsgs;
    }

    GridDhtPartitionsFullMessage fullMessage() {
        return this.fullMsg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ClusterNode node, GridDhtPartitionsSingleMessage msg) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Init new coordinator, received response [node=" + node.id() + ", fullMsg=" + (msg.finishMessage() != null) + ", affReq=" + !F.isEmpty(msg.cacheGroupsAffinityRequest()) + ']');
        }
        assert (msg.restoreState()) : msg;
        boolean done = false;
        InitNewCoordinatorFuture initNewCoordinatorFuture = this;
        synchronized (initNewCoordinatorFuture) {
            if (this.awaited.remove(node.id())) {
                GridDhtPartitionsFullMessage fullMsg0 = msg.finishMessage();
                if (fullMsg0 != null && fullMsg0.resultTopologyVersion() != null) {
                    assert (this.fullMsg == null || this.fullMsg.resultTopologyVersion().equals(fullMsg0.resultTopologyVersion()));
                    this.fullMsg = fullMsg0;
                } else {
                    this.msgs.put(node, msg);
                }
                done = this.awaited.isEmpty();
            }
            if (done) {
                this.onAllReceived();
            }
        }
        if (done) {
            this.restoreStateFut.onDone();
        }
    }

    private void onAllReceived() {
        if (this.fullMsg != null) {
            AffinityTopologyVersion resVer = this.fullMsg.resultTopologyVersion();
            Iterator<Map.Entry<ClusterNode, GridDhtPartitionsSingleMessage>> it = this.msgs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ClusterNode, GridDhtPartitionsSingleMessage> e = it.next();
                GridDhtPartitionExchangeId msgVer = this.joinedNodes.get(e.getKey().id());
                if (msgVer == null) continue;
                assert (msgVer.topologyVersion().compareTo(this.initTopVer) > 0) : msgVer;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Process joined node message [resVer=" + resVer + ", initTopVer=" + this.initTopVer + ", msgVer=" + msgVer.topologyVersion() + ']');
                }
                if (msgVer.topologyVersion().compareTo(resVer) > 0) {
                    it.remove();
                    continue;
                }
                GridDhtPartitionsSingleMessage msg = e.getValue();
                msg.exchangeId(msgVer);
                if (this.joinExchMsgs == null) {
                    this.joinExchMsgs = new HashMap<UUID, GridDhtPartitionsSingleMessage>();
                }
                this.joinExchMsgs.put(e.getKey().id(), msg);
            }
        } else {
            Iterator<Map.Entry<ClusterNode, GridDhtPartitionsSingleMessage>> it = this.msgs.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<ClusterNode, GridDhtPartitionsSingleMessage> e = it.next();
                GridDhtPartitionExchangeId msgVer = this.joinedNodes.get(e.getKey().id());
                if (msgVer == null) continue;
                it.remove();
                assert (msgVer.topologyVersion().compareTo(this.initTopVer) > 0) : msgVer;
                if (this.log.isInfoEnabled()) {
                    this.log.info("Process joined node message [initTopVer=" + this.initTopVer + ", msgVer=" + msgVer.topologyVersion() + ']');
                }
                if (this.joinExchMsgs == null) {
                    this.joinExchMsgs = new HashMap<UUID, GridDhtPartitionsSingleMessage>();
                }
                e.getValue().exchangeId(msgVer);
                this.joinExchMsgs.put(e.getKey().id(), e.getValue());
            }
        }
    }

    @Nullable
    GridDhtPartitionsSingleMessage joinExchangeMessage(UUID nodeId) {
        return this.joinExchMsgs != null ? this.joinExchMsgs.get(nodeId) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNodeLeft(UUID nodeId) {
        boolean done;
        if (this.log.isInfoEnabled()) {
            this.log.info("Init new coordinator, node left [node=" + nodeId + ']');
        }
        InitNewCoordinatorFuture initNewCoordinatorFuture = this;
        synchronized (initNewCoordinatorFuture) {
            boolean bl = done = this.awaited.remove(nodeId) && this.awaited.isEmpty();
            if (done) {
                this.onAllReceived();
            }
        }
        if (done) {
            this.restoreStateFut.onDone();
        }
    }
}

