/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.odbc;

import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.cache.query.FieldsQueryCursor;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcResultSet;
import org.apache.ignite.internal.processors.odbc.odbc.OdbcUtils;

public class OdbcQueryResults {
    private final List<FieldsQueryCursor<List<?>>> cursors;
    private final List<Long> rowsAffected;
    private OdbcResultSet currentResultSet;
    private int currentResultSetIdx;

    OdbcQueryResults(List<FieldsQueryCursor<List<?>>> cursors) {
        this.cursors = cursors;
        this.currentResultSetIdx = 0;
        this.rowsAffected = new ArrayList<Long>(cursors.size());
        for (FieldsQueryCursor<List<?>> cursor : cursors) {
            this.rowsAffected.add(OdbcUtils.rowsAffected(cursor));
        }
        this.nextResultSet();
    }

    public List<Long> rowsAffected() {
        return this.rowsAffected;
    }

    public boolean hasUnfetchedRows() {
        if (this.currentResultSet != null && this.currentResultSet.hasUnfetchedRows()) {
            return true;
        }
        for (FieldsQueryCursor<List<?>> cursor : this.cursors) {
            QueryCursorImpl cursor0 = (QueryCursorImpl)cursor;
            if (!cursor0.isQuery()) continue;
            return true;
        }
        return false;
    }

    public void closeAll() {
        for (FieldsQueryCursor<List<?>> cursor : this.cursors) {
            cursor.close();
        }
    }

    public OdbcResultSet currentResultSet() {
        return this.currentResultSet;
    }

    public void nextResultSet() {
        this.currentResultSet = null;
        if (this.currentResultSetIdx != this.cursors.size()) {
            this.currentResultSet = new OdbcResultSet(this.cursors.get(this.currentResultSetIdx));
            ++this.currentResultSetIdx;
        }
    }
}

