/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.version;

import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.CacheObjectValueContext;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.version.GridCachePlainVersionedEntry;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;

public class GridCacheLazyPlainVersionedEntry<K, V>
extends GridCachePlainVersionedEntry<K, V> {
    protected GridCacheContext cctx;
    private KeyCacheObject keyObj;
    private CacheObject valObj;
    private boolean keepBinary;

    public GridCacheLazyPlainVersionedEntry(GridCacheContext cctx, KeyCacheObject keyObj, CacheObject valObj, long ttl, long expireTime, GridCacheVersion ver, boolean isStartVer, boolean keepBinary) {
        super(null, null, ttl, expireTime, ver, isStartVer);
        this.cctx = cctx;
        this.keyObj = keyObj;
        this.valObj = valObj;
        this.keepBinary = keepBinary;
    }

    public GridCacheLazyPlainVersionedEntry(GridCacheContext cctx, KeyCacheObject keyObj, CacheObject valObj, long ttl, long expireTime, GridCacheVersion ver, boolean keepBinary) {
        super(null, null, ttl, expireTime, ver);
        this.cctx = cctx;
        this.keepBinary = keepBinary;
        this.keyObj = keyObj;
        this.valObj = valObj;
    }

    @Override
    public K key() {
        if (this.key == null) {
            this.key = this.cctx.unwrapBinaryIfNeeded(this.keyObj, this.keepBinary);
        }
        return (K)this.key;
    }

    @Override
    public V value(CacheObjectValueContext ctx) {
        return this.value(this.keepBinary);
    }

    public V value(boolean keepBinary) {
        if (this.val == null) {
            this.val = this.cctx.unwrapBinaryIfNeeded(this.valObj, keepBinary, true);
        }
        return (V)this.val;
    }

    @Override
    public String toString() {
        return S.toString(GridCacheLazyPlainVersionedEntry.class, this, "super", (Object)super.toString(), "key", this.key(), "val", this.value(this.keepBinary));
    }
}

