/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.partstate;

import org.apache.ignite.internal.pagemem.FullPageId;
import org.apache.ignite.internal.pagemem.PageIdUtils;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class GroupPartitionId
implements Comparable<GroupPartitionId> {
    private static final int METAPAGE_IDX = 0;
    private final int grpId;
    private final int partId;

    public GroupPartitionId(int grpId, int partId) {
        this.grpId = grpId;
        this.partId = partId;
    }

    private static byte getFlagByPartId(int partId) {
        return partId == 65535 ? (byte)2 : 1;
    }

    public int getGroupId() {
        return this.grpId;
    }

    public int getPartitionId() {
        return this.partId;
    }

    public String toString() {
        return S.toString(GroupPartitionId.class, this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupPartitionId key = (GroupPartitionId)o;
        if (this.grpId != key.grpId) {
            return false;
        }
        return this.partId == key.partId;
    }

    public int hashCode() {
        int result = this.grpId;
        result = 31 * result + this.partId;
        return result;
    }

    @Override
    public int compareTo(@NotNull GroupPartitionId o) {
        if (this.getGroupId() < o.getGroupId()) {
            return -1;
        }
        if (this.getGroupId() > o.getGroupId()) {
            return 1;
        }
        if (this.getPartitionId() < o.getPartitionId()) {
            return -1;
        }
        if (this.getPartitionId() > o.getPartitionId()) {
            return 1;
        }
        return 0;
    }

    private long createPageId(int pageIdx) {
        int partId = this.getPartitionId();
        return PageIdUtils.pageId(partId, GroupPartitionId.getFlagByPartId(partId), pageIdx);
    }

    @NotNull
    private FullPageId createFullPageId(int pageIdx) {
        return new FullPageId(this.createPageId(pageIdx), this.getGroupId());
    }

    @NotNull
    public FullPageId createFirstPageFullId() {
        return this.createFullPageId(0);
    }
}

