/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.cache.KeyCacheObject;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearLockRequest;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class GridNearLockMapping {
    private ClusterNode node;
    @GridToStringInclude
    private final Collection<KeyCacheObject> mappedKeys = new ArrayList<KeyCacheObject>();
    @GridToStringExclude
    private GridNearLockRequest req;
    @GridToStringInclude
    private Collection<KeyCacheObject> distributedKeys;

    public GridNearLockMapping(ClusterNode node, KeyCacheObject firstKey) {
        assert (node != null);
        assert (firstKey != null);
        this.node = node;
        this.mappedKeys.add(firstKey);
    }

    public ClusterNode node() {
        return this.node;
    }

    public Collection<KeyCacheObject> mappedKeys() {
        return this.mappedKeys;
    }

    public void addKey(KeyCacheObject key) {
        this.mappedKeys.add(key);
    }

    @Nullable
    public GridNearLockRequest request() {
        return this.req;
    }

    public void request(GridNearLockRequest req) {
        assert (req != null);
        this.req = req;
    }

    public Collection<KeyCacheObject> distributedKeys() {
        return this.distributedKeys;
    }

    public void distributedKeys(Collection<KeyCacheObject> distributedKeys) {
        this.distributedKeys = distributedKeys;
    }

    public String toString() {
        return S.toString(GridNearLockMapping.class, this);
    }
}

