/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.table;

import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SchemaRepository {
    public String namespace;
    public String node_path;
    private int version = -1;
    private Map<String, ZillionTableSchema> tableSchemaMap = new HashMap<String, ZillionTableSchema>();

    public int GetVersion() {
        return this.version;
    }

    public void SetVersion(int version) {
        this.version = version;
    }

    public List<String> TableList() {
        ArrayList<String> result = new ArrayList<String>();
        for (String key : this.tableSchemaMap.keySet()) {
            result.add(key);
        }
        return result;
    }

    public void AddTable(ZillionTableSchema schema) {
        if (this.tableSchemaMap.containsKey(schema.table_name)) {
            this.tableSchemaMap.remove(schema.table_name);
        }
        this.tableSchemaMap.put(schema.table_name, schema);
    }

    public ZillionTableSchema DropTable(String tableName) {
        ZillionTableSchema result = null;
        if (this.tableSchemaMap.containsKey(tableName)) {
            result = this.tableSchemaMap.remove(tableName);
        }
        return result;
    }

    public ZillionTableSchema GetTable(String tableName) {
        ZillionTableSchema result = null;
        if (this.tableSchemaMap.containsKey(tableName)) {
            result = this.tableSchemaMap.get(tableName);
        }
        return result;
    }

    public void AddIndex(String tableName, ZillionTableIndex index) {
        ZillionTableSchema value = this.tableSchemaMap.get(tableName);
        value.Indexes.add(index);
    }

    public void DropIndex(String tableName, String indexName) {
        ZillionTableSchema value = this.tableSchemaMap.get(tableName);
        int i = 0;
        while (i < value.Indexes.size()) {
            ZillionTableIndex index = value.Indexes.get(i);
            if (index.index_name.equals(indexName)) {
                value.Indexes.remove(index);
                break;
            }
            ++i;
        }
    }

    public List<ZillionTableIndex> GetIndex(String tableName) {
        ArrayList<ZillionTableIndex> result = new ArrayList<ZillionTableIndex>();
        ZillionTableSchema value = this.tableSchemaMap.get(tableName);
        result.addAll(value.Indexes);
        return result;
    }

    public ZillionTableIndex GetIndex(String tableName, String indexName) {
        ZillionTableIndex result = null;
        ZillionTableSchema value = this.tableSchemaMap.get(tableName);
        if (value != null) {
            int i = 0;
            while (i < value.Indexes.size()) {
                ZillionTableIndex index = value.Indexes.get(i);
                if (index.index_name.equals(indexName)) {
                    result = index;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void SetTableVersion(String tableName, int version) {
        ZillionTableSchema value = this.tableSchemaMap.get(tableName);
        value.version = version;
    }
}

