/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.table;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.zillion.util.table.ZillionTableColumn;
import com.zillion.util.table.ZillionTableColumnEnum;
import com.zillion.util.table.ZillionTableIndex;
import com.zillion.util.table.ZillionTableSchema;
import java.util.ArrayList;
import java.util.HashMap;
import org.zillion.util.common.HexToByte;

public class SchemaParser {
    public static void ParseIndexSchema(ZillionTableIndex result, ZillionTableSchema schema, JSONArray Columns) {
        String key_name;
        HashMap<String, Boolean> columnExistMap = new HashMap<String, Boolean>();
        ArrayList<String> keyList = new ArrayList<String>();
        int i = 0;
        while (i < Columns.size()) {
            key_name = (String)Columns.get(i);
            if (!columnExistMap.containsKey(key_name)) {
                columnExistMap.put(key_name, true);
                keyList.add(key_name);
            }
            ++i;
        }
        if (schema.table_type != null) {
            i = 0;
            while (i < schema.Key.length) {
                key_name = schema.Key[i];
                if (!columnExistMap.containsKey(key_name)) {
                    columnExistMap.put(key_name, true);
                    keyList.add(key_name);
                }
                ++i;
            }
        }
        result.Key = keyList.toArray(new String[0]);
        result.KeyMap = new HashMap<String, Boolean>();
        String[] stringArray = result.Key;
        int n = result.Key.length;
        int n2 = 0;
        while (n2 < n) {
            String column = stringArray[n2];
            result.KeyMap.put(column, true);
            ++n2;
        }
    }

    public static ZillionTableIndex ParseIndexSchema(ZillionTableSchema schema, JSONObject index_schema) {
        ZillionTableIndex result = new ZillionTableIndex(schema, (String)index_schema.get((Object)"Name"));
        JSONArray Columns = (JSONArray)index_schema.get((Object)"Columns");
        SchemaParser.ParseIndexSchema(result, schema, Columns);
        return result;
    }

    public static void ParseTableSchema(ZillionTableSchema schema, JSONObject table_schema) {
        JSONArray Columns = (JSONArray)table_schema.get((Object)"Columns");
        JSONArray Key = (JSONArray)table_schema.get((Object)"Key");
        if (table_schema.containsKey((Object)"delete_UsePutV")) {
            schema.delete_UsePutV = (Boolean)table_schema.get((Object)"delete_UsePutV");
        }
        if (table_schema.containsKey((Object)"compress")) {
            schema.compress = (Boolean)table_schema.get((Object)"compress");
        }
        if (table_schema.containsKey((Object)"resident_memory")) {
            schema.resident_memory = (Boolean)table_schema.get((Object)"resident_memory");
        }
        if (table_schema.containsKey((Object)"store_in_minor_db")) {
            schema.store_in_minor_db = (Boolean)table_schema.get((Object)"store_in_minor_db");
        }
        if (table_schema.containsKey((Object)"table_type")) {
            schema.table_type = (String)table_schema.get((Object)"table_type");
        }
        if (table_schema.containsKey((Object)"split_column")) {
            schema.split_column = (String)table_schema.get((Object)"split_column");
        }
        if (table_schema.containsKey((Object)"region_keys")) {
            JSONArray region_keys = (JSONArray)table_schema.get((Object)"region_keys");
            schema.splitKeys = new byte[region_keys.size()][];
            int index_key = 0;
            while (index_key < region_keys.size()) {
                String region_key = (String)region_keys.get(index_key);
                schema.splitKeys[index_key] = HexToByte.hexToByte(region_key);
                ++index_key;
            }
        }
        schema.Key = new String[Key.size()];
        schema.KeyMap = new HashMap<String, Boolean>();
        int i = 0;
        while (i < Key.size()) {
            schema.Key[i] = (String)Key.get(i);
            schema.KeyMap.put(schema.Key[i], true);
            ++i;
        }
        ArrayList<String> other_column = new ArrayList<String>();
        int i2 = 0;
        while (i2 < Columns.size()) {
            JSONObject column = (JSONObject)Columns.get(i2);
            ZillionTableColumn ztc = SchemaParser.ParseColumn(column);
            schema.ColumnMap.put(ztc.Name, ztc);
            boolean iskey = false;
            int index_key = 0;
            while (index_key < schema.Key.length) {
                String KeyItem = schema.Key[index_key];
                if (KeyItem.equals(ztc.Name)) {
                    iskey = true;
                    break;
                }
                ++index_key;
            }
            if (!iskey) {
                other_column.add(ztc.Name);
            }
            ++i2;
        }
        schema.OtherColumn = other_column.toArray(new String[0]);
    }

    public static ZillionTableColumn ParseColumn(JSONObject column) {
        String Name = (String)column.get((Object)"Name");
        String Type2 = (String)column.get((Object)"Type");
        ZillionTableColumn ztc = new ZillionTableColumn();
        ztc.Name = Name;
        if (Type2.startsWith("String")) {
            ztc.Type = ZillionTableColumnEnum.STRING;
            if (Type2.length() > "String".length()) {
                ztc.max_length = Integer.parseInt(Type2.substring("String".length() + 1, Type2.length() - 1));
            }
        } else if (Type2.startsWith("ASCIIString")) {
            ztc.Type = ZillionTableColumnEnum.STRING;
            ztc.ASCIIString = true;
            if (Type2.length() > "ASCIIString".length()) {
                ztc.max_length = Integer.parseInt(Type2.substring("ASCIIString".length() + 1, Type2.length() - 1));
            }
        } else if (Type2.startsWith("CompressString")) {
            ztc.Type = ZillionTableColumnEnum.COMPRESSSTRING;
            if (Type2.length() > "CompressString".length()) {
                ztc.max_length = Integer.parseInt(Type2.substring("CompressString".length() + 1, Type2.length() - 1));
            }
        } else if (Type2.equals("Int")) {
            ztc.Type = ZillionTableColumnEnum.INT;
        } else if (Type2.equals("Long")) {
            ztc.Type = ZillionTableColumnEnum.LONG;
        } else if (Type2.equals("Float")) {
            ztc.Type = ZillionTableColumnEnum.FLOAT;
        } else if (Type2.equals("Double")) {
            ztc.Type = ZillionTableColumnEnum.DOUBLE;
        } else if (Type2.equals("Boolean")) {
            ztc.Type = ZillionTableColumnEnum.BOOLEAN;
        }
        if (column.containsKey((Object)"NotNull")) {
            ztc.NotNull = (Boolean)column.get((Object)"NotNull");
        }
        if (ztc.Type == ZillionTableColumnEnum.STRING && !ztc.NotNull && column.containsKey((Object)"NullValueConvert")) {
            ztc.NullValueConvert = (Boolean)column.get((Object)"NullValueConvert");
        }
        return ztc;
    }
}

