/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.json;

import com.sagacloud.json.JSONAware;
import com.sagacloud.json.JSONItem;
import com.sagacloud.json.JSONStreamAware;
import com.sagacloud.json.JSONValue;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;

public class JSONArray
implements JSONAware,
JSONStreamAware {
    List<JSONItem> valueList = new ArrayList<JSONItem>();

    public String toFormatString() {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < this.size(); ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append("\r\n\t");
            Object value = this.get(i);
            if (value == null) {
                sb.append("null");
                continue;
            }
            String valueString = JSONValue.toFormatString(value);
            sb.append(valueString.replaceAll("\r\n", "\r\n\t"));
        }
        sb.append("\r\n");
        sb.append(']');
        return sb.toString();
    }

    public void writeFormatString(Writer out) throws IOException {
        out.write(this.toFormatString());
    }

    public void writeJSONString(Writer out) throws IOException {
        boolean first = true;
        out.write(91);
        for (int i = 0; i < this.size(); ++i) {
            if (first) {
                first = false;
            } else {
                out.write(44);
            }
            Object value = this.get(i);
            if (value == null) {
                out.write("null");
                continue;
            }
            JSONValue.writeJSONString(value, out);
        }
        out.write(93);
    }

    public String toJSONString() {
        boolean first = true;
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        for (int i = 0; i < this.size(); ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            Object value = this.get(i);
            if (value == null) {
                sb.append("null");
                continue;
            }
            sb.append(JSONValue.toJSONString(value));
        }
        sb.append(']');
        return sb.toString();
    }

    public String toString() {
        return this.toJSONString();
    }

    public int size() {
        return this.valueList.size();
    }

    public Object get(int index) {
        JSONItem value = this.valueList.get(index);
        return value.Value();
    }

    public boolean add(Object e) {
        JSONItem value = new JSONItem(e);
        this.valueList.add(value);
        return true;
    }

    public void add(int index, Object element) {
        JSONItem value = new JSONItem(element);
        this.valueList.add(index, value);
    }

    public Object remove(int index) {
        return this.valueList.remove(index);
    }

    public void clear() {
        this.valueList.clear();
    }

    public boolean addAll(JSONArray c) {
        this.valueList.addAll(c.valueList);
        return true;
    }

    public boolean addAll(int index, JSONArray c) {
        this.valueList.addAll(index, c.valueList);
        return true;
    }
}

