/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.odbc.jdbc;

import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.internal.binary.BinaryReaderExImpl;
import org.apache.ignite.internal.binary.BinaryWriterExImpl;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcRequest;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.NotNull;

public class JdbcBulkLoadBatchRequest
extends JdbcRequest {
    public static final int CMD_UNKNOWN = -1;
    public static final int CMD_CONTINUE = 0;
    public static final int CMD_FINISHED_ERROR = 1;
    public static final int CMD_FINISHED_EOF = 2;
    private long qryId;
    private int batchIdx;
    private int cmd;
    private byte[] data;

    public JdbcBulkLoadBatchRequest() {
        super((byte)13);
        this.qryId = -1L;
        this.batchIdx = -1;
        this.cmd = -1;
        this.data = null;
    }

    public JdbcBulkLoadBatchRequest(long qryId, int batchIdx, int cmd) {
        this(qryId, batchIdx, cmd, new byte[0]);
    }

    public JdbcBulkLoadBatchRequest(long qryId, int batchIdx, int cmd, @NotNull byte[] data) {
        super((byte)13);
        this.qryId = qryId;
        this.batchIdx = batchIdx;
        assert (JdbcBulkLoadBatchRequest.isCmdValid(cmd)) : "Invalid command value: " + cmd;
        this.cmd = cmd;
        this.data = data;
    }

    public long queryId() {
        return this.qryId;
    }

    public long batchIdx() {
        return this.batchIdx;
    }

    public int cmd() {
        return this.cmd;
    }

    @NotNull
    public byte[] data() {
        return this.data;
    }

    @Override
    public void writeBinary(BinaryWriterExImpl writer) throws BinaryObjectException {
        super.writeBinary(writer);
        writer.writeLong(this.qryId);
        writer.writeInt(this.batchIdx);
        writer.writeInt(this.cmd);
        writer.writeByteArray(this.data);
    }

    @Override
    public void readBinary(BinaryReaderExImpl reader) throws BinaryObjectException {
        super.readBinary(reader);
        this.qryId = reader.readLong();
        this.batchIdx = reader.readInt();
        int c = reader.readInt();
        if (!JdbcBulkLoadBatchRequest.isCmdValid(c)) {
            throw new BinaryObjectException("Invalid command: " + this.cmd);
        }
        this.cmd = c;
        this.data = reader.readByteArray();
        assert (this.data != null);
    }

    public String toString() {
        return S.toString(JdbcBulkLoadBatchRequest.class, this);
    }

    private static boolean isCmdValid(int c) {
        return c >= 0 && c <= 2;
    }
}

