/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cluster;

import java.io.Serializable;
import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cluster.BaselineTopology;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.jetbrains.annotations.Nullable;

public class DiscoveryDataClusterState
implements Serializable {
    private static final long serialVersionUID = 0L;
    private final boolean active;
    @Nullable
    private final BaselineTopology baselineTopology;
    private final UUID transitionReqId;
    @GridToStringInclude
    private final AffinityTopologyVersion transitionTopVer;
    @GridToStringExclude
    private final Set<UUID> transitionNodes;
    private volatile transient Boolean transitionRes;
    private transient DiscoveryDataClusterState prevState;
    private volatile transient Exception transitionError;

    static DiscoveryDataClusterState createState(boolean active, @Nullable BaselineTopology baselineTopology) {
        return new DiscoveryDataClusterState(null, active, baselineTopology, null, null, null);
    }

    static DiscoveryDataClusterState createTransitionState(DiscoveryDataClusterState prevState, boolean active, @Nullable BaselineTopology baselineTopology, UUID transitionReqId, AffinityTopologyVersion transitionTopVer, Set<UUID> transitionNodes) {
        assert (transitionReqId != null);
        assert (transitionTopVer != null);
        assert (!F.isEmpty(transitionNodes)) : transitionNodes;
        assert (prevState != null);
        return new DiscoveryDataClusterState(prevState, active, baselineTopology, transitionReqId, transitionTopVer, transitionNodes);
    }

    private DiscoveryDataClusterState(DiscoveryDataClusterState prevState, boolean active, @Nullable BaselineTopology baselineTopology, @Nullable UUID transitionReqId, @Nullable AffinityTopologyVersion transitionTopVer, @Nullable Set<UUID> transitionNodes) {
        this.prevState = prevState;
        this.active = active;
        this.baselineTopology = baselineTopology;
        this.transitionReqId = transitionReqId;
        this.transitionTopVer = transitionTopVer;
        this.transitionNodes = transitionNodes;
    }

    @Nullable
    public Boolean transitionResult() {
        return this.transitionRes;
    }

    public void setTransitionResult(UUID reqId, boolean active) {
        if (reqId.equals(this.transitionReqId)) {
            this.transitionRes = active;
        }
    }

    public UUID transitionRequestId() {
        return this.transitionReqId;
    }

    public boolean transition() {
        return this.transitionReqId != null;
    }

    public boolean activeStateChanging() {
        return this.transition() && (this.prevState == null || this.prevState.active != this.active);
    }

    public AffinityTopologyVersion transitionTopologyVersion() {
        return this.transitionTopVer;
    }

    public boolean active() {
        return this.active;
    }

    @Nullable
    public BaselineTopology baselineTopology() {
        return this.baselineTopology;
    }

    public Set<UUID> transitionNodes() {
        return this.transitionNodes;
    }

    @Nullable
    public Exception transitionError() {
        return this.transitionError;
    }

    public void transitionError(Exception ex) {
        this.transitionError = ex;
    }

    public DiscoveryDataClusterState finish(boolean success) {
        return success ? new DiscoveryDataClusterState(null, this.active, this.baselineTopology, null, null, null) : this.prevState;
    }

    public String toString() {
        return S.toString(DiscoveryDataClusterState.class, this);
    }
}

