/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.sql.SQLException;

public final class IgniteQueryErrorCode {
    public static final int UNKNOWN = 1;
    public static final int PARSING = 1001;
    public static final int UNSUPPORTED_OPERATION = 1002;
    public static final int UNEXPECTED_OPERATION = 2001;
    public static final int UNEXPECTED_ELEMENT_TYPE = 2002;
    public static final int KEY_UPDATE = 2003;
    public static final int TABLE_NOT_FOUND = 3001;
    public static final int NULL_TABLE_DESCRIPTOR = 3002;
    public static final int STMT_TYPE_MISMATCH = 3003;
    public static final int TABLE_DROP_FAILED = 3004;
    public static final int INDEX_ALREADY_EXISTS = 3005;
    public static final int INDEX_NOT_FOUND = 3006;
    public static final int TABLE_ALREADY_EXISTS = 3007;
    public static final int COLUMN_NOT_FOUND = 3008;
    public static final int COLUMN_ALREADY_EXISTS = 3009;
    public static final int CONVERSION_FAILED = 3013;
    public static final int DUPLICATE_KEY = 4001;
    public static final int CONCURRENT_UPDATE = 4002;
    public static final int NULL_KEY = 4003;
    public static final int NULL_VALUE = 4004;
    public static final int ENTRY_PROCESSING = 4005;
    public static final int CACHE_NOT_FOUND = 4006;

    private IgniteQueryErrorCode() {
    }

    public static SQLException createJdbcSqlException(String msg, int code) {
        return new SQLException(msg, IgniteQueryErrorCode.codeToSqlState(code));
    }

    public static String codeToSqlState(int statusCode) {
        switch (statusCode) {
            case 4001: {
                return "23000";
            }
            case 4003: 
            case 4004: {
                return "22004";
            }
            case 1002: {
                return "0A000";
            }
            case 3013: {
                return "0700B";
            }
            case 1001: 
            case 2001: 
            case 2002: 
            case 2003: 
            case 3001: 
            case 3003: 
            case 3005: 
            case 3006: 
            case 3007: 
            case 3008: 
            case 3009: {
                return "42000";
            }
        }
        return "50000";
    }
}

