/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.tree.io;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.BPlusIO;
import org.apache.ignite.internal.processors.cache.persistence.tree.util.PageHandler;

public abstract class BPlusLeafIO<L>
extends BPlusIO<L> {
    protected BPlusLeafIO(int type, int ver, int itemSize) {
        super(type, ver, true, true, itemSize);
    }

    @Override
    public int getMaxCount(long pageAddr, int pageSize) {
        return (pageSize - 58) / this.getItemSize();
    }

    @Override
    public final void copyItems(long srcPageAddr, long dstPageAddr, int srcIdx, int dstIdx, int cnt, boolean cpLeft) throws IgniteCheckedException {
        assert (srcIdx != dstIdx || srcPageAddr != dstPageAddr);
        PageHandler.copyMemory(srcPageAddr, (long)this.offset(srcIdx), dstPageAddr, (long)this.offset(dstIdx), (long)(cnt * this.getItemSize()));
    }

    @Override
    public final int offset(int idx) {
        assert (idx >= 0) : idx;
        return 58 + idx * this.getItemSize();
    }
}

