/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.persistence.metastorage;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.cache.persistence.IgniteCacheDatabaseSharedManager;
import org.apache.ignite.internal.processors.cache.persistence.freelist.FreeList;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetaStorage;
import org.apache.ignite.internal.processors.cache.persistence.metastorage.MetastorageDataRow;

public class MetastorageRowStore {
    private final FreeList freeList;
    protected final IgniteCacheDatabaseSharedManager db;

    public MetastorageRowStore(FreeList freeList, IgniteCacheDatabaseSharedManager db) {
        this.freeList = freeList;
        this.db = db;
    }

    public MetastorageDataRow dataRow(String key, long link) throws IgniteCheckedException {
        return ((MetaStorage.FreeListImpl)this.freeList).readRow(key, link);
    }

    public void removeRow(long link) throws IgniteCheckedException {
        assert (link != 0L);
        this.db.checkpointReadLock();
        try {
            this.freeList.removeDataRowByLink(link);
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }

    public void addRow(MetastorageDataRow row) throws IgniteCheckedException {
        this.db.checkpointReadLock();
        try {
            this.freeList.insertDataRow(row);
        }
        finally {
            this.db.checkpointReadUnlock();
        }
    }

    public boolean updateRow(long link, MetastorageDataRow row) throws IgniteCheckedException {
        return this.freeList.updateDataRow(link, row);
    }

    public FreeList freeList() {
        return this.freeList;
    }
}

