/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.cache.Cache;
import org.apache.ignite.cache.CacheEntry;
import org.apache.ignite.internal.processors.cache.CacheEntryImplEx;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;

public class CacheEntryImpl<K, V>
implements Cache.Entry<K, V>,
Externalizable {
    private static final long serialVersionUID = 0L;
    private K key;
    private V val;
    private GridCacheVersion ver;

    public CacheEntryImpl() {
    }

    public CacheEntryImpl(K key, V val) {
        this.key = key;
        this.val = val;
    }

    public CacheEntryImpl(K key, V val, GridCacheVersion ver) {
        this.key = key;
        this.val = val;
        this.ver = ver;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.val;
    }

    public <T> T unwrap(Class<T> cls) {
        if (cls.isAssignableFrom(this.getClass())) {
            return cls.cast(this);
        }
        if (cls.isAssignableFrom(CacheEntry.class)) {
            return (T)new CacheEntryImplEx<K, V>(this.key, this.val, this.ver);
        }
        throw new IllegalArgumentException("Unwrapping to class is not supported: " + cls);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.key);
        out.writeObject(this.val);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.key = in.readObject();
        this.val = in.readObject();
    }

    public String toString() {
        return "Entry [key=" + this.key + ", val=" + this.val + ']';
    }
}

