/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem;

import org.apache.ignite.internal.util.typedef.internal.U;

public final class PageIdUtils {
    public static final int PAGE_IDX_SIZE = 32;
    public static final int PART_ID_SIZE = 16;
    public static final int FLAG_SIZE = 8;
    public static final int OFFSET_SIZE = 8;
    public static final int TAG_SIZE = 16;
    public static final long PAGE_IDX_MASK = 0xFFFFFFFFL;
    public static final long OFFSET_MASK = 255L;
    public static final long TAG_MASK = 65535L;
    public static final long PART_ID_MASK = 65535L;
    public static final long FLAG_MASK = 255L;
    private static final long EFFECTIVE_PAGE_ID_MASK = 0xFFFFFFFFFFFFL;
    private static final long PAGE_ID_MASK = 0xFFFFFFFFFFFFFFL;
    public static final int MAX_ITEMID_NUM = 254;
    public static final long MAX_PAGE_NUM = 0xFFFFFFFFL;
    public static final int MAX_PART_ID = 65535;

    private PageIdUtils() {
    }

    public static long link(long pageId, int itemId) {
        assert (itemId >= 0 && itemId <= 254) : itemId;
        assert (pageId >> 56 == 0L) : U.hexLong(pageId);
        return pageId | (long)itemId << 56;
    }

    public static int pageIndex(long pageId) {
        return (int)(pageId & 0xFFFFFFFFL);
    }

    public static long pageId(long link) {
        return PageIdUtils.flag(link) == 2 ? link : link & 0xFFFFFFFFFFFFFFL;
    }

    public static long effectivePageId(long link) {
        return link & 0xFFFFFFFFFFFFL;
    }

    public static boolean isEffectivePageId(long pageId) {
        return (pageId & 0xFFFF000000000000L) == 0L;
    }

    public static int itemId(long link) {
        return (int)(link >> 56 & 0xFFL);
    }

    public static int tag(long link) {
        return (int)(link >> 48 & 0xFFFFL);
    }

    public static long pageId(int partId, byte flag, int pageIdx) {
        long pageId = (long)flag & 0xFFL;
        pageId = pageId << 16 | (long)partId & 0xFFFFL;
        pageId = pageId << 32 | (long)pageIdx & 0xFFFFFFFFL;
        return pageId;
    }

    public static byte flag(long pageId) {
        return (byte)(pageId >>> 48 & 0xFFL);
    }

    public static int partId(long pageId) {
        return (int)(pageId >>> 32 & 0xFFFFL);
    }

    public static long rotatePageId(long pageId) {
        long updatedRotationId = (pageId >> 56) + 1L;
        return pageId & 0xFFFFFFFFFFFFFFL | updatedRotationId << 56;
    }

    public static long maskPartitionId(long pageId) {
        return pageId & 0xFFFF0000FFFFFFFFL;
    }

    public static long changeType(long pageId, byte type) {
        return PageIdUtils.pageId(PageIdUtils.partId(pageId), type, PageIdUtils.pageIndex(pageId));
    }

    public static String toDetailString(long pageId) {
        return "pageId=" + pageId + "(offset=" + PageIdUtils.itemId(pageId) + ", flags=" + Integer.toBinaryString(PageIdUtils.flag(pageId)) + ", partId=" + PageIdUtils.partId(pageId) + ", index=" + PageIdUtils.pageIndex(pageId) + ")";
    }

    public static long changePartitionId(long pageId, int partId) {
        byte flag = PageIdUtils.flag(pageId);
        int pageIdx = PageIdUtils.pageIndex(pageId);
        return PageIdUtils.pageId(partId, flag, pageIdx);
    }
}

