/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.util;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestLRUDictionary {
    LRUDictionary testee;

    @Before
    public void setUp() throws Exception {
        this.testee = new LRUDictionary();
        this.testee.init(Short.MAX_VALUE);
    }

    @Test
    public void TestContainsNothing() {
        Assert.assertTrue((boolean)TestLRUDictionary.isDictionaryEmpty(this.testee));
    }

    @Test
    public void testPassingEmptyArrayToFindEntry() {
        Assert.assertEquals((long)-1L, (long)this.testee.findEntry(HConstants.EMPTY_BYTE_ARRAY, 0, 0));
        Assert.assertEquals((long)-1L, (long)this.testee.addEntry(HConstants.EMPTY_BYTE_ARRAY, 0, 0));
    }

    @Test
    public void testPassingSameArrayToAddEntry() {
        int len = HConstants.CATALOG_FAMILY.length;
        short index = this.testee.addEntry(HConstants.CATALOG_FAMILY, 0, len);
        Assert.assertFalse((index == this.testee.addEntry(HConstants.CATALOG_FAMILY, 0, len) ? 1 : 0) != 0);
        Assert.assertFalse((index == this.testee.addEntry(HConstants.CATALOG_FAMILY, 0, len) ? 1 : 0) != 0);
    }

    @Test
    public void testBasic() {
        Random rand = new Random();
        byte[] testBytes = new byte[10];
        rand.nextBytes(testBytes);
        Assert.assertEquals((long)this.testee.findEntry(testBytes, 0, testBytes.length), (long)-1L);
        Assert.assertFalse((boolean)TestLRUDictionary.isDictionaryEmpty(this.testee));
        short t = this.testee.findEntry(testBytes, 0, testBytes.length);
        Assert.assertTrue((t != -1 ? 1 : 0) != 0);
        byte[] testBytesCopy = new byte[20];
        Bytes.putBytes((byte[])testBytesCopy, (int)10, (byte[])testBytes, (int)0, (int)testBytes.length);
        Assert.assertEquals((long)this.testee.findEntry(testBytesCopy, 10, testBytes.length), (long)t);
        Assert.assertTrue((boolean)Arrays.equals(testBytes, this.testee.getEntry(t)));
        this.testee.clear();
        Assert.assertTrue((boolean)TestLRUDictionary.isDictionaryEmpty(this.testee));
    }

    @Test
    public void TestLRUPolicy() {
        int i;
        for (i = 0; i < Short.MAX_VALUE; ++i) {
            this.testee.findEntry(BigInteger.valueOf(i).toByteArray(), 0, BigInteger.valueOf(i).toByteArray().length);
        }
        Assert.assertTrue((this.testee.findEntry(BigInteger.ZERO.toByteArray(), 0, BigInteger.ZERO.toByteArray().length) != -1 ? 1 : 0) != 0);
        Assert.assertTrue((this.testee.findEntry(BigInteger.valueOf(Integer.MAX_VALUE).toByteArray(), 0, BigInteger.valueOf(Integer.MAX_VALUE).toByteArray().length) == -1 ? 1 : 0) != 0);
        Assert.assertTrue((this.testee.findEntry(BigInteger.valueOf(Integer.MAX_VALUE).toByteArray(), 0, BigInteger.valueOf(Integer.MAX_VALUE).toByteArray().length) != -1 ? 1 : 0) != 0);
        Assert.assertTrue((this.testee.findEntry(BigInteger.ZERO.toByteArray(), 0, BigInteger.ZERO.toByteArray().length) != -1 ? 1 : 0) != 0);
        for (i = 1; i < Short.MAX_VALUE; ++i) {
            Assert.assertTrue((this.testee.findEntry(BigInteger.valueOf(i).toByteArray(), 0, BigInteger.valueOf(i).toByteArray().length) == -1 ? 1 : 0) != 0);
        }
        for (i = 0; i < Short.MAX_VALUE; ++i) {
            Assert.assertTrue((this.testee.findEntry(BigInteger.valueOf(i).toByteArray(), 0, BigInteger.valueOf(i).toByteArray().length) != -1 ? 1 : 0) != 0);
        }
    }

    private static boolean isDictionaryEmpty(LRUDictionary dict) {
        try {
            dict.getEntry((short)0);
            return false;
        }
        catch (IndexOutOfBoundsException ioobe) {
            return true;
        }
    }
}

