/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ignite.internal.processors.query.h2.H2TableDescriptor;
import org.apache.ignite.internal.processors.query.h2.database.H2RowFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.h2.api.TableEngine;
import org.h2.command.ddl.CreateTableData;
import org.h2.table.TableBase;

public class H2TableEngine
implements TableEngine {
    private static GridH2RowDescriptor rowDesc0;
    private static H2RowFactory rowFactory0;
    private static H2TableDescriptor tblDesc0;
    private static GridH2Table resTbl0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized GridH2Table createTable(Connection conn, String sql, GridH2RowDescriptor rowDesc, H2RowFactory rowFactory, H2TableDescriptor tblDesc) throws SQLException {
        rowDesc0 = rowDesc;
        rowFactory0 = rowFactory;
        tblDesc0 = tblDesc;
        try {
            try (Statement s = conn.createStatement();){
                s.execute(sql + " engine \"" + H2TableEngine.class.getName() + "\"");
            }
            tblDesc.table(resTbl0);
            GridH2Table gridH2Table = resTbl0;
            return gridH2Table;
        }
        finally {
            resTbl0 = null;
            tblDesc0 = null;
            rowFactory0 = null;
            rowDesc0 = null;
        }
    }

    public TableBase createTable(CreateTableData createTblData) {
        resTbl0 = new GridH2Table(createTblData, rowDesc0, rowFactory0, tblDesc0, tblDesc0.cache());
        return resTbl0;
    }
}

