/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.UUID;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;
import org.apache.ignite.internal.visor.cache.VisorCacheModifyTaskArg;
import org.apache.ignite.internal.visor.cache.VisorCacheModifyTaskResult;
import org.apache.ignite.internal.visor.cache.VisorModifyCacheMode;
import org.apache.ignite.internal.visor.query.VisorQueryUtils;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;

@GridInternal
public class VisorCacheModifyTask
extends VisorOneNodeTask<VisorCacheModifyTaskArg, VisorCacheModifyTaskResult> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheModifyJob job(VisorCacheModifyTaskArg arg) {
        return new VisorCacheModifyJob(arg, this.debug);
    }

    private static class VisorCacheModifyJob
    extends VisorJob<VisorCacheModifyTaskArg, VisorCacheModifyTaskResult> {
        private static final long serialVersionUID = 0L;

        private VisorCacheModifyJob(VisorCacheModifyTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        @Override
        protected VisorCacheModifyTaskResult run(VisorCacheModifyTaskArg arg) {
            assert (arg != null);
            VisorModifyCacheMode mode = arg.getMode();
            String cacheName = arg.getCacheName();
            Object key = arg.getKey();
            assert (mode != null);
            assert (cacheName != null);
            assert (key != null);
            IgniteCache<Object, Object> cache = this.ignite.cache(cacheName);
            if (cache == null) {
                throw new IllegalArgumentException("Failed to find cache with specified name [cacheName=" + arg.getCacheName() + "]");
            }
            ClusterNode node = this.ignite.affinity(cacheName).mapKeyToNode(key);
            UUID nid = node != null ? node.id() : null;
            switch (mode) {
                case PUT: {
                    Object old = cache.get(key);
                    cache.put(key, arg.getValue());
                    return new VisorCacheModifyTaskResult(nid, VisorTaskUtils.compactClass(old), VisorQueryUtils.convertValue(old));
                }
                case GET: {
                    Object value = cache.get(key);
                    return new VisorCacheModifyTaskResult(nid, VisorTaskUtils.compactClass(value), VisorQueryUtils.convertValue(value));
                }
                case REMOVE: {
                    Object removed = cache.get(key);
                    cache.remove(key);
                    return new VisorCacheModifyTaskResult(nid, VisorTaskUtils.compactClass(removed), VisorQueryUtils.convertValue(removed));
                }
            }
            return new VisorCacheModifyTaskResult(nid, null, null);
        }

        public String toString() {
            return S.toString(VisorCacheModifyJob.class, this);
        }
    }
}

