/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.suggestions;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridPerformanceSuggestions {
    private static final String SUGGESTIONS_LINK = "https://apacheignite.readme.io/docs/jvm-and-system-tuning";
    private static final boolean disabled = Boolean.getBoolean("IGNITE_PERFORMANCE_SUGGESTIONS_DISABLED");
    private final Collection<String> perfs = !disabled ? new LinkedHashSet() : null;
    private final Collection<String> suppressed = !disabled ? new HashSet() : null;

    public synchronized void addAll(List<String> suggestions) {
        for (String suggestion : suggestions) {
            this.add(suggestion);
        }
    }

    public synchronized void add(String sug) {
        this.add(sug, false);
    }

    public synchronized void add(String sug, boolean suppress) {
        if (disabled) {
            return;
        }
        if (!suppress) {
            this.perfs.add(sug);
        } else {
            this.suppressed.add(sug);
        }
    }

    public synchronized void logSuggestions(IgniteLogger log, @Nullable String igniteInstanceName) {
        if (disabled) {
            return;
        }
        if (!F.isEmpty(this.perfs) && !this.suppressed.containsAll(this.perfs)) {
            U.quietAndInfo(log, "Performance suggestions for grid " + (igniteInstanceName == null ? "" : '\'' + igniteInstanceName + '\'') + " (fix if possible)");
            U.quietAndInfo(log, "To disable, set -DIGNITE_PERFORMANCE_SUGGESTIONS_DISABLED=true");
            for (String s : this.perfs) {
                if (this.suppressed.contains(s)) continue;
                U.quietAndInfo(log, "  ^-- " + s);
            }
            this.perfs.clear();
        }
        U.quietAndInfo(log, "Refer to this page for more performance suggestions: https://apacheignite.readme.io/docs/jvm-and-system-tuning");
        U.quietAndInfo(log, "");
    }

    public String toString() {
        return S.toString(GridPerformanceSuggestions.class, this);
    }
}

