/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.hadoop;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URI;
import java.util.Arrays;
import org.apache.ignite.hadoop.HadoopInputSplit;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.S;

public class HadoopFileBlock
extends HadoopInputSplit {
    private static final long serialVersionUID = 0L;
    @GridToStringInclude
    protected URI file;
    @GridToStringInclude
    protected long start;
    @GridToStringInclude
    protected long len;

    public HadoopFileBlock() {
    }

    public HadoopFileBlock(String[] hosts, URI file, long start, long len) {
        A.notNull(hosts, "hosts", file, "file");
        this.hosts = hosts;
        this.file = file;
        this.start = start;
        this.len = len;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.file());
        out.writeLong(this.start());
        out.writeLong(this.length());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.file = (URI)in.readObject();
        this.start = in.readLong();
        this.len = in.readLong();
    }

    public long length() {
        return this.len;
    }

    public void length(long len) {
        this.len = len;
    }

    public long start() {
        return this.start;
    }

    public void start(long start) {
        this.start = start;
    }

    public URI file() {
        return this.file;
    }

    public void file(URI file) {
        this.file = file;
    }

    public void hosts(String[] hosts) {
        A.notNull(hosts, "hosts");
        this.hosts = hosts;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HadoopFileBlock)) {
            return false;
        }
        HadoopFileBlock that = (HadoopFileBlock)o;
        return this.len == that.len && this.start == that.start && this.file.equals(that.file);
    }

    @Override
    public int hashCode() {
        int res = this.file.hashCode();
        res = 31 * res + (int)(this.start ^ this.start >>> 32);
        res = 31 * res + (int)(this.len ^ this.len >>> 32);
        return res;
    }

    public String toString() {
        return S.toString(HadoopFileBlock.class, this, "hosts", Arrays.toString(this.hosts));
    }
}

