/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.distributed.dht.GridDhtPartitionState;
import org.apache.ignite.internal.util.GridPartitionStateMap;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class GridDhtPartitionMap
implements Comparable<GridDhtPartitionMap>,
Externalizable {
    private static final long serialVersionUID = 0L;
    protected UUID nodeId;
    protected long updateSeq;
    protected AffinityTopologyVersion top;
    protected GridPartitionStateMap map;
    private volatile int moving;
    private static final AtomicIntegerFieldUpdater<GridDhtPartitionMap> MOVING_FIELD_UPDATER = AtomicIntegerFieldUpdater.newUpdater(GridDhtPartitionMap.class, "moving");

    public GridDhtPartitionMap() {
    }

    public GridDhtPartitionMap(UUID nodeId, long updateSeq, AffinityTopologyVersion top, GridPartitionStateMap m, boolean onlyActive) {
        assert (nodeId != null);
        assert (updateSeq > 0L);
        this.nodeId = nodeId;
        this.updateSeq = updateSeq;
        this.top = top;
        this.map = new GridPartitionStateMap(m, onlyActive);
        int moving0 = 0;
        for (GridDhtPartitionState state : this.map.values()) {
            if (state != GridDhtPartitionState.MOVING) continue;
            ++moving0;
        }
        if (moving0 > 0) {
            MOVING_FIELD_UPDATER.set(this, moving0);
        }
    }

    private GridDhtPartitionMap(UUID nodeId, long updateSeq, AffinityTopologyVersion top, GridPartitionStateMap map, int moving) {
        this.nodeId = nodeId;
        this.updateSeq = updateSeq;
        this.top = top;
        this.map = map;
        this.moving = moving;
    }

    public GridDhtPartitionMap emptyCopy() {
        return new GridDhtPartitionMap(this.nodeId, this.updateSeq, this.top, new GridPartitionStateMap(0), 0);
    }

    public void put(Integer part, GridDhtPartitionState state) {
        GridDhtPartitionState old = this.map.put(part, state);
        if (old == GridDhtPartitionState.MOVING && state != GridDhtPartitionState.MOVING) {
            MOVING_FIELD_UPDATER.decrementAndGet(this);
        } else if (old != GridDhtPartitionState.MOVING && state == GridDhtPartitionState.MOVING) {
            MOVING_FIELD_UPDATER.incrementAndGet(this);
        }
        assert (this.moving >= 0) : this.moving;
    }

    public boolean hasMovingPartitions() {
        assert (this.moving >= 0) : this.moving;
        return this.moving != 0;
    }

    public GridDhtPartitionState get(Integer part) {
        return this.map.get(part);
    }

    public boolean containsKey(Integer part) {
        return this.map.containsKey(part);
    }

    public Set<Map.Entry<Integer, GridDhtPartitionState>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public Set<Integer> keySet() {
        return this.map.keySet();
    }

    public GridPartitionStateMap map() {
        return this.map;
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public long updateSequence() {
        return this.updateSeq;
    }

    public long updateSequence(long updateSeq, AffinityTopologyVersion topVer) {
        assert (topVer.compareTo(this.top) >= 0) : "Invalid topology version [cur=" + this.top + ", new=" + topVer + "]";
        long old = this.updateSeq;
        if (topVer.compareTo(this.top) == 0) assert (updateSeq >= old) : "Invalid update sequence [cur=" + old + ", new=" + updateSeq + ']';
        this.updateSeq = updateSeq;
        this.top = topVer;
        return old;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.top;
    }

    @Override
    public int compareTo(GridDhtPartitionMap o) {
        assert (this.nodeId.equals(o.nodeId));
        int topVerCompare = this.top.compareTo(o.top);
        if (topVerCompare != 0) {
            return topVerCompare;
        }
        return Long.compare(this.updateSeq, o.updateSeq);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.nodeId);
        out.writeLong(this.updateSeq);
        int size = this.map.size();
        out.writeInt(size);
        int i = 0;
        for (Map.Entry<Integer, GridDhtPartitionState> entry : this.map.entrySet()) {
            int ordinal = entry.getValue().ordinal();
            assert (ordinal == (ordinal & 7));
            assert (entry.getKey() < 65000) : entry.getKey();
            out.writeByte(ordinal);
            out.writeShort(entry.getKey());
            ++i;
        }
        assert (i == size) : "Invalid size [size1=" + size + ", size2=" + i + ']';
        if (this.top != null) {
            out.writeLong(this.topologyVersion().topologyVersion());
            out.writeInt(this.topologyVersion().minorTopologyVersion());
        } else {
            out.writeLong(0L);
            out.writeInt(0);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = U.readUuid(in);
        this.updateSeq = in.readLong();
        int size = in.readInt();
        this.map = new GridPartitionStateMap();
        for (int i = 0; i < size; ++i) {
            int ordinal = in.readUnsignedByte();
            int part = in.readUnsignedShort();
            this.put(part, GridDhtPartitionState.fromOrdinal(ordinal));
        }
        long ver = in.readLong();
        int minorVer = in.readInt();
        if (ver != 0L) {
            this.top = new AffinityTopologyVersion(ver, minorVer);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        GridDhtPartitionMap other = (GridDhtPartitionMap)o;
        return other.nodeId.equals(this.nodeId) && other.updateSeq == this.updateSeq;
    }

    public int hashCode() {
        return 31 * this.nodeId.hashCode() + (int)(this.updateSeq ^ this.updateSeq >>> 32);
    }

    public String toFullString() {
        return S.toString(GridDhtPartitionMap.class, this, "top", this.top, "updateSeq", (Object)this.updateSeq, "size", this.size(), "map", this.map.toString());
    }

    public String toString() {
        return S.toString(GridDhtPartitionMap.class, this, "top", (Object)this.top, "updateSeq", this.updateSeq, "size", this.size());
    }
}

