/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricsExecutor;

@InterfaceAudience.Private
public class MetricsExecutorImpl
implements MetricsExecutor {
    public ScheduledExecutorService getExecutor() {
        return ExecutorSingleton.INSTANCE.scheduler;
    }

    public void stop() {
        if (!this.getExecutor().isShutdown()) {
            this.getExecutor().shutdown();
        }
    }

    private static final class ThreadPoolExecutorThreadFactory
    implements ThreadFactory {
        private final String name;
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        private ThreadPoolExecutorThreadFactory(String name) {
            this.name = name;
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread t = new Thread(runnable, this.name + this.threadNumber.getAndIncrement());
            t.setDaemon(true);
            return t;
        }
    }

    private static enum ExecutorSingleton {
        INSTANCE;

        private final ScheduledExecutorService scheduler = new ScheduledThreadPoolExecutor(1, new ThreadPoolExecutorThreadFactory("HBase-Metrics2-"));
    }
}

