/*
 * Decompiled with CFR 0.152.
 */
package org.zillion.util.common;

import java.util.List;

public class HexToByte {
    public static byte[] hexToByte(String hex) {
        return HexToByte.hexToByte(hex, false);
    }

    public static byte[] hexToByte(String hex, boolean hasspace) {
        byte[] result;
        if (hasspace) {
            result = new byte[(hex.length() + 1) / 3];
            int i = 0;
            while (i < result.length) {
                result[i] = Integer.decode("0x" + hex.substring(i * 3, i * 3 + 2)).byteValue();
                ++i;
            }
        } else {
            result = new byte[hex.length() / 2];
            int i = 0;
            while (i < result.length) {
                result[i] = Integer.decode("0x" + hex.substring(i * 2, i * 2 + 2)).byteValue();
                ++i;
            }
        }
        return result;
    }

    public static String byteToHex(byte[] bytes) {
        return HexToByte.byteToHex(bytes, false);
    }

    public static String byteToHex(byte[] bytes, boolean hasspace) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.length) {
            if (hasspace && i > 0) {
                sb.append(" ");
            }
            int temp = (bytes[i] + 256) % 256;
            sb.append(HexToByte.getHexChar(temp / 16) + HexToByte.getHexChar(temp % 16));
            ++i;
        }
        return sb.toString();
    }

    public static String byteToHex(List<Byte> bytes) {
        return HexToByte.byteToHex(bytes, false);
    }

    public static String byteToHex(List<Byte> bytes, boolean hasspace) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < bytes.size()) {
            if (hasspace && i > 0) {
                sb.append(" ");
            }
            int temp = (bytes.get(i) + 256) % 256;
            sb.append(HexToByte.getHexChar(temp / 16) + HexToByte.getHexChar(temp % 16));
            ++i;
        }
        return sb.toString();
    }

    public static String byteToHex(List<Byte> bytes, int length) {
        return HexToByte.byteToHex(bytes, false);
    }

    public static String byteToHex(List<Byte> bytes, int length, boolean hasspace) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (hasspace && i > 0) {
                sb.append(" ");
            }
            int temp = (bytes.get(i) + 256) % 256;
            sb.append(HexToByte.getHexChar(temp / 16) + HexToByte.getHexChar(temp % 16));
            ++i;
        }
        return sb.toString();
    }

    public static String byteToHex(byte[] bytes, int length) {
        return HexToByte.byteToHex(bytes, false);
    }

    public static String byteToHex(byte[] bytes, int length, boolean hasspace) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < length) {
            if (hasspace && i > 0) {
                sb.append(" ");
            }
            int temp = (bytes[i] + 256) % 256;
            sb.append(HexToByte.getHexChar(temp / 16) + HexToByte.getHexChar(temp % 16));
            ++i;
        }
        return sb.toString();
    }

    private static String getHexChar(int number) {
        String result = number < 10 ? "" + number : "" + (char)(number - 10 + 65);
        return result;
    }

    public static byte[] setVerify(byte[] bytes) {
        int number = 0;
        int i = 2;
        while (i < bytes.length - 2) {
            number += (bytes[i] + 256) % 256;
            ++i;
        }
        bytes[bytes.length - 2] = (byte)(number % 256);
        bytes[bytes.length - 1] = (byte)(number / 256);
        return bytes;
    }
}

