/*
 * Decompiled with CFR 0.152.
 */
package com.zillion.util.table;

import com.zillion.util.common.ZillionConstant;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.io.compress.Compression;

public class HBaseAdminUtil {
    public static boolean tableExists(Admin admin, TableName tableName) throws Exception {
        return admin.tableExists(tableName);
    }

    public static void CreateNamespace(Admin admin, Admin admin_bak, String namespace) throws Exception {
        NamespaceDescriptor namespaceDesc;
        if (admin_bak != null) {
            namespaceDesc = NamespaceDescriptor.create((String)namespace).build();
            admin_bak.createNamespace(namespaceDesc);
        }
        namespaceDesc = NamespaceDescriptor.create((String)namespace).build();
        admin.createNamespace(namespaceDesc);
    }

    public static void DeleteNamespace(Admin admin, Admin admin_bak, String namespace) throws Exception {
        admin.deleteNamespace(namespace);
        if (admin_bak != null) {
            admin_bak.deleteNamespace(namespace);
        }
    }

    public static void createTable(Admin admin, Admin admin_bak, TableName tableName, String[] familyNames, byte[][] splitKeys, boolean inMemory, Compression.Algorithm algo) throws Exception {
        HColumnDescriptor coldef;
        int maxVersions;
        String familyName;
        int i;
        HTableDescriptor desc;
        int[] maxVersions_array;
        if (admin_bak != null) {
            maxVersions_array = new int[]{1};
            desc = new HTableDescriptor(tableName);
            i = 0;
            while (i < familyNames.length) {
                familyName = familyNames[i];
                maxVersions = maxVersions_array[i];
                coldef = new HColumnDescriptor(familyName);
                coldef.setMaxVersions(maxVersions);
                coldef.setInMemory(inMemory);
                if (algo != Compression.Algorithm.NONE) {
                    coldef.setCompressionType(algo);
                    coldef.setCompactionCompressionType(algo);
                }
                desc.addFamily(coldef);
                ++i;
            }
            if (splitKeys != null) {
                admin_bak.createTable(desc, splitKeys);
            } else {
                admin_bak.createTable(desc);
            }
        }
        maxVersions_array = new int[]{1};
        desc = new HTableDescriptor(tableName);
        i = 0;
        while (i < familyNames.length) {
            familyName = familyNames[i];
            maxVersions = maxVersions_array[i];
            coldef = new HColumnDescriptor(familyName);
            coldef.setMaxVersions(maxVersions);
            coldef.setInMemory(inMemory);
            if (algo != Compression.Algorithm.NONE) {
                coldef.setCompressionType(algo);
                coldef.setCompactionCompressionType(algo);
            }
            if (admin_bak != null) {
                coldef.setScope(1);
            }
            desc.addFamily(coldef);
            ++i;
        }
        if (splitKeys != null) {
            admin.createTable(desc, splitKeys);
        } else {
            admin.createTable(desc);
        }
    }

    public static void modifyColumn_compression(Admin admin, Admin admin_bak, TableName tableName, String[] familyNames, Compression.Algorithm algo) throws Exception {
        HColumnDescriptor coldef;
        String familyName;
        int i;
        if (admin_bak != null) {
            i = 0;
            while (i < familyNames.length) {
                familyName = familyNames[i];
                coldef = new HColumnDescriptor(familyName);
                coldef.setCompressionType(algo);
                coldef.setCompactionCompressionType(algo);
                admin_bak.modifyColumn(tableName, coldef);
                ++i;
            }
            if (ZillionConstant.alter_compress_major_compact) {
                admin_bak.majorCompact(tableName);
            }
        }
        i = 0;
        while (i < familyNames.length) {
            familyName = familyNames[i];
            coldef = new HColumnDescriptor(familyName);
            coldef.setCompressionType(algo);
            coldef.setCompactionCompressionType(algo);
            admin.modifyColumn(tableName, coldef);
            ++i;
        }
        if (ZillionConstant.alter_compress_major_compact) {
            admin.majorCompact(tableName);
        }
    }

    public static void modifyColumn_in_memory(Admin admin, Admin admin_bak, TableName tableName, String[] familyNames, boolean enable) throws Exception {
        HColumnDescriptor coldef;
        String familyName;
        int i;
        if (admin_bak != null) {
            i = 0;
            while (i < familyNames.length) {
                familyName = familyNames[i];
                coldef = new HColumnDescriptor(familyName);
                coldef.setInMemory(enable);
                admin_bak.modifyColumn(tableName, coldef);
                ++i;
            }
        }
        i = 0;
        while (i < familyNames.length) {
            familyName = familyNames[i];
            coldef = new HColumnDescriptor(familyName);
            coldef.setInMemory(enable);
            admin.modifyColumn(tableName, coldef);
            ++i;
        }
    }

    public static void deleteTable(Admin admin, Admin admin_bak, TableName tableName) throws Exception {
        if (admin.tableExists(tableName)) {
            if (admin.isTableEnabled(tableName)) {
                admin.disableTable(tableName);
            }
            admin.deleteTable(tableName);
        }
        if (admin_bak != null && admin_bak.tableExists(tableName)) {
            if (admin_bak.isTableEnabled(tableName)) {
                admin_bak.disableTable(tableName);
            }
            admin_bak.deleteTable(tableName);
        }
    }

    public static void clearTable(Admin admin, Admin admin_bak, TableName tableName) throws Exception {
        if (admin.tableExists(tableName)) {
            if (admin.isTableEnabled(tableName)) {
                admin.disableTable(tableName);
            }
            admin.truncateTable(tableName, true);
        }
        if (admin_bak != null && admin_bak.tableExists(tableName)) {
            if (admin_bak.isTableEnabled(tableName)) {
                admin_bak.disableTable(tableName);
            }
            admin_bak.truncateTable(tableName, true);
        }
    }
}

