/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.internal.processors.query.GridQueryFieldMetadata;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class H2SqlFieldMetadata
implements GridQueryFieldMetadata {
    private static final long serialVersionUID = 0L;
    private String schemaName;
    private String typeName;
    private String name;
    private String type;

    public H2SqlFieldMetadata() {
    }

    H2SqlFieldMetadata(@Nullable String schemaName, @Nullable String typeName, String name, String type) {
        assert (name != null && type != null) : schemaName + " | " + typeName + " | " + name + " | " + type;
        this.schemaName = schemaName;
        this.typeName = typeName;
        this.name = name;
        this.type = type;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public String typeName() {
        return this.typeName;
    }

    public String fieldName() {
        return this.name;
    }

    public String fieldTypeName() {
        return this.type;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeString((DataOutput)out, (String)this.schemaName);
        U.writeString((DataOutput)out, (String)this.typeName);
        U.writeString((DataOutput)out, (String)this.name);
        U.writeString((DataOutput)out, (String)this.type);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.schemaName = U.readString((DataInput)in);
        this.typeName = U.readString((DataInput)in);
        this.name = U.readString((DataInput)in);
        this.type = U.readString((DataInput)in);
    }

    public String toString() {
        return S.toString(H2SqlFieldMetadata.class, (Object)this);
    }
}

