/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Row;
import org.apache.ignite.internal.util.lang.GridCursor;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.h2.index.Cursor;
import org.h2.message.DbException;
import org.h2.result.Row;
import org.h2.result.SearchRow;

public class H2Cursor
implements Cursor {
    private final GridCursor<GridH2Row> cursor;
    private final long time = U.currentTimeMillis();

    public H2Cursor(GridCursor<GridH2Row> cursor) {
        assert (cursor != null);
        this.cursor = cursor;
    }

    public Row get() {
        try {
            return (Row)this.cursor.get();
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public SearchRow getSearchRow() {
        return this.get();
    }

    public boolean next() {
        try {
            while (this.cursor.next()) {
                GridH2Row row = (GridH2Row)this.cursor.get();
                if (row.expireTime() > 0L && row.expireTime() <= this.time) continue;
                return true;
            }
            return false;
        }
        catch (IgniteCheckedException e) {
            throw DbException.convert((Throwable)e);
        }
    }

    public boolean previous() {
        throw DbException.getUnsupportedException((String)"previous");
    }
}

