/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.lang;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.binary.BinaryRawReader;
import org.apache.ignite.binary.BinaryRawWriter;
import org.apache.ignite.binary.BinaryReader;
import org.apache.ignite.binary.BinaryWriter;
import org.apache.ignite.binary.Binarylizable;
import org.apache.ignite.internal.util.lang.GridIterator;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgnitePredicate;

public final class IgniteUuid
implements Comparable<IgniteUuid>,
Iterable<IgniteUuid>,
Cloneable,
Externalizable,
Binarylizable {
    private static final long serialVersionUID = 0L;
    public static final UUID VM_ID = UUID.randomUUID();
    private static final AtomicLong cntGen = new AtomicLong(U.currentTimeMillis());
    private UUID gid;
    private long locId;

    public IgniteUuid() {
    }

    public IgniteUuid(UUID gid, long locId) {
        assert (gid != null);
        this.gid = gid;
        this.locId = locId;
    }

    public static UUID vmId() {
        return VM_ID;
    }

    public static long lastLocalId() {
        return cntGen.get();
    }

    public static IgniteUuid randomUuid() {
        return new IgniteUuid(VM_ID, cntGen.incrementAndGet());
    }

    public static IgniteUuid fromUuid(UUID id) {
        A.notNull(id, "id");
        return new IgniteUuid(id, cntGen.getAndIncrement());
    }

    public static IgniteUuid fromString(String s) {
        int firstDash = s.indexOf(45);
        return new IgniteUuid(UUID.fromString(s.substring(firstDash + 1)), Long.valueOf(new StringBuilder(s.substring(0, firstDash)).reverse().toString(), 16));
    }

    public String shortString() {
        return new StringBuilder(Long.toHexString(this.locId)).reverse().toString();
    }

    public UUID globalId() {
        return this.gid;
    }

    public long localId() {
        return this.locId;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.gid);
        out.writeLong(this.locId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.gid = U.readUuid(in);
        this.locId = in.readLong();
    }

    @Override
    public int compareTo(IgniteUuid o) {
        if (o == this) {
            return 0;
        }
        if (o == null) {
            return 1;
        }
        int res = Long.compare(this.locId, o.locId);
        if (res == 0) {
            res = this.gid.compareTo(o.globalId());
        }
        return res;
    }

    @Override
    public GridIterator<IgniteUuid> iterator() {
        return F.iterator(Collections.singleton(this), F.identity(), true, new IgnitePredicate[0]);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IgniteUuid)) {
            return false;
        }
        IgniteUuid that = (IgniteUuid)obj;
        return that.locId == this.locId && that.gid.equals(this.gid);
    }

    @Override
    public void writeBinary(BinaryWriter writer) throws BinaryObjectException {
        BinaryRawWriter out = writer.rawWriter();
        out.writeLong(this.locId);
        out.writeLong(this.gid.getMostSignificantBits());
        out.writeLong(this.gid.getLeastSignificantBits());
    }

    @Override
    public void readBinary(BinaryReader reader) throws BinaryObjectException {
        BinaryRawReader in = reader.rawReader();
        this.locId = in.readLong();
        this.gid = new UUID(in.readLong(), in.readLong());
    }

    public int hashCode() {
        return 31 * this.gid.hashCode() + (int)(this.locId ^ this.locId >>> 32);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String toString() {
        return this.shortString() + '-' + this.gid.toString();
    }
}

