/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.configuration.DataRegionConfiguration;
import org.apache.ignite.configuration.DataStorageConfiguration;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.node.VisorMemoryPolicyConfiguration;

public class VisorMemoryConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private long sysCacheInitSize;
    private long sysCacheMaxSize;
    private int pageSize;
    private int concLvl;
    private String dfltMemPlcName;
    private long dfltMemPlcSize;
    private List<VisorMemoryPolicyConfiguration> memPlcs;

    public VisorMemoryConfiguration() {
    }

    public VisorMemoryConfiguration(DataStorageConfiguration memCfg) {
        assert (memCfg != null);
        this.sysCacheInitSize = memCfg.getSystemRegionInitialSize();
        this.sysCacheMaxSize = memCfg.getSystemRegionMaxSize();
        this.pageSize = memCfg.getPageSize();
        this.concLvl = memCfg.getConcurrencyLevel();
        DataRegionConfiguration[] plcs = memCfg.getDataRegionConfigurations();
        if (!F.isEmpty(plcs)) {
            this.memPlcs = new ArrayList<VisorMemoryPolicyConfiguration>(plcs.length);
            for (DataRegionConfiguration plc : plcs) {
                this.memPlcs.add(new VisorMemoryPolicyConfiguration(plc));
            }
        }
    }

    public int getConcurrencyLevel() {
        return this.concLvl;
    }

    public long getSystemCacheInitialSize() {
        return this.sysCacheInitSize;
    }

    public long getSystemCacheMaxSize() {
        return this.sysCacheMaxSize;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public String getDefaultMemoryPolicyName() {
        return this.dfltMemPlcName;
    }

    public long getDefaultMemoryPolicySize() {
        return this.dfltMemPlcSize;
    }

    public List<VisorMemoryPolicyConfiguration> getMemoryPolicies() {
        return this.memPlcs;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeLong(this.sysCacheInitSize);
        out.writeLong(this.sysCacheMaxSize);
        out.writeInt(this.pageSize);
        out.writeInt(this.concLvl);
        U.writeString(out, this.dfltMemPlcName);
        out.writeLong(this.dfltMemPlcSize);
        U.writeCollection(out, this.memPlcs);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.sysCacheInitSize = in.readLong();
        this.sysCacheMaxSize = in.readLong();
        this.pageSize = in.readInt();
        this.concLvl = in.readInt();
        this.dfltMemPlcName = U.readString(in);
        this.dfltMemPlcSize = in.readLong();
        this.memPlcs = U.readList(in);
    }

    public String toString() {
        return S.toString(VisorMemoryConfiguration.class, this);
    }
}

