/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.cache;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.cache.VisorCacheConfiguration;
import org.apache.ignite.internal.visor.cache.VisorCacheConfigurationCollectorTaskArg;
import org.apache.ignite.lang.IgniteUuid;

public class VisorCacheConfigurationCollectorJob
extends VisorJob<VisorCacheConfigurationCollectorTaskArg, Map<String, VisorCacheConfiguration>> {
    private static final long serialVersionUID = 0L;

    public VisorCacheConfigurationCollectorJob(VisorCacheConfigurationCollectorTaskArg arg, boolean debug) {
        super(arg, debug);
    }

    @Override
    protected Map<String, VisorCacheConfiguration> run(VisorCacheConfigurationCollectorTaskArg arg) {
        Collection<IgniteCacheProxy<?, ?>> caches = this.ignite.context().cache().jcaches();
        Collection<String> cacheNames = arg.getCacheNames();
        boolean all = F.isEmpty(cacheNames);
        HashMap<String, VisorCacheConfiguration> res = U.newHashMap(all ? caches.size() : cacheNames.size());
        for (IgniteCacheProxy<?, ?> cache : caches) {
            String cacheName = cache.getName();
            if (!all && !cacheNames.contains(cacheName)) continue;
            res.put(cacheName, this.config(cache.getConfiguration(CacheConfiguration.class), cache.context().dynamicDeploymentId()));
        }
        return res;
    }

    protected VisorCacheConfiguration config(CacheConfiguration ccfg, IgniteUuid dynamicDeploymentId) {
        return new VisorCacheConfiguration(this.ignite, ccfg, dynamicDeploymentId);
    }

    public String toString() {
        return S.toString(VisorCacheConfigurationCollectorJob.class, this);
    }
}

