/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.S;

public class QueryEntityClassProperty {
    private final Member member;
    private QueryEntityClassProperty parent;
    private String name;
    private String alias;

    public QueryEntityClassProperty(Member member) {
        this.member = member;
        this.name = member.getName();
        if (member instanceof Method) {
            if (member.getName().startsWith("get") && member.getName().length() > 3) {
                this.name = member.getName().substring(3);
            }
            if (member.getName().startsWith("is") && member.getName().length() > 2) {
                this.name = member.getName().substring(2);
            }
        }
        ((AccessibleObject)((Object)member)).setAccessible(true);
    }

    public void alias(String alias) {
        this.alias = alias;
    }

    public String alias() {
        return F.isEmpty(this.alias) ? this.name : this.alias;
    }

    public Class<?> type() {
        return this.member instanceof Field ? ((Field)this.member).getType() : ((Method)this.member).getReturnType();
    }

    public void parent(QueryEntityClassProperty parent) {
        this.parent = parent;
    }

    public String toString() {
        return S.toString(QueryEntityClassProperty.class, this);
    }

    public boolean knowsClass(Class<?> cls) {
        return this.member.getDeclaringClass() == cls || this.parent != null && this.parent.knowsClass(cls);
    }

    public String fullName() {
        assert (this.name != null);
        if (this.parent == null) {
            return this.name;
        }
        return this.parent.fullName() + '.' + this.name;
    }
}

