/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.near;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.cache.GridCacheEntryRemovedException;
import org.apache.ignite.internal.processors.cache.GridCacheOperation;
import org.apache.ignite.internal.processors.cache.GridCacheSharedContext;
import org.apache.ignite.internal.processors.cache.distributed.GridDistributedTxRemoteAdapter;
import org.apache.ignite.internal.processors.cache.distributed.near.GridNearCacheEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxEntry;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxKey;
import org.apache.ignite.internal.processors.cache.transactions.IgniteTxRemoteStateImpl;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.GridLeanMap;
import org.apache.ignite.internal.util.tostring.GridToStringBuilder;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.transactions.TransactionConcurrency;
import org.apache.ignite.transactions.TransactionIsolation;
import org.jetbrains.annotations.Nullable;

public class GridNearTxRemote
extends GridDistributedTxRemoteAdapter {
    private static final long serialVersionUID = 0L;
    private Collection<IgniteTxKey> evicted = new LinkedList<IgniteTxKey>();
    private UUID nearNodeId;
    private GridCacheVersion nearXidVer;
    private Map<IgniteTxKey, GridCacheVersion> owned;

    public GridNearTxRemote() {
    }

    public GridNearTxRemote(GridCacheSharedContext ctx, AffinityTopologyVersion topVer, ClassLoader ldr, UUID nodeId, UUID nearNodeId, GridCacheVersion xidVer, GridCacheVersion commitVer, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, boolean invalidate, long timeout, Collection<IgniteTxEntry> writeEntries, int txSize, @Nullable UUID subjId, int taskNameHash) throws IgniteCheckedException {
        super(ctx, nodeId, xidVer, commitVer, sys, plc, concurrency, isolation, invalidate, timeout, txSize, subjId, taskNameHash);
        assert (nearNodeId != null);
        this.nearNodeId = nearNodeId;
        int writeSize = writeEntries != null ? Math.max(txSize, writeEntries.size()) : txSize;
        this.txState = new IgniteTxRemoteStateImpl(Collections.emptyMap(), U.newLinkedHashMap(writeSize));
        if (writeEntries != null) {
            for (IgniteTxEntry entry : writeEntries) {
                entry.unmarshal(ctx, true, ldr);
                this.addEntry(entry);
            }
        }
        assert (topVer != null && topVer.topologyVersion() > 0L) : topVer;
        this.topologyVersion(topVer);
    }

    public GridNearTxRemote(GridCacheSharedContext ctx, AffinityTopologyVersion topVer, UUID nodeId, UUID nearNodeId, GridCacheVersion nearXidVer, GridCacheVersion xidVer, GridCacheVersion commitVer, boolean sys, byte plc, TransactionConcurrency concurrency, TransactionIsolation isolation, boolean invalidate, long timeout, int txSize, @Nullable UUID subjId, int taskNameHash) {
        super(ctx, nodeId, xidVer, commitVer, sys, plc, concurrency, isolation, invalidate, timeout, txSize, subjId, taskNameHash);
        assert (nearNodeId != null);
        this.nearXidVer = nearXidVer;
        this.nearNodeId = nearNodeId;
        this.txState = new IgniteTxRemoteStateImpl(U.newLinkedHashMap(1), U.newLinkedHashMap(txSize));
        assert (topVer != null && topVer.topologyVersion() > 0L) : topVer;
        this.topologyVersion(topVer);
    }

    @Override
    public boolean remote() {
        return true;
    }

    @Override
    public boolean near() {
        return true;
    }

    @Override
    public UUID eventNodeId() {
        return this.nearNodeId;
    }

    @Override
    public GridCacheVersion ownedVersion(IgniteTxKey key) {
        return this.owned == null ? null : this.owned.get(key);
    }

    @Override
    public GridCacheVersion nearXidVersion() {
        return this.nearXidVer;
    }

    @Override
    public void setPartitionUpdateCounters(long[] cntrs) {
    }

    public void ownedVersions(Map<IgniteTxKey, GridCacheVersion> vers) {
        if (F.isEmpty(vers)) {
            return;
        }
        if (this.owned == null) {
            this.owned = new GridLeanMap<IgniteTxKey, GridCacheVersion>(vers.size());
        }
        this.owned.putAll(vers);
    }

    public UUID nearNodeId() {
        return this.nearNodeId;
    }

    @Override
    public Collection<UUID> masterNodeIds() {
        ArrayList<UUID> res = new ArrayList<UUID>(2);
        res.add(this.nodeId);
        res.add(this.nearNodeId);
        return res;
    }

    public Collection<IgniteTxKey> evicted() {
        return this.evicted;
    }

    void addEvicted(IgniteTxKey key) {
        this.evicted.add(key);
    }

    public void addEntries(ClassLoader ldr, Iterable<IgniteTxEntry> entries) throws IgniteCheckedException {
        for (IgniteTxEntry entry : entries) {
            entry.unmarshal(this.cctx, true, ldr);
            this.addEntry(entry);
        }
    }

    private boolean addEntry(IgniteTxEntry entry) throws IgniteCheckedException {
        GridNearCacheEntry cached;
        this.checkInternal(entry.txKey());
        GridCacheContext<Object, Object> cacheCtx = entry.context();
        if (!cacheCtx.isNear()) {
            cacheCtx = cacheCtx.dht().near().context();
        }
        if ((cached = cacheCtx.near().peekExx(entry.key())) == null) {
            this.evicted.add(entry.txKey());
            return false;
        }
        try {
            cached.unswap();
            CacheObject val = cached.peek(null);
            if (val == null && cached.evictInternal(this.xidVer, null, false)) {
                this.evicted.add(entry.txKey());
                return false;
            }
            entry.cached(cached);
            this.txState.addWriteEntry(entry.txKey(), entry);
            this.addExplicit(entry);
            return true;
        }
        catch (GridCacheEntryRemovedException ignore) {
            this.evicted.add(entry.txKey());
            if (log.isDebugEnabled()) {
                log.debug("Got removed entry when adding to remote transaction (will ignore): " + cached);
            }
            return false;
        }
    }

    public boolean addEntry(GridCacheContext cacheCtx, IgniteTxKey key, GridCacheOperation op, CacheObject val, @Nullable GridCacheVersion drVer, boolean skipStore, boolean keepBinary) throws IgniteCheckedException {
        this.checkInternal(key);
        GridNearCacheEntry cached = cacheCtx.near().peekExx(key.key());
        try {
            if (cached == null) {
                this.evicted.add(key);
                return false;
            }
            cached.unswap();
            CacheObject peek = cached.peek(null);
            if (peek == null && cached.evictInternal(this.xidVer, null, false)) {
                cached.context().cache().removeIfObsolete(key.key());
                this.evicted.add(key);
                return false;
            }
            IgniteTxEntry txEntry = new IgniteTxEntry(cacheCtx, this, op, val, -1L, -1L, cached, drVer, skipStore, keepBinary);
            this.txState.addWriteEntry(key, txEntry);
            return true;
        }
        catch (GridCacheEntryRemovedException ignore) {
            this.evicted.add(key);
            if (log.isDebugEnabled()) {
                log.debug("Got removed entry when adding reads to remote transaction (will ignore): " + cached);
            }
            return false;
        }
    }

    @Override
    public String toString() {
        return GridToStringBuilder.toString(GridNearTxRemote.class, this, "super", super.toString());
    }
}

