/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.distributed.dht.preloader;

import java.nio.ByteBuffer;
import org.apache.ignite.internal.managers.communication.GridIoMessage;
import org.apache.ignite.internal.processors.cache.GridCacheMessage;
import org.apache.ignite.internal.processors.cache.distributed.dht.preloader.GridDhtPartitionExchangeId;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

public abstract class GridDhtPartitionsAbstractMessage
extends GridCacheMessage {
    private static final byte COMPRESSED_FLAG_MASK = 1;
    private static final byte RESTORE_STATE_FLAG_MASK = 2;
    private static final long serialVersionUID = 0L;
    private GridDhtPartitionExchangeId exchId;
    private GridCacheVersion lastVer;
    protected byte flags;

    protected GridDhtPartitionsAbstractMessage() {
    }

    GridDhtPartitionsAbstractMessage(GridDhtPartitionExchangeId exchId, @Nullable GridCacheVersion lastVer) {
        this.exchId = exchId;
        this.lastVer = lastVer;
    }

    void copyStateTo(GridDhtPartitionsAbstractMessage msg) {
        msg.exchId = this.exchId;
        msg.lastVer = this.lastVer;
        msg.flags = this.flags;
    }

    @Override
    public boolean cacheGroupMessage() {
        return false;
    }

    @Override
    public int partition() {
        return GridIoMessage.STRIPE_DISABLED_PART;
    }

    @Override
    public boolean addDeploymentInfo() {
        return false;
    }

    @Override
    public boolean partitionExchangeMessage() {
        return true;
    }

    @Nullable
    public GridDhtPartitionExchangeId exchangeId() {
        return this.exchId;
    }

    public void exchangeId(GridDhtPartitionExchangeId exchId) {
        this.exchId = exchId;
    }

    @Nullable
    public GridCacheVersion lastVersion() {
        return this.lastVer;
    }

    protected final boolean compressed() {
        return (this.flags & 1) != 0;
    }

    protected final void compressed(boolean compressed) {
        this.flags = compressed ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    void restoreState(boolean restoreState) {
        this.flags = restoreState ? (byte)(this.flags | 2) : (byte)(this.flags & 0xFFFFFFFD);
    }

    public boolean restoreState() {
        return (this.flags & 2) != 0;
    }

    @Override
    public byte fieldsCount() {
        return 5;
    }

    @Override
    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!super.writeTo(buf, writer)) {
            return false;
        }
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 2: {
                if (!writer.writeMessage("exchId", this.exchId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMessage("lastVer", this.lastVer)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    @Override
    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        if (!super.readFrom(buf, reader)) {
            return false;
        }
        switch (reader.state()) {
            case 2: {
                this.exchId = (GridDhtPartitionExchangeId)reader.readMessage("exchId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.lastVer = (GridCacheVersion)reader.readMessage("lastVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridDhtPartitionsAbstractMessage.class);
    }

    @Override
    public String toString() {
        return S.toString(GridDhtPartitionsAbstractMessage.class, this, super.toString());
    }
}

