/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.binary;

import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.binary.BinaryObjectException;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.GridTopic;
import org.apache.ignite.internal.IgniteInternalFuture;
import org.apache.ignite.internal.binary.BinaryMetadata;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.cluster.ClusterTopologyCheckedException;
import org.apache.ignite.internal.managers.communication.GridIoManager;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.discovery.CustomEventListener;
import org.apache.ignite.internal.managers.discovery.GridDiscoveryManager;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataFileStore;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataHolder;
import org.apache.ignite.internal.processors.cache.binary.BinaryMetadataUpdatedListener;
import org.apache.ignite.internal.processors.cache.binary.ClientMetadataRequestFuture;
import org.apache.ignite.internal.processors.cache.binary.MetadataRequestMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataResponseMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateAcceptedMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateProposedMessage;
import org.apache.ignite.internal.processors.cache.binary.MetadataUpdateResult;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteInClosure;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.jetbrains.annotations.Nullable;

final class BinaryMetadataTransport {
    private final GridDiscoveryManager discoMgr;
    private final GridKernalContext ctx;
    private final IgniteLogger log;
    private final boolean clientNode;
    private final ConcurrentMap<Integer, BinaryMetadataHolder> metaLocCache;
    private final BinaryMetadataFileStore metadataFileStore;
    private final Queue<MetadataUpdateResultFuture> unlabeledFutures = new ConcurrentLinkedQueue<MetadataUpdateResultFuture>();
    private final ConcurrentMap<SyncKey, MetadataUpdateResultFuture> syncMap = new ConcurrentHashMap<SyncKey, MetadataUpdateResultFuture>();
    private final ConcurrentMap<Integer, ClientMetadataRequestFuture> clientReqSyncMap = new ConcurrentHashMap<Integer, ClientMetadataRequestFuture>();
    private volatile boolean stopping;
    private final List<BinaryMetadataUpdatedListener> binaryUpdatedLsnrs = new CopyOnWriteArrayList<BinaryMetadataUpdatedListener>();

    BinaryMetadataTransport(ConcurrentMap<Integer, BinaryMetadataHolder> metaLocCache, BinaryMetadataFileStore metadataFileStore, final GridKernalContext ctx, IgniteLogger log) {
        this.metaLocCache = metaLocCache;
        this.metadataFileStore = metadataFileStore;
        this.ctx = ctx;
        this.log = log;
        this.discoMgr = ctx.discovery();
        this.clientNode = ctx.clientNode();
        this.discoMgr.setCustomEventListener(MetadataUpdateProposedMessage.class, new MetadataUpdateProposedListener());
        this.discoMgr.setCustomEventListener(MetadataUpdateAcceptedMessage.class, new MetadataUpdateAcceptedListener());
        GridIoManager ioMgr = ctx.io();
        if (this.clientNode) {
            ioMgr.addMessageListener(GridTopic.TOPIC_METADATA_REQ, (GridMessageListener)new MetadataResponseListener());
        } else {
            ioMgr.addMessageListener(GridTopic.TOPIC_METADATA_REQ, (GridMessageListener)new MetadataRequestListener(ioMgr));
        }
        if (this.clientNode) {
            ctx.event().addLocalEventListener(new GridLocalEventListener(){

                @Override
                public void onEvent(Event evt) {
                    DiscoveryEvent evt0 = (DiscoveryEvent)evt;
                    if (!ctx.isStopping()) {
                        for (ClientMetadataRequestFuture fut : BinaryMetadataTransport.this.clientReqSyncMap.values()) {
                            fut.onNodeLeft(evt0.eventNode().id());
                        }
                    }
                }
            }, 11, 12);
        }
    }

    void addBinaryMetadataUpdateListener(BinaryMetadataUpdatedListener lsnr) {
        this.binaryUpdatedLsnrs.add(lsnr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GridFutureAdapter<MetadataUpdateResult> requestMetadataUpdate(BinaryMetadata metadata) {
        MetadataUpdateResultFuture resFut = new MetadataUpdateResultFuture();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Requesting metadata update for " + metadata.typeId() + "; caller thread is blocked on future " + resFut);
        }
        try {
            BinaryMetadataTransport binaryMetadataTransport = this;
            synchronized (binaryMetadataTransport) {
                this.unlabeledFutures.add(resFut);
                if (!this.stopping) {
                    this.discoMgr.sendCustomEvent(new MetadataUpdateProposedMessage(metadata, this.ctx.localNodeId()));
                } else {
                    resFut.onDone(MetadataUpdateResult.createUpdateDisabledResult());
                }
            }
        }
        catch (Exception e) {
            resFut.onDone(MetadataUpdateResult.createUpdateDisabledResult(), (Throwable)e);
        }
        if (this.ctx.clientDisconnected()) {
            this.onDisconnected();
        }
        return resFut;
    }

    GridFutureAdapter<MetadataUpdateResult> awaitMetadataUpdate(int typeId, int ver) {
        BinaryMetadataHolder holder;
        SyncKey key = new SyncKey(typeId, ver);
        MetadataUpdateResultFuture resFut = new MetadataUpdateResultFuture(key);
        MetadataUpdateResultFuture oldFut = this.syncMap.putIfAbsent(key, resFut);
        if (oldFut != null) {
            resFut = oldFut;
        }
        if ((holder = (BinaryMetadataHolder)this.metaLocCache.get(typeId)).acceptedVersion() >= ver) {
            resFut.onDone(MetadataUpdateResult.createSuccessfulResult());
        }
        return resFut;
    }

    GridFutureAdapter<MetadataUpdateResult> requestUpToDateMetadata(int typeId) {
        ClientMetadataRequestFuture newFut = new ClientMetadataRequestFuture(this.ctx, typeId, this.clientReqSyncMap);
        ClientMetadataRequestFuture oldFut = this.clientReqSyncMap.putIfAbsent(typeId, newFut);
        if (oldFut != null) {
            return oldFut;
        }
        newFut.requestMetadata();
        return newFut;
    }

    void stop() {
        this.stopping = true;
        this.cancelFutures(MetadataUpdateResult.createUpdateDisabledResult());
    }

    void onDisconnected() {
        this.cancelFutures(MetadataUpdateResult.createFailureResult(new BinaryObjectException("Failed to update or wait for metadata, client node disconnected")));
    }

    private void cancelFutures(MetadataUpdateResult res) {
        for (MetadataUpdateResultFuture metadataUpdateResultFuture : this.unlabeledFutures) {
            metadataUpdateResultFuture.onDone(res);
        }
        this.unlabeledFutures.clear();
        for (MetadataUpdateResultFuture metadataUpdateResultFuture : this.syncMap.values()) {
            metadataUpdateResultFuture.onDone(res);
        }
        for (ClientMetadataRequestFuture clientMetadataRequestFuture : this.clientReqSyncMap.values()) {
            clientMetadataRequestFuture.onDone(res);
        }
    }

    private void initSyncFor(int typeId, int pendingVer, final MetadataUpdateResultFuture fut) {
        if (this.stopping) {
            fut.onDone(MetadataUpdateResult.createUpdateDisabledResult());
            return;
        }
        SyncKey key = new SyncKey(typeId, pendingVer);
        MetadataUpdateResultFuture oldFut = this.syncMap.putIfAbsent(key, fut);
        if (oldFut != null) {
            oldFut.listen(new IgniteInClosure<IgniteInternalFuture<MetadataUpdateResult>>(){

                @Override
                public void apply(IgniteInternalFuture<MetadataUpdateResult> doneFut) {
                    fut.onDone(doneFut.result(), doneFut.error());
                }
            });
        }
        fut.key(key);
    }

    private static boolean obsoleteUpdate(int locP, int locA, int remP, int remA) {
        return remP < locP || remP == locP && remA < locA;
    }

    private final class MetadataResponseListener
    implements GridMessageListener {
        private MetadataResponseListener() {
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            assert (msg instanceof MetadataResponseMessage) : msg;
            MetadataResponseMessage msg0 = (MetadataResponseMessage)msg;
            int typeId = msg0.typeId();
            byte[] binMetaBytes = msg0.binaryMetadataBytes();
            ClientMetadataRequestFuture fut = (ClientMetadataRequestFuture)BinaryMetadataTransport.this.clientReqSyncMap.get(typeId);
            if (fut == null) {
                return;
            }
            if (msg0.metadataNotFound()) {
                fut.onDone(MetadataUpdateResult.createSuccessfulResult());
                return;
            }
            try {
                BinaryMetadataHolder newHolder = (BinaryMetadataHolder)U.unmarshal(BinaryMetadataTransport.this.ctx, binMetaBytes, U.resolveClassLoader(BinaryMetadataTransport.this.ctx.config()));
                BinaryMetadataHolder oldHolder = BinaryMetadataTransport.this.metaLocCache.putIfAbsent(typeId, newHolder);
                if (oldHolder != null) {
                    while (!((oldHolder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId)) != null && BinaryMetadataTransport.obsoleteUpdate(oldHolder.pendingVersion(), oldHolder.acceptedVersion(), newHolder.pendingVersion(), newHolder.acceptedVersion()) || BinaryMetadataTransport.this.metaLocCache.replace(typeId, oldHolder, newHolder))) {
                    }
                }
                fut.onDone(MetadataUpdateResult.createSuccessfulResult());
            }
            catch (IgniteCheckedException e) {
                fut.onDone(MetadataUpdateResult.createFailureResult(new BinaryObjectException(e)));
            }
        }
    }

    private final class MetadataRequestListener
    implements GridMessageListener {
        private final GridIoManager ioMgr;

        MetadataRequestListener(GridIoManager ioMgr) {
            this.ioMgr = ioMgr;
        }

        @Override
        public void onMessage(UUID nodeId, Object msg, byte plc) {
            assert (msg instanceof MetadataRequestMessage) : msg;
            MetadataRequestMessage msg0 = (MetadataRequestMessage)msg;
            int typeId = msg0.typeId();
            BinaryMetadataHolder metaHolder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId);
            MetadataResponseMessage resp = new MetadataResponseMessage(typeId);
            byte[] binMetaBytes = null;
            if (metaHolder != null) {
                try {
                    binMetaBytes = U.marshal(BinaryMetadataTransport.this.ctx, (Object)metaHolder);
                }
                catch (IgniteCheckedException e) {
                    U.error(BinaryMetadataTransport.this.log, "Failed to marshal binary metadata for [typeId: " + typeId + "]", e);
                    resp.markErrorOnRequest();
                }
            }
            resp.binaryMetadataBytes(binMetaBytes);
            try {
                this.ioMgr.sendToGridTopic(nodeId, GridTopic.TOPIC_METADATA_REQ, (Message)resp, (byte)2);
            }
            catch (ClusterTopologyCheckedException e) {
                if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                    BinaryMetadataTransport.this.log.debug("Failed to send metadata response, node failed: " + nodeId);
                }
            }
            catch (IgniteCheckedException e) {
                U.error(BinaryMetadataTransport.this.log, "Failed to send up-to-date metadata response.", e);
            }
        }
    }

    private static final class SyncKey {
        private final int typeId;
        private final int ver;

        private SyncKey(int typeId, int ver) {
            this.typeId = typeId;
            this.ver = ver;
        }

        int typeId() {
            return this.typeId;
        }

        int version() {
            return this.ver;
        }

        public int hashCode() {
            return this.typeId + this.ver;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SyncKey)) {
                return false;
            }
            SyncKey that = (SyncKey)o;
            return this.typeId == that.typeId && this.ver == that.ver;
        }
    }

    private final class MetadataUpdateResultFuture
    extends GridFutureAdapter<MetadataUpdateResult> {
        private SyncKey key;

        MetadataUpdateResultFuture() {
        }

        MetadataUpdateResultFuture(SyncKey key) {
            this.key = key;
        }

        @Override
        public boolean onDone(@Nullable MetadataUpdateResult res, @Nullable Throwable err) {
            assert (res != null);
            boolean done = super.onDone(res, err);
            if (done && this.key != null) {
                BinaryMetadataTransport.this.syncMap.remove(this.key, this);
            }
            return done;
        }

        void key(SyncKey key) {
            this.key = key;
        }
    }

    private final class MetadataUpdateAcceptedListener
    implements CustomEventListener<MetadataUpdateAcceptedMessage> {
        private MetadataUpdateAcceptedListener() {
        }

        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, MetadataUpdateAcceptedMessage msg) {
            if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                BinaryMetadataTransport.this.log.debug("Received MetadataUpdateAcceptedMessage " + msg);
            }
            if (msg.duplicated()) {
                return;
            }
            int typeId = msg.typeId();
            BinaryMetadataHolder holder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId);
            assert (holder != null) : "No metadata found for typeId " + typeId;
            int newAcceptedVer = msg.acceptedVersion();
            if (BinaryMetadataTransport.this.clientNode) {
                int oldAcceptedVer;
                BinaryMetadataHolder newHolder = new BinaryMetadataHolder(holder.metadata(), holder.pendingVersion(), newAcceptedVer);
                while ((oldAcceptedVer = (holder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId)).acceptedVersion()) <= newAcceptedVer && !BinaryMetadataTransport.this.metaLocCache.replace(typeId, holder, newHolder)) {
                }
            } else {
                int oldAcceptedVer = holder.acceptedVersion();
                if (oldAcceptedVer >= newAcceptedVer) {
                    if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                        BinaryMetadataTransport.this.log.debug("Marking ack as duplicate [holder=" + holder + ", newAcceptedVer: " + newAcceptedVer + ']');
                    }
                    msg.duplicated(true);
                    return;
                }
                BinaryMetadataTransport.this.metadataFileStore.writeMetadata(holder.metadata());
                BinaryMetadataTransport.this.metaLocCache.put(typeId, new BinaryMetadataHolder(holder.metadata(), holder.pendingVersion(), newAcceptedVer));
            }
            for (BinaryMetadataUpdatedListener lsnr : BinaryMetadataTransport.this.binaryUpdatedLsnrs) {
                lsnr.binaryMetadataUpdated(holder.metadata());
            }
            GridFutureAdapter fut = (GridFutureAdapter)BinaryMetadataTransport.this.syncMap.get(new SyncKey(typeId, newAcceptedVer));
            if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                BinaryMetadataTransport.this.log.debug("Completing future " + fut + " for " + BinaryMetadataTransport.this.metaLocCache.get(typeId));
            }
            if (fut != null) {
                fut.onDone(MetadataUpdateResult.createSuccessfulResult());
            }
        }
    }

    private final class MetadataUpdateProposedListener
    implements CustomEventListener<MetadataUpdateProposedMessage> {
        private MetadataUpdateProposedListener() {
        }

        @Override
        public void onCustomEvent(AffinityTopologyVersion topVer, ClusterNode snd, MetadataUpdateProposedMessage msg) {
            block26: {
                BinaryMetadata mergedMeta;
                BinaryMetadata locMeta;
                int acceptedVer;
                int pendingVer;
                int typeId = msg.typeId();
                BinaryMetadataHolder holder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId);
                if (msg.pendingVersion() == 0) {
                    if (holder != null) {
                        pendingVer = holder.pendingVersion() + 1;
                        acceptedVer = holder.acceptedVersion();
                    } else {
                        pendingVer = 1;
                        acceptedVer = 0;
                    }
                    if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                        BinaryMetadataTransport.this.log.debug("Versions are stamped on coordinator [typeId=" + typeId + ", pendingVer=" + pendingVer + ", acceptedVer=" + acceptedVer + "]");
                    }
                    msg.pendingVersion(pendingVer);
                    msg.acceptedVersion(acceptedVer);
                    locMeta = holder != null ? holder.metadata() : null;
                    try {
                        mergedMeta = BinaryUtils.mergeMetadata(locMeta, msg.metadata());
                        msg.metadata(mergedMeta);
                    }
                    catch (BinaryObjectException err) {
                        BinaryMetadataTransport.this.log.warning("Exception with merging metadata for typeId: " + typeId, err);
                        msg.markRejected(err);
                    }
                } else {
                    pendingVer = msg.pendingVersion();
                    acceptedVer = msg.acceptedVersion();
                }
                if (BinaryMetadataTransport.this.ctx.localNodeId().equals(msg.origNodeId())) {
                    BinaryMetadataHolder newHolder;
                    MetadataUpdateResultFuture fut = (MetadataUpdateResultFuture)BinaryMetadataTransport.this.unlabeledFutures.poll();
                    if (msg.rejected()) {
                        fut.onDone(MetadataUpdateResult.createFailureResult(msg.rejectionError()));
                    } else if (BinaryMetadataTransport.this.clientNode) {
                        newHolder = new BinaryMetadataHolder(msg.metadata(), pendingVer, acceptedVer);
                        holder = BinaryMetadataTransport.this.metaLocCache.putIfAbsent(typeId, newHolder);
                        if (holder != null) {
                            boolean obsoleteUpd = false;
                            do {
                                if (!BinaryMetadataTransport.obsoleteUpdate((holder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId)).pendingVersion(), holder.acceptedVersion(), pendingVer, acceptedVer)) continue;
                                obsoleteUpd = true;
                                fut.onDone(MetadataUpdateResult.createSuccessfulResult());
                                break;
                            } while (!BinaryMetadataTransport.this.metaLocCache.replace(typeId, holder, newHolder));
                            if (!obsoleteUpd) {
                                BinaryMetadataTransport.this.initSyncFor(typeId, pendingVer, fut);
                            }
                        } else {
                            BinaryMetadataTransport.this.initSyncFor(typeId, pendingVer, fut);
                        }
                    } else {
                        BinaryMetadataTransport.this.initSyncFor(typeId, pendingVer, fut);
                        newHolder = new BinaryMetadataHolder(msg.metadata(), pendingVer, acceptedVer);
                        if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                            BinaryMetadataTransport.this.log.debug("Updated metadata on originating node: " + newHolder);
                        }
                        BinaryMetadataTransport.this.metaLocCache.put(typeId, newHolder);
                    }
                } else if (!msg.rejected()) {
                    locMeta = holder != null ? holder.metadata() : null;
                    try {
                        mergedMeta = BinaryUtils.mergeMetadata(locMeta, msg.metadata());
                        BinaryMetadataHolder newHolder = new BinaryMetadataHolder(mergedMeta, pendingVer, acceptedVer);
                        if (BinaryMetadataTransport.this.clientNode) {
                            holder = BinaryMetadataTransport.this.metaLocCache.putIfAbsent(typeId, newHolder);
                            if (holder != null) {
                                while (!BinaryMetadataTransport.obsoleteUpdate((holder = (BinaryMetadataHolder)BinaryMetadataTransport.this.metaLocCache.get(typeId)).pendingVersion(), holder.acceptedVersion(), pendingVer, acceptedVer) && !BinaryMetadataTransport.this.metaLocCache.replace(typeId, holder, newHolder)) {
                                }
                            }
                        } else {
                            if (BinaryMetadataTransport.this.log.isDebugEnabled()) {
                                BinaryMetadataTransport.this.log.debug("Updated metadata on server node: " + newHolder);
                            }
                            BinaryMetadataTransport.this.metaLocCache.put(typeId, newHolder);
                        }
                    }
                    catch (BinaryObjectException ignored) {
                        if ($assertionsDisabled) break block26;
                        throw new AssertionError(msg);
                    }
                }
            }
        }
    }
}

