/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc.thin;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.FileSystems;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.cache.configuration.Factory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.ignite.internal.jdbc.thin.ConnectionProperties;
import org.apache.ignite.internal.util.typedef.F;

public class JdbcThinSSLUtil {
    private static final X509TrustManager TRUST_ALL_MANAGER = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
        }
    };

    private JdbcThinSSLUtil() {
    }

    public static SSLSocket createSSLSocket(InetSocketAddress addr, ConnectionProperties connProps) throws SQLException, IOException {
        try {
            SSLSocketFactory sslSocketFactory = JdbcThinSSLUtil.getSSLSocketFactory(connProps);
            SSLSocket sock = (SSLSocket)sslSocketFactory.createSocket(addr.getAddress(), addr.getPort());
            sock.setUseClientMode(true);
            sock.startHandshake();
            return sock;
        }
        catch (IOException e) {
            throw new SQLException("Failed to SSL connect to server [url=" + connProps.getUrl() + ']', "08001", e);
        }
    }

    private static SSLSocketFactory getSSLSocketFactory(ConnectionProperties connProps) throws SQLException {
        List<X509TrustManager> tms;
        KeyManagerFactory kmf;
        TrustManagerFactory tmf;
        String sslFactory = connProps.getSslFactory();
        String cliCertKeyStoreUrl = connProps.getSslClientCertificateKeyStoreUrl();
        String cliCertKeyStorePwd = connProps.getSslClientCertificateKeyStorePassword();
        String cliCertKeyStoreType = connProps.getSslClientCertificateKeyStoreType();
        String trustCertKeyStoreUrl = connProps.getSslTrustCertificateKeyStoreUrl();
        String trustCertKeyStorePwd = connProps.getSslTrustCertificateKeyStorePassword();
        String trustCertKeyStoreType = connProps.getSslTrustCertificateKeyStoreType();
        String sslProtocol = connProps.getSslProtocol();
        String keyAlgorithm = connProps.getSslKeyAlgorithm();
        if (!F.isEmpty(sslFactory)) {
            try {
                Class<?> cls = JdbcThinSSLUtil.class.getClassLoader().loadClass(sslFactory);
                Factory f = (Factory)cls.newInstance();
                return (SSLSocketFactory)f.create();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new SQLException("Could not fount SSL factory class: " + sslFactory, "08001", e);
            }
        }
        if (cliCertKeyStoreUrl == null && cliCertKeyStorePwd == null && cliCertKeyStoreType == null && trustCertKeyStoreUrl == null && trustCertKeyStorePwd == null && trustCertKeyStoreType == null && sslProtocol == null) {
            try {
                return SSLContext.getDefault().getSocketFactory();
            }
            catch (NoSuchAlgorithmException e) {
                throw new SQLException("Could not create default SSL context", "08001", e);
            }
        }
        if (cliCertKeyStoreUrl == null) {
            cliCertKeyStoreUrl = System.getProperty("javax.net.ssl.keyStore");
        }
        if (cliCertKeyStorePwd == null) {
            cliCertKeyStorePwd = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (cliCertKeyStoreType == null) {
            cliCertKeyStoreType = System.getProperty("javax.net.ssl.keyStoreType", "JKS");
        }
        if (trustCertKeyStoreUrl == null) {
            trustCertKeyStoreUrl = System.getProperty("javax.net.ssl.trustStore");
        }
        if (trustCertKeyStorePwd == null) {
            trustCertKeyStorePwd = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (trustCertKeyStoreType == null) {
            trustCertKeyStoreType = System.getProperty("javax.net.ssl.trustStoreType", "JKS");
        }
        if (sslProtocol == null) {
            sslProtocol = "TLS";
        }
        if (!F.isEmpty(cliCertKeyStoreUrl)) {
            cliCertKeyStoreUrl = JdbcThinSSLUtil.checkAndConvertUrl(cliCertKeyStoreUrl);
        }
        if (!F.isEmpty(trustCertKeyStoreUrl)) {
            trustCertKeyStoreUrl = JdbcThinSSLUtil.checkAndConvertUrl(trustCertKeyStoreUrl);
        }
        KeyManager[] kms = null;
        try {
            tmf = TrustManagerFactory.getInstance(keyAlgorithm);
            kmf = KeyManagerFactory.getInstance(keyAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException("Default algorithm definitions for TrustManager and/or KeyManager are invalid. Check java security properties file.", "08001", e);
        }
        InputStream ksInputStream = null;
        try {
            if (!F.isEmpty(cliCertKeyStoreUrl) && !F.isEmpty(cliCertKeyStoreType)) {
                KeyStore clientKeyStore = KeyStore.getInstance(cliCertKeyStoreType);
                URL ksURL = new URL(cliCertKeyStoreUrl);
                char[] password = cliCertKeyStorePwd == null ? new char[]{} : cliCertKeyStorePwd.toCharArray();
                ksInputStream = ksURL.openStream();
                clientKeyStore.load(ksInputStream, password);
                kmf.init(clientKeyStore, password);
                kms = kmf.getKeyManagers();
            }
        }
        catch (UnrecoverableKeyException e) {
            throw new SQLException("Could not recover keys from client keystore.", "08001", e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException("Unsupported keystore algorithm.", "08001", e);
        }
        catch (KeyStoreException e) {
            throw new SQLException("Could not create client KeyStore instance.", "08001", e);
        }
        catch (CertificateException e) {
            throw new SQLException("Could not load client key store. [storeType=" + cliCertKeyStoreType + ", cliStoreUrl=" + cliCertKeyStoreUrl + ']', "08001", e);
        }
        catch (MalformedURLException e) {
            throw new SQLException("Invalid client key store URL. [url=" + cliCertKeyStoreUrl + ']', "08001", e);
        }
        catch (IOException e) {
            throw new SQLException("Could not open client key store.[url=" + cliCertKeyStoreUrl + ']', "08001", e);
        }
        finally {
            if (ksInputStream != null) {
                try {
                    ksInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        InputStream tsInputStream = null;
        if (connProps.isSslTrustAll()) {
            tms = Collections.singletonList(TRUST_ALL_MANAGER);
        } else {
            tms = new ArrayList<X509TrustManager>();
            try {
                KeyStore trustKeyStore = null;
                if (!F.isEmpty(trustCertKeyStoreUrl) && !F.isEmpty(trustCertKeyStoreType)) {
                    char[] trustStorePassword = trustCertKeyStorePwd == null ? new char[]{} : trustCertKeyStorePwd.toCharArray();
                    tsInputStream = new URL(trustCertKeyStoreUrl).openStream();
                    trustKeyStore = KeyStore.getInstance(trustCertKeyStoreType);
                    trustKeyStore.load(tsInputStream, trustStorePassword);
                }
                tmf.init(trustKeyStore);
                TrustManager[] origTms = tmf.getTrustManagers();
                Collections.addAll(tms, origTms);
            }
            catch (NoSuchAlgorithmException e) {
                throw new SQLException("Unsupported keystore algorithm.", "08001", e);
            }
            catch (KeyStoreException e) {
                throw new SQLException("Could not create trust KeyStore instance.", "08001", e);
            }
            catch (CertificateException e) {
                throw new SQLException("Could not load trusted key store. [storeType=" + trustCertKeyStoreType + ", cliStoreUrl=" + trustCertKeyStoreUrl + ']', "08001", e);
            }
            catch (MalformedURLException e) {
                throw new SQLException("Invalid trusted key store URL. [url=" + trustCertKeyStoreUrl + ']', "08001", e);
            }
            catch (IOException e) {
                throw new SQLException("Could not open trusted key store. [url=" + cliCertKeyStoreUrl + ']', "08001", e);
            }
            finally {
                if (tsInputStream != null) {
                    try {
                        tsInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        assert (tms.size() != 0);
        try {
            SSLContext sslContext = SSLContext.getInstance(sslProtocol);
            sslContext.init(kms, tms.toArray(new TrustManager[tms.size()]), null);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new SQLException(sslProtocol + " is not a valid SSL protocol.", "08001", e);
        }
        catch (KeyManagementException e) {
            throw new SQLException("Cannot init SSL context.", "08001", e);
        }
    }

    private static String checkAndConvertUrl(String url) throws SQLException {
        try {
            return new URL(url).toString();
        }
        catch (MalformedURLException e) {
            try {
                return FileSystems.getDefault().getPath(url, new String[0]).toUri().toURL().toString();
            }
            catch (MalformedURLException e1) {
                throw new SQLException("Invalid keystore UR: " + url, "08001", e);
            }
        }
    }
}

