/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.binary;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.internal.binary.BinaryUtils;
import org.apache.ignite.internal.util.typedef.internal.S;

public class BinarySchema
implements Externalizable {
    private static final long serialVersionUID = 0L;
    public static final int ORDER_NOT_FOUND = -1;
    private static final int MAP_MIN_SIZE = 32;
    private static final int MAP_EMPTY = 0;
    private int schemaId;
    private int[] ids;
    private String[] names;
    private int[] idToOrderData;
    private int idToOrderMask;
    private int id0;
    private int id1;
    private int id2;
    private int id3;

    public BinarySchema() {
    }

    public BinarySchema(int schemaId, List<Integer> fieldIds) {
        assert (fieldIds != null);
        this.schemaId = schemaId;
        this.initialize(fieldIds);
    }

    public int schemaId() {
        return this.schemaId;
    }

    public Confirmation confirmOrder(int expOrder, String expName) {
        assert (expName != null);
        if (expOrder < this.names.length) {
            String name = this.names[expOrder];
            if (name == expName) {
                return Confirmation.CONFIRMED;
            }
            if (name == null) {
                return Confirmation.CLARIFY;
            }
        }
        return Confirmation.REJECTED;
    }

    public void clarifyFieldName(int order, String name) {
        assert (name != null);
        assert (order < this.names.length);
        this.names[order] = name.intern();
    }

    public int fieldId(int order) {
        return order < this.ids.length ? this.ids[order] : 0;
    }

    public int order(int id) {
        if (this.idToOrderData == null) {
            if (id == this.id0) {
                return 0;
            }
            if (id == this.id1) {
                return 1;
            }
            if (id == this.id2) {
                return 2;
            }
            if (id == this.id3) {
                return 3;
            }
            return -1;
        }
        int idx = (id & this.idToOrderMask) << 1;
        int curId = this.idToOrderData[idx];
        if (id == curId) {
            return this.idToOrderData[idx + 1];
        }
        if (curId == 0) {
            return -1;
        }
        for (int i = 2; i < this.idToOrderData.length; i += 2) {
            int newIdx = (idx + i) % this.idToOrderData.length;
            assert (newIdx < this.idToOrderData.length - 1);
            curId = this.idToOrderData[newIdx];
            if (id == curId) {
                return this.idToOrderData[newIdx + 1];
            }
            if (curId != 0) continue;
            return -1;
        }
        return -1;
    }

    public int hashCode() {
        return this.schemaId;
    }

    public boolean equals(Object o) {
        return o != null && o instanceof BinarySchema && this.schemaId == ((BinarySchema)o).schemaId;
    }

    public String toString() {
        return S.toString(BinarySchema.class, this, "ids", (Object)Arrays.toString(this.ids), "names", (Object)Arrays.toString(this.names), "idToOrderData", Arrays.toString(this.idToOrderData));
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeTo(out);
    }

    public void writeTo(DataOutput out) throws IOException {
        out.writeInt(this.schemaId);
        out.writeInt(this.ids.length);
        int[] nArray = this.ids;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer id = nArray[i];
            out.writeInt(id);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.readFrom(in);
    }

    public void readFrom(DataInput in) throws IOException {
        this.schemaId = in.readInt();
        int idsCnt = in.readInt();
        ArrayList<Integer> fieldIds = new ArrayList<Integer>(idsCnt);
        for (int i = 0; i < idsCnt; ++i) {
            fieldIds.add(in.readInt());
        }
        this.initialize(fieldIds);
    }

    public int[] fieldIds() {
        return this.ids;
    }

    private static ParseResult parse(int[] vals, int size) {
        int mask = BinarySchema.maskForPowerOfTwo(size);
        int totalSize = size * 2;
        int[] data = new int[totalSize];
        int collisions = 0;
        for (int order = 0; order < vals.length; ++order) {
            int id = vals[order];
            assert (id != 0);
            int idIdx = (id & mask) << 1;
            if (data[idIdx] == 0) {
                data[idIdx] = id;
                data[idIdx + 1] = order;
                continue;
            }
            ++collisions;
            boolean placeFound = false;
            for (int i = 2; i < totalSize; i += 2) {
                int newIdIdx = (idIdx + i) % totalSize;
                if (data[newIdIdx] != 0) continue;
                data[newIdIdx] = id;
                data[newIdIdx + 1] = order;
                placeFound = true;
                break;
            }
            assert (placeFound) : "Should always have a place for entry!";
        }
        return new ParseResult(data, collisions);
    }

    private static int nextPowerOfTwo(int val) {
        int res;
        for (res = 1; res < val; res <<= 1) {
        }
        if (res < 0) {
            throw new IllegalArgumentException("Value is too big to find positive pow2: " + val);
        }
        return res;
    }

    private static int maskForPowerOfTwo(int val) {
        int mask = 0;
        for (int comparand = 1; comparand < val; comparand <<= 1) {
            mask |= comparand;
        }
        return mask;
    }

    private void initialize(List<Integer> fieldIds) {
        this.ids = new int[fieldIds.size()];
        for (int i = 0; i < fieldIds.size(); ++i) {
            this.ids[i] = fieldIds.get(i);
        }
        this.names = new String[fieldIds.size()];
        if (fieldIds.size() <= 4) {
            Iterator<Integer> iter = fieldIds.iterator();
            this.id0 = iter.hasNext() ? iter.next() : 0;
            this.id1 = iter.hasNext() ? iter.next() : 0;
            this.id2 = iter.hasNext() ? iter.next() : 0;
            this.id3 = iter.hasNext() ? iter.next() : 0;
        } else {
            this.id3 = 0;
            this.id2 = 0;
            this.id1 = 0;
            this.id0 = 0;
            this.initializeMap(this.ids);
        }
    }

    private void initializeMap(int[] vals) {
        ParseResult res2;
        int size = Math.max(BinarySchema.nextPowerOfTwo(vals.length) << 2, 32);
        assert (size > 0);
        ParseResult res1 = BinarySchema.parse(vals, size);
        ParseResult finalRes = res1.collisions == 0 ? res1 : ((res2 = BinarySchema.parse(vals, size * 2)).collisions == 0 ? res2 : BinarySchema.parse(vals, size * 4));
        this.idToOrderData = finalRes.data;
        this.idToOrderMask = BinarySchema.maskForPowerOfTwo(this.idToOrderData.length / 2);
    }

    private static class ParseResult {
        private int[] data;
        private int collisions;

        private ParseResult(int[] data, int collisions) {
            this.data = data;
            this.collisions = collisions;
        }
    }

    public static enum Confirmation {
        CONFIRMED,
        REJECTED,
        CLARIFY;

    }

    public static class Builder {
        private int schemaId = BinaryUtils.schemaInitialId();
        private final ArrayList<Integer> fields = new ArrayList();

        public static Builder newBuilder() {
            return new Builder();
        }

        private Builder() {
        }

        public void addField(int fieldId) {
            this.fields.add(fieldId);
            this.schemaId = BinaryUtils.updateSchemaId(this.schemaId, fieldId);
        }

        public BinarySchema build() {
            return new BinarySchema(this.schemaId, this.fields);
        }
    }
}

