/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.events;

import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.events.EventAdapter;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;

public class CacheRebalancingEvent
extends EventAdapter {
    private static final long serialVersionUID = 0L;
    private String cacheName;
    private int part;
    private ClusterNode discoNode;
    private int discoEvtType;
    private long discoTs;

    public CacheRebalancingEvent(String cacheName, ClusterNode node, String msg, int type, int part, ClusterNode discoNode, int discoEvtType, long discoTs) {
        super(node, msg, type);
        this.cacheName = cacheName;
        this.part = part;
        this.discoNode = discoNode;
        this.discoEvtType = discoEvtType;
        this.discoTs = discoTs;
    }

    public String cacheName() {
        return this.cacheName;
    }

    public int partition() {
        return this.part;
    }

    public ClusterNode discoveryNode() {
        return this.discoNode;
    }

    public int discoveryEventType() {
        return this.discoEvtType;
    }

    public String discoveryEventName() {
        return U.gridEventName(this.discoEvtType);
    }

    public long discoveryTimestamp() {
        return this.discoTs;
    }

    @Override
    public String shortDisplay() {
        return this.name() + ": cache=" + CU.mask(this.cacheName) + ", cause=" + this.discoveryEventName();
    }

    @Override
    public String toString() {
        return S.toString(CacheRebalancingEvent.class, this, "discoEvtName", this.discoveryEventName(), "nodeId8", U.id8(this.node().id()), "msg", this.message(), "type", this.name(), "tstamp", this.timestamp());
    }
}

