/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.metrics.BaseSourceImpl;
import org.apache.hadoop.hbase.metrics.Interns;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerSource;
import org.apache.hadoop.hbase.regionserver.MetricsRegionServerWrapper;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;

@InterfaceAudience.Private
public class MetricsRegionServerSourceImpl
extends BaseSourceImpl
implements MetricsRegionServerSource {
    final MetricsRegionServerWrapper rsWrap;
    private final MetricHistogram putHisto;
    private final MetricHistogram deleteHisto;
    private final MetricHistogram getHisto;
    private final MetricHistogram incrementHisto;
    private final MetricHistogram appendHisto;
    private final MetricHistogram replayHisto;
    private final MetricHistogram scanNextHisto;
    private final MutableCounterLong slowPut;
    private final MutableCounterLong slowDelete;
    private final MutableCounterLong slowGet;
    private final MutableCounterLong slowIncrement;
    private final MutableCounterLong slowAppend;
    private final MutableCounterLong splitRequest;
    private final MutableCounterLong splitSuccess;
    private final MetricHistogram splitTimeHisto;
    private final MetricHistogram flushTimeHisto;

    public MetricsRegionServerSourceImpl(MetricsRegionServerWrapper rsWrap) {
        this("Server", "Metrics about HBase RegionServer", "regionserver", "RegionServer,sub=Server", rsWrap);
    }

    public MetricsRegionServerSourceImpl(String metricsName, String metricsDescription, String metricsContext, String metricsJmxContext, MetricsRegionServerWrapper rsWrap) {
        super(metricsName, metricsDescription, metricsContext, metricsJmxContext);
        this.rsWrap = rsWrap;
        this.putHisto = this.getMetricsRegistry().newTimeHistogram("mutate");
        this.slowPut = this.getMetricsRegistry().newCounter("slowPutCount", "The number of Multis that took over 1000ms to complete", 0L);
        this.deleteHisto = this.getMetricsRegistry().newTimeHistogram("delete");
        this.slowDelete = this.getMetricsRegistry().newCounter("slowDeleteCount", "The number of Deletes that took over 1000ms to complete", 0L);
        this.getHisto = this.getMetricsRegistry().newTimeHistogram("get");
        this.slowGet = this.getMetricsRegistry().newCounter("slowGetCount", "The number of Gets that took over 1000ms to complete", 0L);
        this.incrementHisto = this.getMetricsRegistry().newTimeHistogram("increment");
        this.slowIncrement = this.getMetricsRegistry().newCounter("slowIncrementCount", "The number of Increments that took over 1000ms to complete", 0L);
        this.appendHisto = this.getMetricsRegistry().newTimeHistogram("append");
        this.slowAppend = this.getMetricsRegistry().newCounter("slowAppendCount", "The number of Appends that took over 1000ms to complete", 0L);
        this.replayHisto = this.getMetricsRegistry().newTimeHistogram("replay");
        this.scanNextHisto = this.getMetricsRegistry().newTimeHistogram("scanNext");
        this.splitTimeHisto = this.getMetricsRegistry().newTimeHistogram("splitTime");
        this.flushTimeHisto = this.getMetricsRegistry().newTimeHistogram("flushTime");
        this.splitRequest = this.getMetricsRegistry().newCounter("splitRequestCount", "Number of splits requested", 0L);
        this.splitSuccess = this.getMetricsRegistry().newCounter("splitSuccessCount", "Number of successfully executed splits", 0L);
    }

    public void updatePut(long t) {
        this.putHisto.add(t);
    }

    public void updateDelete(long t) {
        this.deleteHisto.add(t);
    }

    public void updateGet(long t) {
        this.getHisto.add(t);
    }

    public void updateIncrement(long t) {
        this.incrementHisto.add(t);
    }

    public void updateAppend(long t) {
        this.appendHisto.add(t);
    }

    public void updateReplay(long t) {
        this.replayHisto.add(t);
    }

    public void updateScannerNext(long scanSize) {
        this.scanNextHisto.add(scanSize);
    }

    public void incrSlowPut() {
        this.slowPut.incr();
    }

    public void incrSlowDelete() {
        this.slowDelete.incr();
    }

    public void incrSlowGet() {
        this.slowGet.incr();
    }

    public void incrSlowIncrement() {
        this.slowIncrement.incr();
    }

    public void incrSlowAppend() {
        this.slowAppend.incr();
    }

    public void incrSplitRequest() {
        this.splitRequest.incr();
    }

    public void incrSplitSuccess() {
        this.splitSuccess.incr();
    }

    public void updateSplitTime(long t) {
        this.splitTimeHisto.add(t);
    }

    public void updateFlushTime(long t) {
        this.flushTimeHisto.add(t);
    }

    @Override
    public void getMetrics(MetricsCollector metricsCollector, boolean all) {
        MetricsRecordBuilder mrb = metricsCollector.addRecord(this.metricsName);
        if (this.rsWrap != null) {
            mrb.addGauge(Interns.info("regionCount", "Number of regions"), this.rsWrap.getNumOnlineRegions()).addGauge(Interns.info("storeCount", "Number of Stores"), this.rsWrap.getNumStores()).addGauge(Interns.info("hlogFileCount", "Number of WAL Files"), this.rsWrap.getNumWALFiles()).addGauge(Interns.info("hlogFileSize", "Size of all WAL Files"), this.rsWrap.getWALFileSize()).addGauge(Interns.info("storeFileCount", "Number of Store Files"), this.rsWrap.getNumStoreFiles()).addGauge(Interns.info("memStoreSize", "Size of the memstore"), this.rsWrap.getMemstoreSize()).addGauge(Interns.info("storeFileSize", "Size of storefiles being served."), this.rsWrap.getStoreFileSize()).addGauge(Interns.info("regionServerStartTime", "RegionServer Start Time"), this.rsWrap.getStartCode()).addCounter(Interns.info("totalRequestCount", "Total number of requests this RegionServer has answered."), this.rsWrap.getTotalRequestCount()).addCounter(Interns.info("readRequestCount", "Number of read requests this region server has answered."), this.rsWrap.getReadRequestsCount()).addCounter(Interns.info("writeRequestCount", "Number of mutation requests this region server has answered."), this.rsWrap.getWriteRequestsCount()).addCounter(Interns.info("checkMutateFailedCount", "Number of Check and Mutate calls that failed the checks."), this.rsWrap.getCheckAndMutateChecksFailed()).addCounter(Interns.info("checkMutatePassedCount", "Number of Check and Mutate calls that passed the checks."), this.rsWrap.getCheckAndMutateChecksPassed()).addGauge(Interns.info("storeFileIndexSize", "Size of indexes in storefiles on disk."), this.rsWrap.getStoreFileIndexSize()).addGauge(Interns.info("staticIndexSize", "Uncompressed size of the static indexes."), this.rsWrap.getTotalStaticIndexSize()).addGauge(Interns.info("staticBloomSize", "Uncompressed size of the static bloom filters."), this.rsWrap.getTotalStaticBloomSize()).addGauge(Interns.info("mutationsWithoutWALCount", "Number of mutations that have been sent by clients with the write ahead logging turned off."), this.rsWrap.getNumMutationsWithoutWAL()).addGauge(Interns.info("mutationsWithoutWALSize", "Size of data that has been sent by clients with the write ahead logging turned off."), this.rsWrap.getDataInMemoryWithoutWAL()).addGauge(Interns.info("percentFilesLocal", "The percent of HFiles that are stored on the local hdfs data node."), this.rsWrap.getPercentFileLocal()).addGauge(Interns.info("percentFilesLocalSecondaryRegions", "The percent of HFiles used by secondary regions that are stored on the local hdfs data node."), this.rsWrap.getPercentFileLocalSecondaryRegions()).addGauge(Interns.info("splitQueueLength", "Length of the queue for splits."), this.rsWrap.getSplitQueueSize()).addGauge(Interns.info("compactionQueueLength", "Length of the queue for compactions."), this.rsWrap.getCompactionQueueSize()).addGauge(Interns.info("flushQueueLength", "Length of the queue for region flushes"), this.rsWrap.getFlushQueueSize()).addGauge(Interns.info("blockCacheFreeSize", "Size of the block cache that is not occupied."), this.rsWrap.getBlockCacheFreeSize()).addGauge(Interns.info("blockCacheCount", "Number of block in the block cache."), this.rsWrap.getBlockCacheCount()).addGauge(Interns.info("blockCacheSize", "Size of the block cache."), this.rsWrap.getBlockCacheSize()).addCounter(Interns.info("blockCacheHitCount", "Count of the hit on the block cache."), this.rsWrap.getBlockCacheHitCount()).addCounter(Interns.info("blockCacheHitCountPrimary", "Count of hit on primary replica in the block cache."), this.rsWrap.getBlockCachePrimaryHitCount()).addCounter(Interns.info("blockCacheMissCount", "Number of requests for a block that missed the block cache."), this.rsWrap.getBlockCacheMissCount()).addCounter(Interns.info("blockCacheMissCountPrimary", "Number of requests for a block of primary replica that missed the block cache."), this.rsWrap.getBlockCachePrimaryMissCount()).addCounter(Interns.info("blockCacheEvictionCount", "Count of the number of blocks evicted from the block cache."), this.rsWrap.getBlockCacheEvictedCount()).addCounter(Interns.info("blockCacheEvictionCountPrimary", "Count of the number of blocks evicted from primary replica in the block cache."), this.rsWrap.getBlockCachePrimaryEvictedCount()).addGauge(Interns.info("blockCacheCountHitPercent", "Percent of block cache requests that are hits"), this.rsWrap.getBlockCacheHitPercent()).addGauge(Interns.info("blockCacheExpressHitPercent", "The percent of the time that requests with the cache turned on hit the cache."), this.rsWrap.getBlockCacheHitCachingPercent()).addCounter(Interns.info("blockCacheFailedInsertionCount", "Number of times that a block cache insertion failed. Usually due to size restrictions."), this.rsWrap.getBlockCacheFailedInsertions()).addCounter(Interns.info("updatesBlockedTime", "Number of MS updates have been blocked so that the memstore can be flushed."), this.rsWrap.getUpdatesBlockedTime()).addCounter(Interns.info("flushedCellsCount", "The number of cells flushed to disk"), this.rsWrap.getFlushedCellsCount()).addCounter(Interns.info("compactedCellsCount", "The number of cells processed during minor compactions"), this.rsWrap.getCompactedCellsCount()).addCounter(Interns.info("majorCompactedCellsCount", "The number of cells processed during major compactions"), this.rsWrap.getMajorCompactedCellsCount()).addCounter(Interns.info("flushedCellsSize", "The total amount of data flushed to disk, in bytes"), this.rsWrap.getFlushedCellsSize()).addCounter(Interns.info("compactedCellsSize", "The total amount of data processed during minor compactions, in bytes"), this.rsWrap.getCompactedCellsSize()).addCounter(Interns.info("majorCompactedCellsSize", "The total amount of data processed during major compactions, in bytes"), this.rsWrap.getMajorCompactedCellsSize()).addCounter(Interns.info("blockedRequestCount", "The number of blocked requests because of memstore size is larger than blockingMemStoreSize"), this.rsWrap.getBlockedRequestsCount()).tag(Interns.info("zookeeperQuorum", "Zookeeper Quorum"), this.rsWrap.getZookeeperQuorum()).tag(Interns.info("serverName", "Server Name"), this.rsWrap.getServerName()).tag(Interns.info("clusterId", "Cluster Id"), this.rsWrap.getClusterId());
        }
        this.metricsRegistry.snapshot(mrb, all);
    }
}

