/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.fjd;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.fjd.ThreadCompute;
import com.sagacloud.util.compute_engine.fjd.ThreadDelay;
import com.sagacloud.util.compute_engine.util.Constant;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DateAccelerator;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.zillion.database.agent.IZillionAgent;
import com.zillion.database.agent.ZillionAgent;
import com.zillion.util.zk.ZKLockRW;
import com.zillion.util.zk.ZKWrapper;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.Stat;

public class ThreadDelayItem
extends Thread {
    ZillionAgent agent;
    String database_name;
    private volatile boolean stop = false;
    List<ThreadCompute> threadList;
    String path_delay = ConstantCE.zk_root + "/delay";
    String path_delay_lock = ConstantCE.zk_root + "/delay_lock";
    SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");

    public ThreadDelayItem(ZillionAgent agent, String database_name) {
        this.agent = agent;
        this.database_name = database_name;
    }

    public void requestStop() {
        this.stop = true;
    }

    @Override
    public void run() {
        ZKWrapper ZK = this.agent.container.ZK;
        Date last_read_zk = null;
        List children = null;
        int index_child = 0;
        try {
            children = ZK.getChildren(this.path_delay, false);
            last_read_zk = DateAccelerator.Get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        while (!this.stop) {
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                Date curr = DateAccelerator.Get();
                if (children == null || last_read_zk == null || curr.getTime() - last_read_zk.getTime() > 60000L) {
                    children = ZK.getChildren(this.path_delay, false);
                    last_read_zk = DateAccelerator.Get();
                }
            }
            catch (Exception e) {
                Constant.error(e);
            }
            if (children == null || children.size() <= 0) continue;
            if (index_child >= children.size()) {
                index_child = 0;
            }
            String child = (String)children.get(index_child);
            try {
                this.Process(ZK, child);
            }
            catch (Exception e) {
                Constant.error(e);
            }
            ++index_child;
        }
    }

    private void Process(ZKWrapper ZK, String building) throws Exception {
        String parent_path_meta = this.path_delay_lock + "/" + building;
        Stat stat = ZK.exists(parent_path_meta, false);
        if (stat == null) {
            try {
                ZK.create(parent_path_meta, "true".getBytes(), CreateMode.PERSISTENT);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String lock_type_meta = "w";
        String node_path_meta = ZKLockRW.Create((ZKWrapper)ZK, (String)parent_path_meta, (String)lock_type_meta, (String)"true");
        try {
            boolean wait_success = ZKLockRW.WaitOnce((ZKWrapper)ZK, (String)parent_path_meta, (String)node_path_meta);
            Constant.debug("ThreadDelay instance wait lock " + building + " " + node_path_meta + " " + wait_success);
            if (wait_success) {
                this.ProcessInner(ZK, building);
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            ZKLockRW.Finish((ZKWrapper)ZK, (String)node_path_meta);
            Constant.debug("ThreadDelay instance finish lock " + building + " " + node_path_meta);
        }
    }

    private void ProcessInner(ZKWrapper ZK, String building) {
        Calendar calendar = Calendar.getInstance();
        try {
            Stat stat = new Stat();
            String data = new String(ZK.getData(this.path_delay + "/" + building, false, stat));
            Date processed_time = this.sdf.parse(data);
            Date curr_proc_time = new Date(DateAccelerator.Get().getTime() / (60000L * (long)ConstantCE.original_delay_period_minute) * (60000L * (long)ConstantCE.original_delay_period_minute));
            if (curr_proc_time.getTime() > processed_time.getTime()) {
                Constant.warn("delaylog\t" + building + "\t" + this.sdf.format(curr_proc_time) + "\tbegin");
                JSONObject Criteria = new JSONObject();
                Criteria.put("building", (Object)building);
                JSONArray Content = QueryUtil.select((IZillionAgent)this.agent, this.database_name, "original_present", Criteria);
                JSONArray InsertObjects = new JSONArray();
                long good_count = 0L;
                long delay_count = 0L;
                for (int i = 0; i < Content.size(); ++i) {
                    JSONObject item = (JSONObject)Content.get(i);
                    String meter = (String)item.get((Object)"meter");
                    long funcid = (Long)item.get((Object)"funcid");
                    String receivetime = (String)item.get((Object)"receivetime");
                    if (curr_proc_time.getTime() - this.sdf.parse(receivetime).getTime() > 60000L * (long)ConstantCE.original_delay_period_minute * (long)ConstantCE.original_delay_delayperiodcount) continue;
                    JSONObject InsertObject = new JSONObject();
                    InsertObject.put("building", (Object)building);
                    InsertObject.put("meter", (Object)meter);
                    InsertObject.put("funcid", (Object)funcid);
                    InsertObject.put("operate_time", (Object)this.sdf.format(curr_proc_time));
                    InsertObject.put("data_time", (Object)receivetime);
                    InsertObject.put("delay_second", (Object)((curr_proc_time.getTime() - this.sdf.parse(receivetime).getTime()) / 1000L));
                    if (curr_proc_time.getTime() - this.sdf.parse(receivetime).getTime() <= 60000L * (long)ConstantCE.original_delay_period_minute * (long)ConstantCE.original_delay_goodperiodcount) {
                        ++good_count;
                        InsertObject.put("flag", (Object)0L);
                    } else {
                        ++delay_count;
                        InsertObject.put("flag", (Object)1L);
                    }
                    InsertObjects.add((Object)InsertObject);
                }
                if (InsertObjects.size() > 0) {
                    QueryUtil.batch_insert((IZillionAgent)this.agent, this.database_name, "original_delaydetail", InsertObjects);
                }
                JSONObject InsertObject = new JSONObject();
                InsertObject.put("building", (Object)building);
                InsertObject.put("operate_time", (Object)this.sdf.format(curr_proc_time));
                InsertObject.put("total_count", (Object)Content.size());
                InsertObject.put("good_count", (Object)good_count);
                InsertObject.put("delay_count", (Object)delay_count);
                QueryUtil.insert((IZillionAgent)this.agent, this.database_name, "original_delaylog", InsertObject);
                ZK.setData(this.path_delay + "/" + building, this.sdf.format(curr_proc_time).getBytes(), -1);
                Constant.warn("delaylog\t" + building + "\t" + this.sdf.format(curr_proc_time) + "\tend");
                calendar.setTime(curr_proc_time);
                if (calendar.get(11) == 0 && calendar.get(12) == 0 && calendar.get(13) == 0) {
                    JSONObject job = new JSONObject();
                    job.put("building", (Object)building);
                    job.put("curr_proc_time", (Object)this.sdf.format(curr_proc_time));
                    ThreadDelay.Push(job);
                }
            }
        }
        catch (Exception e) {
            Constant.error(e);
        }
    }
}

