/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocol.datatransfer;

import org.apache.hadoop.HadoopIllegalArgumentException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public enum ReplaceDatanodeOnFailure {
    DISABLE,
    NEVER,
    DEFAULT,
    ALWAYS;


    public void checkEnabled() {
        if (this == DISABLE) {
            throw new UnsupportedOperationException("This feature is disabled.  Please refer to dfs.client.block.write.replace-datanode-on-failure.enable configuration property.");
        }
    }

    public boolean satisfy(short replication, DatanodeInfo[] existings, boolean isAppend, boolean isHflushed) {
        int n;
        int n2 = n = existings == null ? 0 : existings.length;
        if (n == 0 || n >= replication) {
            return false;
        }
        if (this == DISABLE || this == NEVER) {
            return false;
        }
        if (this == ALWAYS) {
            return true;
        }
        if (replication < 3) {
            return false;
        }
        if (n <= replication / 2) {
            return true;
        }
        return isAppend || isHflushed;
    }

    public static ReplaceDatanodeOnFailure get(Configuration conf) {
        boolean enabled = conf.getBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", true);
        if (!enabled) {
            return DISABLE;
        }
        String policy = conf.get("dfs.client.block.write.replace-datanode-on-failure.policy", "DEFAULT");
        for (int i = 1; i < ReplaceDatanodeOnFailure.values().length; ++i) {
            ReplaceDatanodeOnFailure rdof = ReplaceDatanodeOnFailure.values()[i];
            if (!rdof.name().equalsIgnoreCase(policy)) continue;
            return rdof;
        }
        throw new HadoopIllegalArgumentException("Illegal configuration value for dfs.client.block.write.replace-datanode-on-failure.policy: " + policy);
    }

    public void write(Configuration conf) {
        conf.setBoolean("dfs.client.block.write.replace-datanode-on-failure.enable", this != DISABLE);
        conf.set("dfs.client.block.write.replace-datanode-on-failure.policy", this.name());
    }
}

