/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.compute_engine.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject_fjd_near;
import com.sagacloud.util.compute_engine.util.QueryUtil;
import com.zillion.database.agent.IZillionAgent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

public class QueryUtil_fjd {
    public static List<DoubleTimeObject> get_fjd_merge(IZillionAgent agent, String database_name, String building, String meter, long funcid, String time_period, String query_time_from, String query_time_to, boolean GteLte, boolean return_fjd_near) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
        ArrayList<List<DoubleTimeObject>> dataListList = new ArrayList<List<DoubleTimeObject>>();
        JSONObject Criteria = new JSONObject();
        Criteria.put("building", (Object)building);
        Criteria.put("meter", (Object)meter);
        Criteria.put("funcid", (Object)funcid);
        if (!ConstantCE.time_period_seperate) {
            Criteria.put("time_period", (Object)time_period);
        }
        JSONObject range = new JSONObject();
        range.put("$gte", (Object)query_time_from);
        if (GteLte) {
            range.put("$lte", (Object)query_time_to);
        } else {
            range.put("$lt", (Object)query_time_to);
        }
        Criteria.put("data_time", (Object)range);
        int fjd_count = 4;
        for (int i = 0; i < fjd_count; ++i) {
            String table_name_query = ConstantCE.time_period_seperate ? "fjd_" + i + "_near_" + time_period : "fjd_" + i + "_near";
            JSONArray resultContent = QueryUtil.select(agent, database_name, table_name_query, Criteria);
            ArrayList<DoubleTimeObject> dataList = new ArrayList<DoubleTimeObject>();
            for (int ii = 0; ii < resultContent.size(); ++ii) {
                DoubleTimeObject data;
                JSONObject computelog = (JSONObject)resultContent.get(ii);
                if (return_fjd_near) {
                    DoubleTimeObject_fjd_near data_fjd_near = new DoubleTimeObject_fjd_near();
                    data_fjd_near.data_flag = (Long)computelog.get((Object)"data_flag");
                    data = data_fjd_near;
                } else {
                    data = new DoubleTimeObject();
                }
                data.data_time = sdf.parse((String)computelog.get((Object)"data_time"));
                data.data_value = (Double)computelog.get((Object)"data_value");
                dataList.add(data);
            }
            dataListList.add(dataList);
        }
        return QueryUtil_fjd.merge_fjd(dataListList);
    }

    private static List<DoubleTimeObject> merge_fjd(List<List<DoubleTimeObject>> dataListList) {
        ArrayList<DoubleTimeObject> result = new ArrayList<DoubleTimeObject>();
        int[] indexs = new int[dataListList.size()];
        block0: while (true) {
            Date min_time = null;
            ArrayList<Integer> indexList = new ArrayList<Integer>();
            for (int i = 0; i < indexs.length; ++i) {
                List<DoubleTimeObject> dataList = dataListList.get(i);
                if (indexs[i] >= dataList.size()) continue;
                DoubleTimeObject data = dataList.get(indexs[i]);
                if (min_time == null) {
                    min_time = data.data_time;
                    indexList.clear();
                    indexList.add(i);
                    continue;
                }
                int cmp = min_time.compareTo(data.data_time);
                if (cmp > 0) {
                    min_time = data.data_time;
                    indexList.clear();
                    indexList.add(i);
                    continue;
                }
                if (cmp != 0) continue;
                indexList.add(i);
            }
            if (min_time == null) break;
            int index_last = (Integer)indexList.get(indexList.size() - 1);
            result.add(dataListList.get(index_last).get(indexs[index_last]));
            Iterator iterator = indexList.iterator();
            while (true) {
                int i;
                if (!iterator.hasNext()) continue block0;
                int n = i = ((Integer)iterator.next()).intValue();
                indexs[n] = indexs[n] + 1;
            }
            break;
        }
        return result;
    }
}

