/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.util.VisorTaskUtils;
import org.jetbrains.annotations.Nullable;

public class VisorRestConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private boolean restEnabled;
    private boolean tcpSslEnabled;
    private String jettyPath;
    private String jettyHost;
    private Integer jettyPort;
    private String tcpHost;
    private int tcpPort;
    private String tcpSslCtxFactory;
    private String secretKey;
    private boolean noDelay;
    private boolean directBuf;
    private int sndBufSize;
    private int rcvBufSize;
    private long idleQryCurTimeout;
    private long idleQryCurCheckFreq;
    private int sndQueueLimit;
    private int selectorCnt;
    private long idleTimeout;
    private boolean sslClientAuth;
    private String sslFactory;
    private int portRange;
    private String msgInterceptor;

    public VisorRestConfiguration() {
    }

    public VisorRestConfiguration(IgniteConfiguration c) {
        assert (c != null);
        ConnectorConfiguration conCfg = c.getConnectorConfiguration();
        boolean bl = this.restEnabled = conCfg != null;
        if (this.restEnabled) {
            this.tcpSslEnabled = conCfg.isSslEnabled();
            this.jettyPath = conCfg.getJettyPath();
            this.jettyHost = System.getProperty("IGNITE_JETTY_HOST");
            this.jettyPort = VisorTaskUtils.intValue("IGNITE_JETTY_PORT", null);
            this.tcpHost = conCfg.getHost();
            this.tcpPort = conCfg.getPort();
            this.tcpSslCtxFactory = VisorTaskUtils.compactClass(conCfg.getSslContextFactory());
            this.secretKey = conCfg.getSecretKey();
            this.noDelay = conCfg.isNoDelay();
            this.directBuf = conCfg.isDirectBuffer();
            this.sndBufSize = conCfg.getSendBufferSize();
            this.rcvBufSize = conCfg.getReceiveBufferSize();
            this.idleQryCurTimeout = conCfg.getIdleQueryCursorTimeout();
            this.idleQryCurCheckFreq = conCfg.getIdleQueryCursorCheckFrequency();
            this.sndQueueLimit = conCfg.getSendQueueLimit();
            this.selectorCnt = conCfg.getSelectorCount();
            this.idleTimeout = conCfg.getIdleTimeout();
            this.sslClientAuth = conCfg.isSslClientAuth();
            this.sslFactory = VisorTaskUtils.compactClass(conCfg.getSslFactory());
            this.portRange = conCfg.getPortRange();
            this.msgInterceptor = VisorTaskUtils.compactClass(conCfg.getMessageInterceptor());
        }
    }

    public boolean isRestEnabled() {
        return this.restEnabled;
    }

    public boolean isTcpSslEnabled() {
        return this.tcpSslEnabled;
    }

    @Nullable
    public String getJettyPath() {
        return this.jettyPath;
    }

    @Nullable
    public String getJettyHost() {
        return this.jettyHost;
    }

    @Nullable
    public Integer getJettyPort() {
        return this.jettyPort;
    }

    @Nullable
    public String getTcpHost() {
        return this.tcpHost;
    }

    public int getTcpPort() {
        return this.tcpPort;
    }

    @Nullable
    public String getTcpSslContextFactory() {
        return this.tcpSslCtxFactory;
    }

    @Nullable
    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isNoDelay() {
        return this.noDelay;
    }

    public boolean isDirectBuffer() {
        return this.directBuf;
    }

    public int getSendBufferSize() {
        return this.sndBufSize;
    }

    public int getReceiveBufferSize() {
        return this.rcvBufSize;
    }

    public long getIdleQueryCursorTimeout() {
        return this.idleQryCurTimeout;
    }

    public long getIdleQueryCursorCheckFrequency() {
        return this.idleQryCurCheckFreq;
    }

    public int getSendQueueLimit() {
        return this.sndQueueLimit;
    }

    public int getSelectorCount() {
        return this.selectorCnt;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public boolean isSslClientAuth() {
        return this.sslClientAuth;
    }

    public String getSslFactory() {
        return this.sslFactory;
    }

    public int getPortRange() {
        return this.portRange;
    }

    @Nullable
    public String getMessageInterceptor() {
        return this.msgInterceptor;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeBoolean(this.restEnabled);
        out.writeBoolean(this.tcpSslEnabled);
        U.writeString(out, this.jettyPath);
        U.writeString(out, this.jettyHost);
        out.writeObject(this.jettyPort);
        U.writeString(out, this.tcpHost);
        out.writeInt(this.tcpPort);
        U.writeString(out, this.tcpSslCtxFactory);
        U.writeString(out, this.secretKey);
        out.writeBoolean(this.noDelay);
        out.writeBoolean(this.directBuf);
        out.writeInt(this.sndBufSize);
        out.writeInt(this.rcvBufSize);
        out.writeLong(this.idleQryCurTimeout);
        out.writeLong(this.idleQryCurCheckFreq);
        out.writeInt(this.sndQueueLimit);
        out.writeInt(this.selectorCnt);
        out.writeLong(this.idleTimeout);
        out.writeBoolean(this.sslClientAuth);
        U.writeString(out, this.sslFactory);
        out.writeInt(this.portRange);
        U.writeString(out, this.msgInterceptor);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.restEnabled = in.readBoolean();
        this.tcpSslEnabled = in.readBoolean();
        this.jettyPath = U.readString(in);
        this.jettyHost = U.readString(in);
        this.jettyPort = (Integer)in.readObject();
        this.tcpHost = U.readString(in);
        this.tcpPort = in.readInt();
        this.tcpSslCtxFactory = U.readString(in);
        this.secretKey = U.readString(in);
        this.noDelay = in.readBoolean();
        this.directBuf = in.readBoolean();
        this.sndBufSize = in.readInt();
        this.rcvBufSize = in.readInt();
        this.idleQryCurTimeout = in.readLong();
        this.idleQryCurCheckFreq = in.readLong();
        this.sndQueueLimit = in.readInt();
        this.selectorCnt = in.readInt();
        this.idleTimeout = in.readLong();
        this.sslClientAuth = in.readBoolean();
        this.sslFactory = U.readString(in);
        this.portRange = in.readInt();
        this.msgInterceptor = U.readString(in);
    }

    public String toString() {
        return S.toString(VisorRestConfiguration.class, this);
    }
}

