/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.snaptree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentNavigableMap;
import org.apache.ignite.internal.util.snaptree.CopyOnWriteManager;
import org.apache.ignite.internal.util.snaptree.Epoch;

public class SnapTreeMap<K, V>
extends AbstractMap<K, V>
implements ConcurrentNavigableMap<K, V>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 0L;
    static final boolean AllowNullValues = false;
    static final Object SpecialNull = new Object();
    static final Object SpecialRetry = new Object();
    static final int SpinCount = Integer.parseInt(System.getProperty("snaptree.spin", "100"));
    static final int YieldCount = Integer.parseInt(System.getProperty("snaptree.yield", "0"));
    static final char Left = 'L';
    static final char Right = 'R';
    static final long UnlinkedOVL = 2L;
    private final Comparator<? super K> comparator;
    private volatile transient COWMgr<K, V> holderRef;
    private static final int UpdateAlways = 0;
    private static final int UpdateIfAbsent = 1;
    private static final int UpdateIfPresent = 2;
    private static final int UpdateIfEq = 3;
    private static final int UnlinkRequired = -1;
    private static final int RebalanceRequired = -2;
    private static final int NothingRequired = -3;

    static long beginChange(long ovl) {
        return ovl | 1L;
    }

    static long endChange(long ovl) {
        return (ovl | 3L) + 1L;
    }

    static boolean isShrinking(long ovl) {
        return (ovl & 1L) != 0L;
    }

    static boolean isUnlinked(long ovl) {
        return (ovl & 2L) != 0L;
    }

    static boolean isShrinkingOrUnlinked(long ovl) {
        return (ovl & 3L) != 0L;
    }

    private static int height(Node<?, ?> node) {
        return node == null ? 0 : node.height;
    }

    private V decodeNull(Object vOpt) {
        assert (vOpt != SpecialRetry);
        return (V)vOpt;
    }

    private static Object encodeNull(Object v) {
        if (v == null) {
            throw new NullPointerException();
        }
        return v;
    }

    public SnapTreeMap() {
        this.comparator = null;
        this.holderRef = new COWMgr();
    }

    public SnapTreeMap(Comparator<? super K> comparator) {
        this.comparator = comparator;
        this.holderRef = new COWMgr();
    }

    public SnapTreeMap(Map<? extends K, ? extends V> source) {
        this.comparator = null;
        this.holderRef = new COWMgr();
        this.putAll(source);
    }

    public SnapTreeMap(SortedMap<K, ? extends V> source) {
        this.comparator = source.comparator();
        if (source instanceof SnapTreeMap) {
            SnapTreeMap s = (SnapTreeMap)source;
            this.holderRef = (COWMgr)s.holderRef.clone();
        } else {
            int size = 0;
            RootHolder holder = new RootHolder();
            for (Map.Entry<K, V> e : source.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (k == null) {
                    throw new NullPointerException("source map contained a null key");
                }
                if (v == null) {
                    throw new NullPointerException("source map contained a null value");
                }
                this.updateUnderRoot(k, this.comparable(k), 0, null, SnapTreeMap.encodeNull(v), holder);
                ++size;
            }
            this.holderRef = new COWMgr(holder, size);
        }
    }

    @Override
    public SnapTreeMap<K, V> clone() {
        SnapTreeMap copy;
        try {
            copy = (SnapTreeMap)super.clone();
        }
        catch (CloneNotSupportedException xx) {
            throw new InternalError();
        }
        assert (copy.comparator == this.comparator);
        copy.holderRef = (COWMgr)this.holderRef.clone();
        return copy;
    }

    @Override
    public int size() {
        return this.holderRef.size();
    }

    @Override
    public boolean isEmpty() {
        return ((RootHolder)this.holderRef.read()).right == null;
    }

    @Override
    public void clear() {
        this.holderRef = new COWMgr();
    }

    @Override
    public Comparator<? super K> comparator() {
        return this.comparator;
    }

    @Override
    public boolean containsValue(Object value) {
        SnapTreeMap.encodeNull(value);
        return super.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getImpl(key) != null;
    }

    @Override
    public V get(Object key) {
        return this.decodeNull(this.getImpl(key));
    }

    protected Comparable<? super K> comparable(final Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (this.comparator == null) {
            return (Comparable)key;
        }
        return new Comparable<K>(){
            final Comparator<? super K> _cmp;
            {
                this._cmp = SnapTreeMap.this.comparator;
            }

            @Override
            public int compareTo(K rhs) {
                return this._cmp.compare(key, rhs);
            }
        };
    }

    private Object getImpl(Object key) {
        Object vo;
        Comparable<K> k = this.comparable(key);
        while (true) {
            Node right;
            if ((right = ((RootHolder)this.holderRef.read()).right) == null) {
                return null;
            }
            int rightCmp = k.compareTo(right.key);
            if (rightCmp == 0) {
                return right.vOpt;
            }
            long ovl = right.shrinkOVL;
            if (SnapTreeMap.isShrinkingOrUnlinked(ovl)) {
                right.waitUntilShrinkCompleted(ovl);
                continue;
            }
            if (right == ((RootHolder)this.holderRef.read()).right && (vo = this.attemptGet(k, right, rightCmp < 0 ? (char)'L' : 'R', ovl)) != SpecialRetry) break;
        }
        return vo;
    }

    private Object attemptGet(Comparable<? super K> k, Node<K, V> node, char dirToC, long nodeOVL) {
        Object vo;
        while (true) {
            Node<K, V> child;
            if ((child = node.child(dirToC)) == null) {
                if (node.shrinkOVL != nodeOVL) {
                    return SpecialRetry;
                }
                return null;
            }
            int childCmp = k.compareTo(child.key);
            if (childCmp == 0) {
                return child.vOpt;
            }
            long childOVL = child.shrinkOVL;
            if (SnapTreeMap.isShrinkingOrUnlinked(childOVL)) {
                ((Node)child).waitUntilShrinkCompleted(childOVL);
                if (node.shrinkOVL == nodeOVL) continue;
                return SpecialRetry;
            }
            if (child != node.child(dirToC)) {
                if (node.shrinkOVL == nodeOVL) continue;
                return SpecialRetry;
            }
            if (node.shrinkOVL != nodeOVL) {
                return SpecialRetry;
            }
            vo = this.attemptGet(k, child, childCmp < 0 ? (char)'L' : 'R', childOVL);
            if (vo != SpecialRetry) break;
        }
        return vo;
    }

    @Override
    public K firstKey() {
        return this.extremeKeyOrThrow('L');
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return (AbstractMap.SimpleImmutableEntry)this.extreme(false, 'L');
    }

    @Override
    public K lastKey() {
        return this.extremeKeyOrThrow('R');
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return (AbstractMap.SimpleImmutableEntry)this.extreme(false, 'R');
    }

    private K extremeKeyOrThrow(char dir) {
        Object k = this.extreme(true, dir);
        if (k == null) {
            throw new NoSuchElementException();
        }
        return (K)k;
    }

    private Object extreme(boolean returnKey, char dir) {
        Object vo;
        while (true) {
            Node right;
            if ((right = ((RootHolder)this.holderRef.read()).right) == null) {
                return null;
            }
            long ovl = right.shrinkOVL;
            if (SnapTreeMap.isShrinkingOrUnlinked(ovl)) {
                right.waitUntilShrinkCompleted(ovl);
                continue;
            }
            if (right == ((RootHolder)this.holderRef.read()).right && (vo = this.attemptExtreme(returnKey, dir, right, ovl)) != SpecialRetry) break;
        }
        return vo;
    }

    private Object attemptExtreme(boolean returnKey, char dir, Node<K, V> node, long nodeOVL) {
        Object vo;
        while (true) {
            Node<K, V> child;
            if ((child = node.child(dir)) == null) {
                Object vo2 = node.vOpt;
                if (node.shrinkOVL != nodeOVL) {
                    return SpecialRetry;
                }
                assert (vo2 != null);
                return returnKey ? node.key : new AbstractMap.SimpleImmutableEntry(node.key, this.decodeNull(vo2));
            }
            long childOVL = child.shrinkOVL;
            if (SnapTreeMap.isShrinkingOrUnlinked(childOVL)) {
                ((Node)child).waitUntilShrinkCompleted(childOVL);
                if (node.shrinkOVL == nodeOVL) continue;
                return SpecialRetry;
            }
            if (child != node.child(dir)) {
                if (node.shrinkOVL == nodeOVL) continue;
                return SpecialRetry;
            }
            if (node.shrinkOVL != nodeOVL) {
                return SpecialRetry;
            }
            vo = this.attemptExtreme(returnKey, dir, child, childOVL);
            if (vo != SpecialRetry) break;
        }
        return vo;
    }

    @Override
    public K lowerKey(K key) {
        return (K)this.boundedExtreme(null, false, this.comparable(key), false, true, 'R');
    }

    @Override
    public K floorKey(K key) {
        return (K)this.boundedExtreme(null, false, this.comparable(key), true, true, 'R');
    }

    @Override
    public K ceilingKey(K key) {
        return (K)this.boundedExtreme(this.comparable(key), true, null, false, true, 'L');
    }

    @Override
    public K higherKey(K key) {
        return (K)this.boundedExtreme(this.comparable(key), false, null, false, true, 'L');
    }

    @Override
    public Map.Entry<K, V> lowerEntry(K key) {
        return (Map.Entry)this.boundedExtreme(null, false, this.comparable(key), false, false, 'R');
    }

    @Override
    public Map.Entry<K, V> floorEntry(K key) {
        return (Map.Entry)this.boundedExtreme(null, false, this.comparable(key), true, false, 'R');
    }

    @Override
    public Map.Entry<K, V> ceilingEntry(K key) {
        return (Map.Entry)this.boundedExtreme(this.comparable(key), true, null, false, false, 'L');
    }

    @Override
    public Map.Entry<K, V> higherEntry(K key) {
        return (Map.Entry)this.boundedExtreme(this.comparable(key), false, null, false, false, 'L');
    }

    private K boundedExtremeKeyOrThrow(Comparable<? super K> minCmp, boolean minIncl, Comparable<? super K> maxCmp, boolean maxIncl, char dir) {
        Object k = this.boundedExtreme(minCmp, minIncl, maxCmp, maxIncl, true, dir);
        if (k == null) {
            throw new NoSuchElementException();
        }
        return (K)k;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object boundedExtreme(Comparable<? super K> minCmp, boolean minIncl, Comparable<? super K> maxCmp, boolean maxIncl, boolean returnKey, char dir) {
        int c;
        Object resultKey;
        Object result;
        if (dir == 'L' && minCmp == null || dir == 'R' && maxCmp == null) {
            result = this.extreme(returnKey, dir);
            if (result == null) {
                return null;
            }
            resultKey = returnKey ? result : ((AbstractMap.SimpleImmutableEntry)result).getKey();
        } else {
            Epoch.Ticket ticket;
            RootHolder holder = (RootHolder)this.holderRef.availableFrozen();
            if (holder == null) {
                ticket = this.holderRef.beginQuiescent();
                holder = (RootHolder)this.holderRef.read();
            } else {
                ticket = null;
            }
            try {
                Node<K, V> node;
                Node<Object, V> node2 = node = dir == 'L' ? this.boundedMin(holder.right, minCmp, minIncl) : this.boundedMax(holder.right, maxCmp, maxIncl);
                if (node == null) {
                    Object var12_14 = null;
                    return var12_14;
                }
                resultKey = node.key;
                result = returnKey ? node.key : (ticket == null ? node : new AbstractMap.SimpleImmutableEntry(node.key, node.getValue()));
            }
            finally {
                if (ticket != null) {
                    ticket.leave(0);
                }
            }
        }
        if (dir == 'L' && maxCmp != null && ((c = maxCmp.compareTo(resultKey)) < 0 || c == 0 && !maxIncl)) {
            return null;
        }
        if (dir == 'R' && minCmp != null && ((c = minCmp.compareTo(resultKey)) > 0 || c == 0 && !minIncl)) {
            return null;
        }
        return result;
    }

    private Node<K, V> boundedMin(Node<K, V> node, Comparable<? super K> minCmp, boolean minIncl) {
        while (node != null) {
            Node z;
            int c = minCmp.compareTo(node.key);
            if (c < 0 && (z = this.boundedMin(node.left, minCmp, minIncl)) != null) {
                return z;
            }
            if ((c < 0 || c == 0 && minIncl) && node.vOpt != null) {
                return node;
            }
            node = node.right;
        }
        return null;
    }

    private Node<K, V> boundedMax(Node<K, V> node, Comparable<? super K> maxCmp, boolean maxIncl) {
        while (node != null) {
            Node z;
            int c = maxCmp.compareTo(node.key);
            if (c > 0 && (z = this.boundedMax(node.right, maxCmp, maxIncl)) != null) {
                return z;
            }
            if ((c > 0 || c == 0 && maxIncl) && node.vOpt != null) {
                return node;
            }
            node = node.left;
        }
        return null;
    }

    private static boolean shouldUpdate(int func, Object prev, Object expected) {
        switch (func) {
            case 0: {
                return true;
            }
            case 1: {
                return prev == null;
            }
            case 2: {
                return prev != null;
            }
        }
        assert (expected != null);
        if (prev == null) {
            return false;
        }
        return prev.equals(expected);
    }

    private static Object noUpdateResult(int func, Object prev) {
        return func == 3 ? Boolean.FALSE : prev;
    }

    private static Object updateResult(int func, Object prev) {
        return func == 3 ? Boolean.TRUE : prev;
    }

    private static int sizeDelta(int func, Object result, Object newValue) {
        switch (func) {
            case 0: {
                return (result != null ? -1 : 0) + (newValue != null ? 1 : 0);
            }
            case 1: {
                assert (newValue != null);
                return result != null ? 0 : 1;
            }
            case 2: {
                return result == null ? 0 : (newValue != null ? 0 : -1);
            }
        }
        return (Boolean)result == false ? 0 : (newValue != null ? 0 : -1);
    }

    @Override
    public V put(K key, V value) {
        return this.decodeNull(this.update(key, 0, null, SnapTreeMap.encodeNull(value)));
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.decodeNull(this.update(key, 1, null, SnapTreeMap.encodeNull(value)));
    }

    @Override
    public V replace(K key, V value) {
        return this.decodeNull(this.update(key, 2, null, SnapTreeMap.encodeNull(value)));
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return (Boolean)this.update(key, 3, SnapTreeMap.encodeNull(oldValue), SnapTreeMap.encodeNull(newValue));
    }

    @Override
    public V remove(Object key) {
        return this.decodeNull(this.update(key, 0, null, null));
    }

    @Override
    public boolean remove(Object key, Object value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            return false;
        }
        return (Boolean)this.update(key, 3, SnapTreeMap.encodeNull(value), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object update(Object key, int func, Object expected, Object newValue) {
        Comparable<K> k = this.comparable(key);
        int sd = 0;
        Epoch.Ticket ticket = this.holderRef.beginMutation();
        try {
            Object result = this.updateUnderRoot(key, k, func, expected, newValue, (RootHolder)this.holderRef.mutable());
            sd = SnapTreeMap.sizeDelta(func, result, newValue);
            Object object = result;
            return object;
        }
        finally {
            ticket.leave(sd);
        }
    }

    private Object updateUnderRoot(Object key, Comparable<? super K> k, int func, Object expected, Object newValue, RootHolder<K, V> holder) {
        Object vo;
        while (true) {
            Node right;
            if ((right = holder.unsharedRight()) == null) {
                if (!SnapTreeMap.shouldUpdate(func, null, expected)) {
                    return SnapTreeMap.noUpdateResult(func, null);
                }
                if (newValue != null && !this.attemptInsertIntoEmpty(key, newValue, holder)) continue;
                return SnapTreeMap.updateResult(func, null);
            }
            long ovl = right.shrinkOVL;
            if (SnapTreeMap.isShrinkingOrUnlinked(ovl)) {
                right.waitUntilShrinkCompleted(ovl);
                continue;
            }
            if (right == holder.right && (vo = this.attemptUpdate(key, k, func, expected, newValue, holder, right, ovl)) != SpecialRetry) break;
        }
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptInsertIntoEmpty(K key, Object vOpt, RootHolder<K, V> holder) {
        RootHolder<K, V> rootHolder = holder;
        synchronized (rootHolder) {
            if (holder.right == null) {
                holder.right = new Node<K, V>(key, 1, vOpt, holder, 0L, null, null);
                holder.height = 2;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object attemptUpdate(Object key, Comparable<? super K> k, int func, Object expected, Object newValue, Node<K, V> parent, Node<K, V> node, long nodeOVL) {
        Object vo;
        assert (nodeOVL != 2L);
        int cmp = k.compareTo(node.key);
        if (cmp == 0) {
            return this.attemptNodeUpdate(func, expected, newValue, parent, node);
        }
        char dirToC = cmp < 0 ? (char)'L' : 'R';
        while (true) {
            Node<K, V> child = node.unsharedChild(dirToC);
            if (node.shrinkOVL != nodeOVL) {
                return SpecialRetry;
            }
            if (child == null) {
                Node<K, V> damaged;
                boolean success;
                if (newValue == null) {
                    return SnapTreeMap.noUpdateResult(func, null);
                }
                Node<Object, V> node2 = node;
                synchronized (node2) {
                    if (node.shrinkOVL != nodeOVL) {
                        return SpecialRetry;
                    }
                    if (node.child(dirToC) != null) {
                        success = false;
                        damaged = null;
                    } else {
                        if (!SnapTreeMap.shouldUpdate(func, null, expected)) {
                            return SnapTreeMap.noUpdateResult(func, null);
                        }
                        node.setChild(dirToC, new Node<Object, V>(key, 1, newValue, node, 0L, null, null));
                        success = true;
                        damaged = this.fixHeight_nl(node);
                    }
                }
                if (!success) continue;
                this.fixHeightAndRebalance(damaged);
                return SnapTreeMap.updateResult(func, null);
            }
            long childOVL = child.shrinkOVL;
            if (SnapTreeMap.isShrinkingOrUnlinked(childOVL)) {
                ((Node)child).waitUntilShrinkCompleted(childOVL);
                continue;
            }
            if (child != node.child(dirToC)) continue;
            if (node.shrinkOVL != nodeOVL) {
                return SpecialRetry;
            }
            vo = this.attemptUpdate(key, k, func, expected, newValue, node, child, childOVL);
            if (vo != SpecialRetry) break;
        }
        return vo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object attemptNodeUpdate(int func, Object expected, Object newValue, Node<K, V> parent, Node<K, V> node) {
        if (newValue == null && node.vOpt == null) {
            return SnapTreeMap.noUpdateResult(func, null);
        }
        if (newValue == null && (node.left == null || node.right == null)) {
            Node<K, V> damaged;
            Object prev;
            Node<K, V> node2 = parent;
            synchronized (node2) {
                if (SnapTreeMap.isUnlinked(parent.shrinkOVL) || node.parent != parent) {
                    return SpecialRetry;
                }
                Node<K, V> node3 = node;
                synchronized (node3) {
                    prev = node.vOpt;
                    if (!SnapTreeMap.shouldUpdate(func, prev, expected)) {
                        return SnapTreeMap.noUpdateResult(func, prev);
                    }
                    if (prev == null) {
                        return SnapTreeMap.updateResult(func, prev);
                    }
                    if (!this.attemptUnlink_nl(parent, node)) {
                        return SpecialRetry;
                    }
                }
                damaged = this.fixHeight_nl(parent);
            }
            this.fixHeightAndRebalance(damaged);
            return SnapTreeMap.updateResult(func, prev);
        }
        Node<K, V> node4 = node;
        synchronized (node4) {
            if (SnapTreeMap.isUnlinked(node.shrinkOVL)) {
                return SpecialRetry;
            }
            Object prev = node.vOpt;
            if (!SnapTreeMap.shouldUpdate(func, prev, expected)) {
                return SnapTreeMap.noUpdateResult(func, prev);
            }
            if (newValue == null && (node.left == null || node.right == null)) {
                return SpecialRetry;
            }
            node.vOpt = newValue;
            this.afterNodeUpdate_nl(node, newValue);
            return SnapTreeMap.updateResult(func, prev);
        }
    }

    protected void afterNodeUpdate_nl(Node<K, V> node, Object val) {
    }

    private boolean attemptUnlink_nl(Node<K, V> parent, Node<K, V> node) {
        Node<K, V> splice;
        assert (!SnapTreeMap.isUnlinked(parent.shrinkOVL));
        Node parentL = parent.left;
        Node parentR = parent.right;
        if (parentL != node && parentR != node) {
            return false;
        }
        assert (!SnapTreeMap.isUnlinked(node.shrinkOVL));
        assert (parent == node.parent);
        Node<K, V> left = node.unsharedLeft();
        Node<K, V> right = node.unsharedRight();
        if (left != null && right != null) {
            return false;
        }
        Node<K, V> node2 = splice = left != null ? left : right;
        if (parentL == node) {
            parent.left = splice;
        } else {
            parent.right = splice;
        }
        if (splice != null) {
            splice.parent = parent;
        }
        node.shrinkOVL = 2L;
        node.vOpt = null;
        return true;
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.pollExtremeEntry('L');
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.pollExtremeEntry('R');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<K, V> pollExtremeEntry(char dir) {
        Epoch.Ticket ticket = this.holderRef.beginMutation();
        int sizeDelta = 0;
        try {
            Map.Entry<K, V> prev = this.pollExtremeEntryUnderRoot(dir, (RootHolder)this.holderRef.mutable());
            if (prev != null) {
                sizeDelta = -1;
            }
            Map.Entry<K, V> entry = prev;
            return entry;
        }
        finally {
            ticket.leave(sizeDelta);
        }
    }

    private Map.Entry<K, V> pollExtremeEntryUnderRoot(char dir, RootHolder<K, V> holder) {
        Map.Entry<K, V> result;
        while (true) {
            Node right;
            if ((right = holder.unsharedRight()) == null) {
                return null;
            }
            long ovl = right.shrinkOVL;
            if (SnapTreeMap.isShrinkingOrUnlinked(ovl)) {
                right.waitUntilShrinkCompleted(ovl);
                continue;
            }
            if (right == holder.right && (result = this.attemptRemoveExtreme(dir, holder, right, ovl)) != SpecialRetry) break;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<K, V> attemptRemoveExtreme(char dir, Node<K, V> parent, Node<K, V> node, long nodeOVL) {
        Map.Entry<K, V> result;
        assert (nodeOVL != 2L);
        while (true) {
            Node<K, V> child = node.unsharedChild(dir);
            if (nodeOVL != node.shrinkOVL) {
                return null;
            }
            if (child == null) {
                Node<K, V> damaged;
                Object vo;
                Node<K, V> node2 = parent;
                synchronized (node2) {
                    if (SnapTreeMap.isUnlinked(parent.shrinkOVL) || node.parent != parent) {
                        return null;
                    }
                    Node<K, V> node3 = node;
                    synchronized (node3) {
                        vo = node.vOpt;
                        if (node.child(dir) != null || !this.attemptUnlink_nl(parent, node)) {
                            return null;
                        }
                    }
                    damaged = this.fixHeight_nl(parent);
                }
                this.fixHeightAndRebalance(damaged);
                return new AbstractMap.SimpleImmutableEntry(node.key, this.decodeNull(vo));
            }
            long childOVL = child.shrinkOVL;
            if (SnapTreeMap.isShrinkingOrUnlinked(childOVL)) {
                ((Node)child).waitUntilShrinkCompleted(childOVL);
                continue;
            }
            if (child != node.child(dir)) continue;
            if (node.shrinkOVL != nodeOVL) {
                return null;
            }
            result = this.attemptRemoveExtreme(dir, node, child, childOVL);
            if (result != null) break;
        }
        return result;
    }

    private int nodeCondition(Node<K, V> node) {
        Node nL = node.left;
        Node nR = node.right;
        if ((nL == null || nR == null) && node.vOpt == null) {
            return -1;
        }
        int hN = node.height;
        int hL0 = SnapTreeMap.height(nL);
        int hR0 = SnapTreeMap.height(nR);
        int hNRepl = 1 + Math.max(hL0, hR0);
        int bal = hL0 - hR0;
        if (bal < -1 || bal > 1) {
            return -2;
        }
        return hN != hNRepl ? hNRepl : -3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fixHeightAndRebalance(Node<K, V> node) {
        while (node != null && node.parent != null) {
            Node nParent;
            int condition = this.nodeCondition(node);
            if (condition == -3 || SnapTreeMap.isUnlinked(node.shrinkOVL)) {
                return;
            }
            if (condition != -1 && condition != -2) {
                Node<K, V> node2 = node;
                synchronized (node2) {
                    node = this.fixHeight_nl(node);
                    continue;
                }
            }
            Node node3 = nParent = node.parent;
            synchronized (node3) {
                if (!SnapTreeMap.isUnlinked(nParent.shrinkOVL) && node.parent == nParent) {
                    Node<K, V> node4 = node;
                    synchronized (node4) {
                        node = this.rebalance_nl(nParent, node);
                    }
                }
            }
        }
    }

    private Node<K, V> fixHeight_nl(Node<K, V> node) {
        int c = this.nodeCondition(node);
        switch (c) {
            case -2: 
            case -1: {
                return node;
            }
            case -3: {
                return null;
            }
        }
        node.height = c;
        return node.parent;
    }

    private Node<K, V> rebalance_nl(Node<K, V> nParent, Node<K, V> n) {
        Node<K, V> nL = n.unsharedLeft();
        Node<K, V> nR = n.unsharedRight();
        if ((nL == null || nR == null) && n.vOpt == null) {
            if (this.attemptUnlink_nl(nParent, n)) {
                return this.fixHeight_nl(nParent);
            }
            return n;
        }
        int hN = n.height;
        int hL0 = SnapTreeMap.height(nL);
        int hR0 = SnapTreeMap.height(nR);
        int hNRepl = 1 + Math.max(hL0, hR0);
        int bal = hL0 - hR0;
        if (bal > 1) {
            return this.rebalanceToRight_nl(nParent, n, nL, hR0);
        }
        if (bal < -1) {
            return this.rebalanceToLeft_nl(nParent, n, nR, hL0);
        }
        if (hNRepl != hN) {
            n.height = hNRepl;
            return this.fixHeight_nl(nParent);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<K, V> rebalanceToRight_nl(Node<K, V> nParent, Node<K, V> n, Node<K, V> nL, int hR0) {
        Node<K, V> node = nL;
        synchronized (node) {
            int hLR0;
            int hL = nL.height;
            if (hL - hR0 <= 1) {
                return n;
            }
            Node<K, V> nLR = nL.unsharedRight();
            int hLL0 = SnapTreeMap.height(nL.left);
            if (hLL0 >= (hLR0 = SnapTreeMap.height(nLR))) {
                return this.rotateRight_nl(nParent, n, nL, hR0, hLL0, nLR, hLR0);
            }
            Node<K, V> node2 = nLR;
            synchronized (node2) {
                int hLR = nLR.height;
                if (hLL0 >= hLR) {
                    return this.rotateRight_nl(nParent, n, nL, hR0, hLL0, nLR, hLR);
                }
                int hLRL = SnapTreeMap.height(nLR.left);
                int b = hLL0 - hLRL;
                if (b >= -1 && b <= 1 && (hLL0 != 0 && hLRL != 0 || nL.vOpt != null)) {
                    return this.rotateRightOverLeft_nl(nParent, n, nL, hR0, hLL0, nLR, hLRL);
                }
            }
            return this.rebalanceToLeft_nl(n, nL, nLR, hLL0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node<K, V> rebalanceToLeft_nl(Node<K, V> nParent, Node<K, V> n, Node<K, V> nR, int hL0) {
        Node<K, V> node = nR;
        synchronized (node) {
            int hR = nR.height;
            if (hL0 - hR >= -1) {
                return n;
            }
            Node<K, V> nRL = nR.unsharedLeft();
            int hRL0 = SnapTreeMap.height(nRL);
            int hRR0 = SnapTreeMap.height(nR.right);
            if (hRR0 >= hRL0) {
                return this.rotateLeft_nl(nParent, n, hL0, nR, nRL, hRL0, hRR0);
            }
            Node<K, V> node2 = nRL;
            synchronized (node2) {
                int hRL = nRL.height;
                if (hRR0 >= hRL) {
                    return this.rotateLeft_nl(nParent, n, hL0, nR, nRL, hRL, hRR0);
                }
                int hRLR = SnapTreeMap.height(nRL.right);
                int b = hRR0 - hRLR;
                if (b >= -1 && b <= 1 && (hRR0 != 0 && hRLR != 0 || nR.vOpt != null)) {
                    return this.rotateLeftOverRight_nl(nParent, n, hL0, nR, nRL, hRR0, hRLR);
                }
            }
            return this.rebalanceToRight_nl(n, nR, nRL, hRR0);
        }
    }

    private Node<K, V> rotateRight_nl(Node<K, V> nParent, Node<K, V> n, Node<K, V> nL, int hR, int hLL, Node<K, V> nLR, int hLR) {
        int hNRepl;
        long nodeOVL = n.shrinkOVL;
        Node nPL = nParent.left;
        n.shrinkOVL = SnapTreeMap.beginChange(nodeOVL);
        n.left = nLR;
        if (nLR != null) {
            nLR.parent = n;
        }
        nL.right = n;
        n.parent = nL;
        if (nPL == n) {
            nParent.left = nL;
        } else {
            nParent.right = nL;
        }
        nL.parent = nParent;
        n.height = hNRepl = 1 + Math.max(hLR, hR);
        nL.height = 1 + Math.max(hLL, hNRepl);
        n.shrinkOVL = SnapTreeMap.endChange(nodeOVL);
        int balN = hLR - hR;
        if (balN < -1 || balN > 1) {
            return n;
        }
        if ((nLR == null || hR == 0) && n.vOpt == null) {
            return n;
        }
        int balL = hLL - hNRepl;
        if (balL < -1 || balL > 1) {
            return nL;
        }
        if (hLL == 0 && nL.vOpt == null) {
            return nL;
        }
        return this.fixHeight_nl(nParent);
    }

    private Node<K, V> rotateLeft_nl(Node<K, V> nParent, Node<K, V> n, int hL, Node<K, V> nR, Node<K, V> nRL, int hRL, int hRR) {
        int hNRepl;
        long nodeOVL = n.shrinkOVL;
        Node nPL = nParent.left;
        n.shrinkOVL = SnapTreeMap.beginChange(nodeOVL);
        n.right = nRL;
        if (nRL != null) {
            nRL.parent = n;
        }
        nR.left = n;
        n.parent = nR;
        if (nPL == n) {
            nParent.left = nR;
        } else {
            nParent.right = nR;
        }
        nR.parent = nParent;
        n.height = hNRepl = 1 + Math.max(hL, hRL);
        nR.height = 1 + Math.max(hNRepl, hRR);
        n.shrinkOVL = SnapTreeMap.endChange(nodeOVL);
        int balN = hRL - hL;
        if (balN < -1 || balN > 1) {
            return n;
        }
        if ((nRL == null || hL == 0) && n.vOpt == null) {
            return n;
        }
        int balR = hRR - hNRepl;
        if (balR < -1 || balR > 1) {
            return nR;
        }
        if (hRR == 0 && nR.vOpt == null) {
            return nR;
        }
        return this.fixHeight_nl(nParent);
    }

    private Node<K, V> rotateRightOverLeft_nl(Node<K, V> nParent, Node<K, V> n, Node<K, V> nL, int hR, int hLL, Node<K, V> nLR, int hLRL) {
        int hLRepl;
        int hNRepl;
        long nodeOVL = n.shrinkOVL;
        long leftOVL = nL.shrinkOVL;
        Node nPL = nParent.left;
        Node<K, V> nLRL = nLR.unsharedLeft();
        Node<K, V> nLRR = nLR.unsharedRight();
        int hLRR = SnapTreeMap.height(nLRR);
        n.shrinkOVL = SnapTreeMap.beginChange(nodeOVL);
        nL.shrinkOVL = SnapTreeMap.beginChange(leftOVL);
        n.left = nLRR;
        if (nLRR != null) {
            nLRR.parent = n;
        }
        nL.right = nLRL;
        if (nLRL != null) {
            nLRL.parent = nL;
        }
        nLR.left = nL;
        nL.parent = nLR;
        nLR.right = n;
        n.parent = nLR;
        if (nPL == n) {
            nParent.left = nLR;
        } else {
            nParent.right = nLR;
        }
        nLR.parent = nParent;
        n.height = hNRepl = 1 + Math.max(hLRR, hR);
        nL.height = hLRepl = 1 + Math.max(hLL, hLRL);
        nLR.height = 1 + Math.max(hLRepl, hNRepl);
        n.shrinkOVL = SnapTreeMap.endChange(nodeOVL);
        nL.shrinkOVL = SnapTreeMap.endChange(leftOVL);
        assert (Math.abs(hLL - hLRL) <= 1);
        assert (hLL != 0 && nLRL != null || nL.vOpt != null);
        int balN = hLRR - hR;
        if (balN < -1 || balN > 1) {
            return n;
        }
        if ((nLRR == null || hR == 0) && n.vOpt == null) {
            return n;
        }
        int balLR = hLRepl - hNRepl;
        if (balLR < -1 || balLR > 1) {
            return nLR;
        }
        return this.fixHeight_nl(nParent);
    }

    private Node<K, V> rotateLeftOverRight_nl(Node<K, V> nParent, Node<K, V> n, int hL, Node<K, V> nR, Node<K, V> nRL, int hRR, int hRLR) {
        int hRRepl;
        int hNRepl;
        long nodeOVL = n.shrinkOVL;
        long rightOVL = nR.shrinkOVL;
        Node nPL = nParent.left;
        Node<K, V> nRLL = nRL.unsharedLeft();
        Node<K, V> nRLR = nRL.unsharedRight();
        int hRLL = SnapTreeMap.height(nRLL);
        n.shrinkOVL = SnapTreeMap.beginChange(nodeOVL);
        nR.shrinkOVL = SnapTreeMap.beginChange(rightOVL);
        n.right = nRLL;
        if (nRLL != null) {
            nRLL.parent = n;
        }
        nR.left = nRLR;
        if (nRLR != null) {
            nRLR.parent = nR;
        }
        nRL.right = nR;
        nR.parent = nRL;
        nRL.left = n;
        n.parent = nRL;
        if (nPL == n) {
            nParent.left = nRL;
        } else {
            nParent.right = nRL;
        }
        nRL.parent = nParent;
        n.height = hNRepl = 1 + Math.max(hL, hRLL);
        nR.height = hRRepl = 1 + Math.max(hRLR, hRR);
        nRL.height = 1 + Math.max(hNRepl, hRRepl);
        n.shrinkOVL = SnapTreeMap.endChange(nodeOVL);
        nR.shrinkOVL = SnapTreeMap.endChange(rightOVL);
        assert (Math.abs(hRR - hRLR) <= 1);
        int balN = hRLL - hL;
        if (balN < -1 || balN > 1) {
            return n;
        }
        if ((nRLL == null || hL == 0) && n.vOpt == null) {
            return n;
        }
        int balRL = hRRepl - hNRepl;
        if (balRL < -1 || balRL > 1) {
            return nRL;
        }
        return this.fixHeight_nl(nParent);
    }

    @Override
    public NavigableSet<K> keySet() {
        return this.navigableKeySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return new KeySet<K>(this){

            @Override
            public Iterator<K> iterator() {
                return new KeyIter(SnapTreeMap.this);
            }
        };
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        Comparable<K> fromCmp = this.comparable(fromKey);
        if (fromCmp.compareTo(toKey) > 0) {
            throw new IllegalArgumentException();
        }
        return new SubMap(this, fromKey, fromCmp, fromInclusive, toKey, this.comparable(toKey), toInclusive, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey, boolean inclusive) {
        return new SubMap(this, null, null, false, toKey, this.comparable(toKey), inclusive, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
        return new SubMap(this, fromKey, this.comparable(fromKey), inclusive, null, null, false, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> subMap(K fromKey, K toKey) {
        return this.subMap((Object)fromKey, true, (Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> headMap(K toKey) {
        return this.headMap((Object)toKey, false);
    }

    @Override
    public ConcurrentNavigableMap<K, V> tailMap(K fromKey) {
        return this.tailMap((Object)fromKey, true);
    }

    @Override
    public ConcurrentNavigableMap<K, V> descendingMap() {
        return new SubMap(this, null, null, false, null, null, false, true);
    }

    private void writeObject(ObjectOutputStream xo) throws IOException {
        xo.defaultWriteObject();
        COWMgr h = (COWMgr)this.holderRef.clone();
        xo.writeInt(h.size());
        this.writeEntry(xo, ((RootHolder)h.frozen()).right);
    }

    private void writeEntry(ObjectOutputStream xo, Node<K, V> node) throws IOException {
        if (node != null) {
            this.writeEntry(xo, node.left);
            if (node.vOpt != null) {
                xo.writeObject(node.key);
                xo.writeObject(this.decodeNull(node.vOpt));
            }
            this.writeEntry(xo, node.right);
        }
    }

    private void readObject(ObjectInputStream xi) throws IOException, ClassNotFoundException {
        xi.defaultReadObject();
        int size = xi.readInt();
        RootHolder holder = new RootHolder();
        for (int i = 0; i < size; ++i) {
            Object k = xi.readObject();
            Object v = xi.readObject();
            this.updateUnderRoot(k, this.comparable(k), 0, null, SnapTreeMap.encodeNull(v), holder);
        }
        this.holderRef = new COWMgr(holder, size);
    }

    private static class SubMap<K, V>
    extends AbstractMap<K, V>
    implements ConcurrentNavigableMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 0L;
        private final SnapTreeMap<K, V> m;
        private final K minKey;
        private transient Comparable<? super K> minCmp;
        private final boolean minIncl;
        private final K maxKey;
        private transient Comparable<? super K> maxCmp;
        private final boolean maxIncl;
        private final boolean descending;

        private SubMap(SnapTreeMap<K, V> m, K minKey, Comparable<? super K> minCmp, boolean minIncl, K maxKey, Comparable<? super K> maxCmp, boolean maxIncl, boolean descending) {
            this.m = m;
            this.minKey = minKey;
            this.minCmp = minCmp;
            this.minIncl = minIncl;
            this.maxKey = maxKey;
            this.maxCmp = maxCmp;
            this.maxIncl = maxIncl;
            this.descending = descending;
        }

        private boolean tooLow(K key) {
            if (this.minCmp == null) {
                return false;
            }
            int c = this.minCmp.compareTo(key);
            return c > 0 || c == 0 && !this.minIncl;
        }

        private boolean tooHigh(K key) {
            if (this.maxCmp == null) {
                return false;
            }
            int c = this.maxCmp.compareTo(key);
            return c < 0 || c == 0 && !this.maxIncl;
        }

        private boolean inRange(K key) {
            return !this.tooLow(key) && !this.tooHigh(key);
        }

        private void requireInRange(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.inRange(key)) {
                throw new IllegalArgumentException();
            }
        }

        private char minDir() {
            return this.descending ? (char)'R' : 'L';
        }

        private char maxDir() {
            return this.descending ? (char)'L' : 'R';
        }

        @Override
        public boolean isEmpty() {
            return ((SnapTreeMap)this.m).boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, true, 'L') == null;
        }

        @Override
        public int size() {
            Node root = ((RootHolder)((SnapTreeMap)this.m).holderRef.frozen()).right;
            return Node.computeFrozenSize(root, this.minCmp, this.minIncl, this.maxCmp, this.maxIncl);
        }

        @Override
        public boolean containsKey(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return this.inRange(k) && this.m.containsKey(k);
        }

        @Override
        public boolean containsValue(Object value) {
            SnapTreeMap.encodeNull(value);
            return super.containsValue(value);
        }

        @Override
        public V get(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            Object k = key;
            return !this.inRange(k) ? null : (V)this.m.get(k);
        }

        @Override
        public V put(K key, V value) {
            this.requireInRange(key);
            return this.m.put(key, value);
        }

        @Override
        public V remove(Object key) {
            if (key == null) {
                throw new NullPointerException();
            }
            return !this.inRange(key) ? null : (V)this.m.remove(key);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySubSet();
        }

        @Override
        public Comparator<? super K> comparator() {
            Comparator<K> fromM = this.m.comparator();
            if (this.descending) {
                return Collections.reverseOrder(fromM);
            }
            return fromM;
        }

        @Override
        public K firstKey() {
            return (K)((SnapTreeMap)this.m).boundedExtremeKeyOrThrow(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, this.minDir());
        }

        @Override
        public K lastKey() {
            return (K)((SnapTreeMap)this.m).boundedExtremeKeyOrThrow(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, this.maxDir());
        }

        private K firstKeyOrNull() {
            return (K)((SnapTreeMap)this.m).boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, true, this.minDir());
        }

        private K lastKeyOrNull() {
            return (K)((SnapTreeMap)this.m).boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, true, this.maxDir());
        }

        private Map.Entry<K, V> firstEntryOrNull() {
            return (Map.Entry)((SnapTreeMap)this.m).boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.minDir());
        }

        private Map.Entry<K, V> lastEntryOrNull() {
            return (Map.Entry)((SnapTreeMap)this.m).boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.maxDir());
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooLow(key) : this.tooHigh(key)) {
                return null;
            }
            return ((!this.descending ? this.tooHigh(key) : this.tooLow(key)) ? this : this.subMapInRange(null, false, key, false)).lastEntryOrNull();
        }

        @Override
        public K lowerKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooLow(key) : this.tooHigh(key)) {
                return null;
            }
            return ((!this.descending ? this.tooHigh(key) : this.tooLow(key)) ? this : this.subMapInRange(null, false, key, false)).lastKeyOrNull();
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooLow(key) : this.tooHigh(key)) {
                return null;
            }
            return ((!this.descending ? this.tooHigh(key) : this.tooLow(key)) ? this : this.subMapInRange(null, false, key, true)).lastEntryOrNull();
        }

        @Override
        public K floorKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooLow(key) : this.tooHigh(key)) {
                return null;
            }
            return ((!this.descending ? this.tooHigh(key) : this.tooLow(key)) ? this : this.subMapInRange(null, false, key, true)).lastKeyOrNull();
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooHigh(key) : this.tooLow(key)) {
                return null;
            }
            return ((!this.descending ? this.tooLow(key) : this.tooHigh(key)) ? this : this.subMapInRange(key, true, null, false)).firstEntryOrNull();
        }

        @Override
        public K ceilingKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooHigh(key) : this.tooLow(key)) {
                return null;
            }
            return ((!this.descending ? this.tooLow(key) : this.tooHigh(key)) ? this : this.subMapInRange(key, true, null, false)).firstKeyOrNull();
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooHigh(key) : this.tooLow(key)) {
                return null;
            }
            return ((!this.descending ? this.tooLow(key) : this.tooHigh(key)) ? this : this.subMapInRange(key, false, null, false)).firstEntryOrNull();
        }

        @Override
        public K higherKey(K key) {
            if (key == null) {
                throw new NullPointerException();
            }
            if (!this.descending ? this.tooHigh(key) : this.tooLow(key)) {
                return null;
            }
            return ((!this.descending ? this.tooLow(key) : this.tooHigh(key)) ? this : this.subMapInRange(key, false, null, false)).firstKeyOrNull();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return (Map.Entry)((SnapTreeMap)this.m).boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.minDir());
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return (Map.Entry)((SnapTreeMap)this.m).boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.maxDir());
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            Map.Entry snapshot;
            while ((snapshot = (Map.Entry)((SnapTreeMap)this.m).boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.minDir())) != null && !this.m.remove(snapshot.getKey(), snapshot.getValue())) {
            }
            return snapshot;
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            Map.Entry snapshot;
            while ((snapshot = (Map.Entry)((SnapTreeMap)this.m).boundedExtreme(this.minCmp, this.minIncl, this.maxCmp, this.maxIncl, false, this.maxDir())) != null && !this.m.remove(snapshot.getKey(), snapshot.getValue())) {
            }
            return snapshot;
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.requireInRange(key);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.inRange(key) && this.m.remove(key, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.requireInRange(key);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.requireInRange(key);
            return this.m.replace(key, value);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            if (fromKey == null || toKey == null) {
                throw new NullPointerException();
            }
            return this.subMapImpl(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SubMap<K, V> headMap(K toKey, boolean inclusive) {
            if (toKey == null) {
                throw new NullPointerException();
            }
            return this.subMapImpl(null, false, toKey, inclusive);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey, boolean inclusive) {
            if (fromKey == null) {
                throw new NullPointerException();
            }
            return this.subMapImpl(fromKey, inclusive, null, false);
        }

        @Override
        public SubMap<K, V> subMap(K fromKey, K toKey) {
            return this.subMap((Object)fromKey, true, (Object)toKey, false);
        }

        @Override
        public SubMap<K, V> headMap(K toKey) {
            return this.headMap((Object)toKey, false);
        }

        @Override
        public SubMap<K, V> tailMap(K fromKey) {
            return this.tailMap((Object)fromKey, true);
        }

        private SubMap<K, V> subMapImpl(K fromKey, boolean fromIncl, K toKey, boolean toIncl) {
            if (fromKey != null) {
                this.requireInRange(fromKey);
            }
            if (toKey != null) {
                this.requireInRange(toKey);
            }
            return this.subMapInRange(fromKey, fromIncl, toKey, toIncl);
        }

        private SubMap<K, V> subMapInRange(K fromKey, boolean fromIncl, K toKey, boolean toIncl) {
            Comparable<K> toCmp;
            Comparable<K> fromCmp = fromKey == null ? null : this.m.comparable(fromKey);
            Comparable<K> comparable = toCmp = toKey == null ? null : this.m.comparable(toKey);
            if (fromKey != null && toKey != null) {
                int c = fromCmp.compareTo(toKey);
                if (!this.descending ? c > 0 : c < 0) {
                    throw new IllegalArgumentException();
                }
            }
            K minK = this.minKey;
            Comparable<Object> minC = this.minCmp;
            boolean minI = this.minIncl;
            K maxK = this.maxKey;
            Comparable<Object> maxC = this.maxCmp;
            boolean maxI = this.maxIncl;
            if (fromKey != null) {
                if (!this.descending) {
                    minK = fromKey;
                    minC = fromCmp;
                    minI = fromIncl;
                } else {
                    maxK = fromKey;
                    maxC = fromCmp;
                    maxI = fromIncl;
                }
            }
            if (toKey != null) {
                if (!this.descending) {
                    maxK = toKey;
                    maxC = toCmp;
                    maxI = toIncl;
                } else {
                    minK = toKey;
                    minC = toCmp;
                    minI = toIncl;
                }
            }
            return new SubMap<K, V>(this.m, minK, minC, minI, maxK, maxC, maxI, this.descending);
        }

        @Override
        public SubMap<K, V> descendingMap() {
            return new SubMap<K, V>(this.m, this.minKey, this.minCmp, this.minIncl, this.maxKey, this.maxCmp, this.maxIncl, !this.descending);
        }

        @Override
        public NavigableSet<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return new KeySet<K>(this){

                @Override
                public Iterator<K> iterator() {
                    return new KeyIter(m, minCmp, minIncl, maxCmp, maxIncl, descending);
                }
            };
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return ((SubMap)this.descendingMap()).navigableKeySet();
        }

        private void readObject(ObjectInputStream xi) throws IOException, ClassNotFoundException {
            xi.defaultReadObject();
            this.minCmp = this.minKey == null ? null : this.m.comparable(this.minKey);
            this.maxCmp = this.maxKey == null ? null : this.m.comparable(this.maxKey);
        }

        private class EntrySubSet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySubSet() {
            }

            @Override
            public int size() {
                return SubMap.this.size();
            }

            @Override
            public boolean isEmpty() {
                return SubMap.this.isEmpty();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Object k = ((Map.Entry)o).getKey();
                if (!SubMap.this.inRange(k)) {
                    return false;
                }
                Object v = ((Map.Entry)o).getValue();
                Object actualVo = SubMap.this.m.getImpl(k);
                if (actualVo == null) {
                    return false;
                }
                Object actual = SubMap.this.m.decodeNull(actualVo);
                return v == null ? actual == null : v.equals(actual);
            }

            @Override
            public boolean add(Map.Entry<K, V> e) {
                SubMap.this.requireInRange(e.getKey());
                Object v = SnapTreeMap.encodeNull(e.getValue());
                return SubMap.this.m.update(e.getKey(), 0, null, v) != v;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Object k = ((Map.Entry)o).getKey();
                Object v = ((Map.Entry)o).getValue();
                return SubMap.this.remove(k, v);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIter(SubMap.this.m, SubMap.this.minCmp, SubMap.this.minIncl, SubMap.this.maxCmp, SubMap.this.maxIncl, SubMap.this.descending);
            }
        }
    }

    private static abstract class KeySet<K>
    extends AbstractSet<K>
    implements NavigableSet<K> {
        private final ConcurrentNavigableMap<K, ?> map;

        protected KeySet(ConcurrentNavigableMap<K, ?> map) {
            this.map = map;
        }

        @Override
        public abstract Iterator<K> iterator();

        @Override
        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public boolean remove(Object o) {
            return this.map.remove(o) != null;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.map.comparator();
        }

        @Override
        public K first() {
            return this.map.firstKey();
        }

        @Override
        public K last() {
            return this.map.lastKey();
        }

        @Override
        public K lower(K k) {
            return this.map.lowerKey(k);
        }

        @Override
        public K floor(K k) {
            return this.map.floorKey(k);
        }

        @Override
        public K ceiling(K k) {
            return this.map.ceilingKey(k);
        }

        @Override
        public K higher(K k) {
            return this.map.higherKey(k);
        }

        @Override
        public K pollFirst() {
            return this.map.pollFirstEntry().getKey();
        }

        @Override
        public K pollLast() {
            return this.map.pollLastEntry().getKey();
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return this.map.descendingKeySet();
        }

        @Override
        public Iterator<K> descendingIterator() {
            return this.map.descendingKeySet().iterator();
        }

        @Override
        public NavigableSet<K> subSet(K fromElement, boolean minInclusive, K toElement, boolean maxInclusive) {
            return this.map.subMap((Object)fromElement, minInclusive, (Object)toElement, maxInclusive).keySet();
        }

        @Override
        public NavigableSet<K> headSet(K toElement, boolean inclusive) {
            return this.map.headMap((Object)toElement, inclusive).keySet();
        }

        @Override
        public NavigableSet<K> tailSet(K fromElement, boolean inclusive) {
            return this.map.tailMap((Object)fromElement, inclusive).keySet();
        }

        @Override
        public SortedSet<K> subSet(K fromElement, K toElement) {
            return this.map.subMap((Object)fromElement, (Object)toElement).keySet();
        }

        @Override
        public SortedSet<K> headSet(K toElement) {
            return this.map.headMap((Object)toElement).keySet();
        }

        @Override
        public SortedSet<K> tailSet(K fromElement) {
            return this.map.tailMap((Object)fromElement).keySet();
        }
    }

    private static class AbstractIter<K, V> {
        private final SnapTreeMap<K, V> m;
        private final boolean descending;
        private final char forward;
        private final char reverse;
        private Node<K, V>[] path;
        private int depth = 0;
        private Node<K, V> mostRecentNode;
        private final K endKey;

        AbstractIter(SnapTreeMap<K, V> m) {
            this.m = m;
            this.descending = false;
            this.forward = (char)82;
            this.reverse = (char)76;
            Node root = ((RootHolder)((SnapTreeMap)m).holderRef.frozen()).right;
            this.path = new Node[1 + SnapTreeMap.height(root)];
            this.endKey = null;
            this.pushFirst(root);
        }

        AbstractIter(SnapTreeMap<K, V> m, Comparable<? super K> minCmp, boolean minIncl, Comparable<? super K> maxCmp, boolean maxIncl, boolean descending) {
            Comparable<Object> toCmp;
            Comparable<? super K> fromCmp;
            boolean toIncl;
            this.m = m;
            this.descending = descending;
            this.forward = (char)(!descending ? 82 : 76);
            this.reverse = (char)(!descending ? 76 : 82);
            boolean fromIncl = !descending ? minIncl : maxIncl;
            boolean bl = toIncl = !descending ? maxIncl : minIncl;
            if (!descending) {
                fromCmp = minCmp;
                toCmp = maxCmp;
            } else {
                fromCmp = maxCmp;
                toCmp = minCmp;
            }
            Node root = ((RootHolder)((SnapTreeMap)m).holderRef.frozen()).right;
            if (toCmp != null) {
                this.endKey = ((SnapTreeMap)m).boundedExtreme(minCmp, minIncl, maxCmp, maxIncl, true, this.forward);
                if (this.endKey == null) {
                    return;
                }
            } else {
                this.endKey = null;
            }
            this.path = new Node[1 + SnapTreeMap.height(root)];
            if (fromCmp == null) {
                this.pushFirst(root);
            } else {
                this.pushFirst(root, fromCmp, fromIncl);
                if (this.depth > 0 && this.top().vOpt == null) {
                    this.advance();
                }
            }
        }

        private int cmp(Comparable<? super K> comparable, K key) {
            int c = comparable.compareTo(key);
            if (!this.descending) {
                return c;
            }
            return c == Integer.MIN_VALUE ? 1 : -c;
        }

        private void pushFirst(Node<K, V> node) {
            while (node != null) {
                this.path(node);
                node = node.child(this.reverse);
            }
        }

        private void path(Node<K, V> node) {
            if (this.depth == this.path.length) {
                this.path = Arrays.copyOf(this.path, this.depth + 2);
            }
            this.path[this.depth++] = node;
        }

        private void pushFirst(Node<K, V> node, Comparable<? super K> fromCmp, boolean fromIncl) {
            while (node != null) {
                int c = this.cmp(fromCmp, node.key);
                if (c > 0 || c == 0 && !fromIncl) {
                    node = node.child(this.forward);
                    continue;
                }
                this.path(node);
                if (c == 0) {
                    return;
                }
                node = node.child(this.reverse);
            }
        }

        private Node<K, V> top() {
            return this.path[this.depth - 1];
        }

        private void advance() {
            do {
                Node<K, V> t = this.top();
                if (this.endKey != null && this.endKey == t.key) {
                    this.depth = 0;
                    this.path = null;
                    return;
                }
                Node<K, V> fwd = t.child(this.forward);
                if (fwd != null) {
                    this.pushFirst(fwd);
                } else {
                    Node<K, V> popped;
                    do {
                        popped = this.path[--this.depth];
                    } while (this.depth > 0 && popped == this.top().child(this.forward));
                }
                if (this.depth != 0) continue;
                this.path = null;
                return;
            } while (this.top().vOpt == null);
        }

        public boolean hasNext() {
            return this.depth > 0;
        }

        Node<K, V> nextNode() {
            if (this.depth == 0) {
                throw new NoSuchElementException();
            }
            this.mostRecentNode = this.top();
            this.advance();
            return this.mostRecentNode;
        }

        public void remove() {
            if (this.mostRecentNode == null) {
                throw new IllegalStateException();
            }
            this.m.remove(this.mostRecentNode.key);
            this.mostRecentNode = null;
        }
    }

    private static class KeyIter<K, V>
    extends AbstractIter<K, V>
    implements Iterator<K> {
        private KeyIter(SnapTreeMap<K, V> m) {
            super(m);
        }

        private KeyIter(SnapTreeMap<K, V> m, Comparable<? super K> minCmp, boolean minIncl, Comparable<? super K> maxCmp, boolean maxIncl, boolean descending) {
            super(m, minCmp, minIncl, maxCmp, maxIncl, descending);
        }

        @Override
        public K next() {
            return this.nextNode().key;
        }
    }

    private static class EntryIter<K, V>
    extends AbstractIter<K, V>
    implements Iterator<Map.Entry<K, V>> {
        private EntryIter(SnapTreeMap<K, V> m) {
            super(m);
        }

        private EntryIter(SnapTreeMap<K, V> m, Comparable<? super K> minCmp, boolean minIncl, Comparable<? super K> maxCmp, boolean maxIncl, boolean descending) {
            super(m, minCmp, minIncl, maxCmp, maxIncl, descending);
        }

        @Override
        public Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return SnapTreeMap.this.size();
        }

        @Override
        public boolean isEmpty() {
            return SnapTreeMap.this.isEmpty();
        }

        @Override
        public void clear() {
            SnapTreeMap.this.clear();
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            Object v = ((Map.Entry)o).getValue();
            Object actualVo = SnapTreeMap.this.getImpl(k);
            if (actualVo == null) {
                return false;
            }
            Object actual = SnapTreeMap.this.decodeNull(actualVo);
            return v == null ? actual == null : v.equals(actual);
        }

        @Override
        public boolean add(Map.Entry<K, V> e) {
            Object v = SnapTreeMap.encodeNull(e.getValue());
            return SnapTreeMap.this.update(e.getKey(), 0, null, v) != v;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Object k = ((Map.Entry)o).getKey();
            Object v = ((Map.Entry)o).getValue();
            return SnapTreeMap.this.remove(k, v);
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIter(SnapTreeMap.this);
        }
    }

    private static class COWMgr<K, V>
    extends CopyOnWriteManager<RootHolder<K, V>> {
        COWMgr() {
            super(new RootHolder(), 0);
        }

        COWMgr(RootHolder<K, V> initialValue, int initialSize) {
            super(initialValue, initialSize);
        }

        @Override
        protected RootHolder<K, V> freezeAndClone(RootHolder<K, V> value) {
            Node.markShared(value.right);
            return new RootHolder<K, V>(value);
        }

        @Override
        protected RootHolder<K, V> cloneFrozen(RootHolder<K, V> frozenValue) {
            return new RootHolder<K, V>(frozenValue);
        }
    }

    private static class RootHolder<K, V>
    extends Node<K, V> {
        RootHolder() {
            super(null, 1, null, null, 0L, null, null);
        }

        RootHolder(RootHolder<K, V> snapshot) {
            super(null, 1 + snapshot.height, null, null, 0L, null, snapshot.right);
        }
    }

    protected static class Node<K, V>
    implements Map.Entry<K, V> {
        public K key;
        volatile int height;
        volatile Object vOpt;
        volatile Node<K, V> parent;
        volatile long shrinkOVL;
        volatile Node<K, V> left;
        volatile Node<K, V> right;

        Node(K key, int height, Object vOpt, Node<K, V> parent, long shrinkOVL, Node<K, V> left, Node<K, V> right) {
            this.key = key;
            this.height = height;
            this.vOpt = vOpt;
            this.parent = parent;
            this.shrinkOVL = shrinkOVL;
            this.left = left;
            this.right = right;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            Object tmp = this.vOpt;
            return (V)tmp;
        }

        @Override
        public V setValue(V v) {
            throw new UnsupportedOperationException();
        }

        Node<K, V> child(char dir) {
            return dir == 'L' ? this.left : this.right;
        }

        void setChild(char dir, Node<K, V> node) {
            if (dir == 'L') {
                this.left = node;
            } else {
                this.right = node;
            }
        }

        private static <K, V> boolean isShared(Node<K, V> node) {
            return node != null && node.parent == null;
        }

        static <K, V> Node<K, V> markShared(Node<K, V> node) {
            if (node != null) {
                node.parent = null;
            }
            return node;
        }

        private Node<K, V> lazyCopy(Node<K, V> newParent) {
            assert (Node.isShared(this));
            assert (!SnapTreeMap.isShrinkingOrUnlinked(this.shrinkOVL));
            return new Node<K, V>(this.key, this.height, this.vOpt, newParent, 0L, Node.markShared(this.left), Node.markShared(this.right));
        }

        Node<K, V> unsharedLeft() {
            Node<K, V> cl = this.left;
            if (!Node.isShared(cl)) {
                return cl;
            }
            this.lazyCopyChildren();
            return this.left;
        }

        Node<K, V> unsharedRight() {
            Node<K, V> cr = this.right;
            if (!Node.isShared(cr)) {
                return cr;
            }
            this.lazyCopyChildren();
            return this.right;
        }

        Node<K, V> unsharedChild(char dir) {
            return dir == 'L' ? this.unsharedLeft() : this.unsharedRight();
        }

        private synchronized void lazyCopyChildren() {
            Node<K, V> cr;
            Node<K, V> cl = this.left;
            if (Node.isShared(cl)) {
                this.left = super.lazyCopy(this);
            }
            if (Node.isShared(cr = this.right)) {
                this.right = super.lazyCopy(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntilShrinkCompleted(long ovl) {
            int tries;
            if (!SnapTreeMap.isShrinking(ovl)) {
                return;
            }
            for (tries = 0; tries < SpinCount; ++tries) {
                if (this.shrinkOVL == ovl) continue;
                return;
            }
            for (tries = 0; tries < YieldCount; ++tries) {
                Thread.yield();
                if (this.shrinkOVL == ovl) continue;
                return;
            }
            Node node = this;
            synchronized (node) {
            }
            assert (this.shrinkOVL != ovl);
        }

        int validatedHeight() {
            int hR;
            int hL = this.left == null ? 0 : this.left.validatedHeight();
            int n = hR = this.right == null ? 0 : this.right.validatedHeight();
            assert (Math.abs(hL - hR) <= 1);
            int h = 1 + Math.max(hL, hR);
            assert (h == this.height);
            return this.height;
        }

        static <K, V> int computeFrozenSize(Node<K, V> root, Comparable<? super K> fromCmp, boolean fromIncl, Comparable<? super K> toCmp, boolean toIncl) {
            int result = 0;
            while (root != null) {
                int c;
                if (fromCmp != null && ((c = fromCmp.compareTo(root.key)) > 0 || c == 0 && !fromIncl)) {
                    root = root.right;
                    continue;
                }
                if (toCmp != null && ((c = toCmp.compareTo(root.key)) < 0 || c == 0 && !toIncl)) {
                    root = root.left;
                    continue;
                }
                if (root.vOpt != null) {
                    ++result;
                }
                result += Node.computeFrozenSize(root.left, fromCmp, fromIncl, null, false);
                fromCmp = null;
                root = root.right;
            }
            return result;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry rhs = (Map.Entry)o;
            return Node.eq(this.key, rhs.getKey()) && Node.eq(this.getValue(), rhs.getValue());
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1.equals(o2);
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public String toString() {
            return this.key + "=" + this.getValue();
        }
    }
}

