/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteClientDisconnectedException;
import org.apache.ignite.IgniteDataStreamer;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cluster.ClusterGroup;
import org.apache.ignite.compute.ComputeTaskTimeoutException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.IgnitionEx;
import org.apache.ignite.internal.jdbc2.JdbcBlob;
import org.apache.ignite.internal.jdbc2.JdbcDatabaseMetadata;
import org.apache.ignite.internal.jdbc2.JdbcPreparedStatement;
import org.apache.ignite.internal.jdbc2.JdbcStatement;
import org.apache.ignite.internal.jdbc2.JdbcStreamedPreparedStatement;
import org.apache.ignite.internal.jdbc2.JdbcUtils;
import org.apache.ignite.internal.processors.cache.DynamicCacheDescriptor;
import org.apache.ignite.internal.processors.cache.query.IgniteQueryErrorCode;
import org.apache.ignite.internal.processors.query.GridQueryIndexing;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.resource.GridSpringResourceContext;
import org.apache.ignite.internal.util.future.GridFutureAdapter;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.apache.ignite.lang.IgniteCallable;
import org.apache.ignite.resources.IgniteInstanceResource;

public class JdbcConnection
implements Connection {
    private static final String NULL = "null";
    private static final ConcurrentMap<String, IgniteNodeFuture> NODES = new ConcurrentHashMap<String, IgniteNodeFuture>();
    private final Ignite ignite;
    private final String cfg;
    private final String cacheName;
    private String schemaName;
    private boolean closed;
    private String url;
    private UUID nodeId;
    private boolean locQry;
    private boolean collocatedQry;
    private boolean distributedJoins;
    private boolean enforceJoinOrder;
    private boolean lazy;
    private boolean txAllowed;
    private int txIsolation;
    private final boolean stream;
    private final long streamFlushTimeout;
    private final int streamNodeBufSize;
    private final int streamNodeParOps;
    private final boolean streamAllowOverwrite;
    private final boolean multipleStmts;
    private final boolean skipReducerOnUpdate;
    final Set<JdbcStatement> statements = new HashSet<JdbcStatement>();

    public JdbcConnection(String url, Properties props) throws SQLException {
        assert (url != null);
        assert (props != null);
        this.url = url;
        this.cacheName = props.getProperty("ignite.jdbc.cache");
        this.locQry = Boolean.parseBoolean(props.getProperty("ignite.jdbc.local"));
        this.collocatedQry = Boolean.parseBoolean(props.getProperty("ignite.jdbc.collocated"));
        this.distributedJoins = Boolean.parseBoolean(props.getProperty("ignite.jdbc.distributedJoins"));
        this.enforceJoinOrder = Boolean.parseBoolean(props.getProperty("ignite.jdbc.enforceJoinOrder"));
        this.lazy = Boolean.parseBoolean(props.getProperty("ignite.jdbc.lazy"));
        this.txAllowed = Boolean.parseBoolean(props.getProperty("ignite.jdbc.transactionsAllowed"));
        this.stream = Boolean.parseBoolean(props.getProperty("ignite.jdbc.streaming"));
        if (this.stream && this.cacheName == null) {
            throw new SQLException("Cache name cannot be null when streaming is enabled.", "08001");
        }
        this.streamAllowOverwrite = Boolean.parseBoolean(props.getProperty("ignite.jdbc.streamingAllowOverwrite"));
        this.streamFlushTimeout = Long.parseLong(props.getProperty("ignite.jdbc.streamingFlushFrequency", "0"));
        this.streamNodeBufSize = Integer.parseInt(props.getProperty("ignite.jdbc.streamingPerNodeBufferSize", String.valueOf(512)));
        this.streamNodeParOps = Integer.parseInt(props.getProperty("ignite.jdbc.streamingPerNodeParallelOperations", "0"));
        this.multipleStmts = Boolean.parseBoolean(props.getProperty("ignite.jdbc.multipleStatementsAllowed"));
        this.skipReducerOnUpdate = Boolean.parseBoolean(props.getProperty("ignite.jdbc.skipReducerOnUpdate"));
        String nodeIdProp = props.getProperty("ignite.jdbc.nodeId");
        if (nodeIdProp != null) {
            this.nodeId = UUID.fromString(nodeIdProp);
        }
        try {
            String cfgUrl = props.getProperty("ignite.jdbc.cfg");
            this.cfg = cfgUrl == null || cfgUrl.isEmpty() ? NULL : cfgUrl;
            this.ignite = this.getIgnite(this.cfg);
            if (!this.isValid(2)) {
                throw new SQLException("Client is invalid. Probably cache name is wrong.", "08001");
            }
            if (this.cacheName != null) {
                DynamicCacheDescriptor cacheDesc = this.ignite().context().cache().cacheDescriptor(this.cacheName);
                if (cacheDesc == null) {
                    throw IgniteQueryErrorCode.createJdbcSqlException("Cache doesn't exist: " + this.cacheName, 4006);
                }
                this.schemaName = QueryUtils.normalizeSchemaName(this.cacheName, cacheDesc.cacheConfiguration().getSqlSchema());
            } else {
                this.schemaName = "PUBLIC";
            }
        }
        catch (Exception e) {
            this.close();
            throw JdbcUtils.convertToSqlException(e, "Failed to start Ignite node. " + e.getMessage(), "08001");
        }
    }

    private Ignite getIgnite(String cfgUrl) throws IgniteCheckedException {
        while (true) {
            IgniteNodeFuture fut;
            if ((fut = (IgniteNodeFuture)NODES.get(this.cfg)) == null) {
                fut = new IgniteNodeFuture();
                IgniteNodeFuture old = NODES.putIfAbsent(this.cfg, fut);
                if (old != null) {
                    fut = old;
                } else {
                    try {
                        IgniteBiTuple<IgniteConfiguration, ? extends GridSpringResourceContext> cfgAndCtx;
                        String jdbcName = "ignite-jdbc-driver-" + UUID.randomUUID().toString();
                        if (NULL.equals(this.cfg)) {
                            URL url = U.resolveIgniteUrl("config/default-config.xml");
                            if (url != null) {
                                cfgAndCtx = this.loadConfiguration("config/default-config.xml", jdbcName);
                            } else {
                                U.warn(null, "Default Spring XML file not found (is IGNITE_HOME set?): config/default-config.xml");
                                IgniteConfiguration cfg = new IgniteConfiguration().setIgniteInstanceName(jdbcName).setClientMode(true);
                                cfgAndCtx = new IgniteBiTuple<IgniteConfiguration, Object>(cfg, null);
                            }
                        } else {
                            cfgAndCtx = this.loadConfiguration(cfgUrl, jdbcName);
                        }
                        fut.onDone(IgnitionEx.start(cfgAndCtx.get1(), cfgAndCtx.get2()));
                    }
                    catch (IgniteException e) {
                        fut.onDone(e);
                    }
                    return (Ignite)fut.get();
                }
            }
            if (fut.acquire()) {
                return (Ignite)fut.get();
            }
            NODES.remove(this.cfg, fut);
        }
    }

    private IgniteBiTuple<IgniteConfiguration, ? extends GridSpringResourceContext> loadConfiguration(String cfgUrl, String jdbcName) {
        try {
            IgniteBiTuple<Collection<IgniteConfiguration>, ? extends GridSpringResourceContext> cfgMap = IgnitionEx.loadConfigurations(cfgUrl);
            IgniteConfiguration cfg = (IgniteConfiguration)F.first((Iterable)cfgMap.get1());
            if (cfg.getIgniteInstanceName() == null) {
                cfg.setIgniteInstanceName(jdbcName);
            } else {
                cfg.setIgniteInstanceName(cfg.getIgniteInstanceName() + "-" + jdbcName);
            }
            cfg.setClientMode(true);
            return new IgniteBiTuple<IgniteConfiguration, GridSpringResourceContext>(cfg, cfgMap.getValue());
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException(e);
        }
    }

    @Override
    public Statement createStatement() throws SQLException {
        return this.createStatement(1003, 1007, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.ensureNotClosed();
        return this.prepareStatement(sql, 1003, 1007, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.ensureNotClosed();
        return sql;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.ensureNotClosed();
        if (!this.txAllowed && !autoCommit) {
            throw new SQLFeatureNotSupportedException("Transactions are not supported.");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.ensureNotClosed();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.ensureNotClosed();
        if (!this.txAllowed) {
            throw new SQLFeatureNotSupportedException("Transactions are not supported.");
        }
    }

    @Override
    public void rollback() throws SQLException {
        this.ensureNotClosed();
        if (!this.txAllowed) {
            throw new SQLFeatureNotSupportedException("Transactions are not supported.");
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        Iterator<JdbcStatement> it = this.statements.iterator();
        while (it.hasNext()) {
            JdbcStatement stmt = it.next();
            stmt.closeInternal();
            it.remove();
        }
        IgniteNodeFuture fut = (IgniteNodeFuture)NODES.get(this.cfg);
        if (fut != null && fut.release()) {
            NODES.remove(this.cfg);
            if (this.ignite != null) {
                this.ignite.close();
            }
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.ensureNotClosed();
        return new JdbcDatabaseMetadata(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.ensureNotClosed();
        if (!readOnly) {
            throw new SQLFeatureNotSupportedException("Updates are not supported.");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.ensureNotClosed();
        return true;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Catalogs are not supported.");
    }

    @Override
    public String getCatalog() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.ensureNotClosed();
        if (!this.txAllowed) {
            throw new SQLFeatureNotSupportedException("Transactions are not supported.");
        }
        this.txIsolation = level;
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.ensureNotClosed();
        if (this.txAllowed) {
            return this.txIsolation;
        }
        throw new SQLFeatureNotSupportedException("Transactions are not supported.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.ensureNotClosed();
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency) throws SQLException {
        return this.createStatement(resSetType, resSetConcurrency, 1);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        return this.prepareStatement(sql, resSetType, resSetConcurrency, 1);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Types mapping is not supported.");
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        this.ensureNotClosed();
        if (!this.txAllowed && holdability != 1) {
            throw new SQLFeatureNotSupportedException("Invalid holdability (transactions are not supported).");
        }
    }

    @Override
    public int getHoldability() throws SQLException {
        this.ensureNotClosed();
        return 1;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Savepoints are not supported.");
    }

    @Override
    public Statement createStatement(int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Invalid result set type (only forward is supported.)");
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Invalid concurrency (updates are not supported).");
        }
        if (!this.txAllowed && resSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("Invalid holdability (transactions are not supported).");
        }
        JdbcStatement stmt = new JdbcStatement(this);
        this.statements.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        JdbcPreparedStatement stmt;
        this.ensureNotClosed();
        if (resSetType != 1003) {
            throw new SQLFeatureNotSupportedException("Invalid result set type (only forward is supported.)");
        }
        if (resSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Invalid concurrency (updates are not supported).");
        }
        if (!this.txAllowed && resSetHoldability != 1) {
            throw new SQLFeatureNotSupportedException("Invalid holdability (transactions are not supported).");
        }
        if (!this.stream) {
            stmt = new JdbcPreparedStatement(this, sql);
        } else {
            GridQueryIndexing idx = this.ignite().context().query().getIndexing();
            PreparedStatement nativeStmt = this.prepareNativeStatement(sql);
            try {
                idx.checkStatementStreamable(nativeStmt);
            }
            catch (IgniteSQLException e) {
                throw e.toJdbcException();
            }
            IgniteDataStreamer streamer = this.ignite().dataStreamer(this.cacheName);
            streamer.autoFlushFrequency(this.streamFlushTimeout);
            streamer.allowOverwrite(this.streamAllowOverwrite);
            if (this.streamNodeBufSize > 0) {
                streamer.perNodeBufferSize(this.streamNodeBufSize);
            }
            if (this.streamNodeParOps > 0) {
                streamer.perNodeParallelOperations(this.streamNodeParOps);
            }
            stmt = new JdbcStreamedPreparedStatement(this, sql, streamer, nativeStmt);
        }
        this.statements.add(stmt);
        return stmt;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resSetType, int resSetConcurrency, int resSetHoldability) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Callable functions are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] colIndexes) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] colNames) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("Updates are not supported.");
    }

    @Override
    public Clob createClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Blob createBlob() throws SQLException {
        this.ensureNotClosed();
        return new JdbcBlob(new byte[0]);
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.ensureNotClosed();
        if (timeout < 0) {
            throw new SQLException("Invalid timeout: " + timeout);
        }
        try {
            JdbcConnectionValidationTask task = new JdbcConnectionValidationTask(this.cacheName, this.nodeId == null ? this.ignite : null);
            if (this.nodeId != null) {
                ClusterGroup grp = this.ignite.cluster().forServers().forNodeId(this.nodeId, new UUID[0]);
                if (grp.nodes().isEmpty()) {
                    throw new SQLException("Failed to establish connection with node (is it a server node?): " + this.nodeId);
                }
                assert (grp.nodes().size() == 1);
                if (grp.node().isDaemon()) {
                    throw new SQLException("Failed to establish connection with node (is it a server node?): " + this.nodeId);
                }
                return this.ignite.compute(grp).callAsync(task).get(timeout, TimeUnit.SECONDS);
            }
            return task.call();
        }
        catch (IgniteClientDisconnectedException | ComputeTaskTimeoutException e) {
            throw new SQLException("Failed to establish connection.", "08006", e);
        }
        catch (IgniteException ignored) {
            return false;
        }
    }

    @Override
    public void setClientInfo(String name, String val) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Client info is not supported.");
    }

    @Override
    public void setClientInfo(Properties props) throws SQLClientInfoException {
        throw new UnsupportedOperationException("Client info is not supported.");
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.ensureNotClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.ensureNotClosed();
        return new Properties();
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attrs) throws SQLException {
        this.ensureNotClosed();
        throw new SQLFeatureNotSupportedException("SQL-specific types are not supported.");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (!this.isWrapperFor(iface)) {
            throw new SQLException("Connection is not a wrapper for " + iface.getName());
        }
        return (T)this;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface != null && iface == Connection.class;
    }

    @Override
    public void setSchema(String schemaName) throws SQLException {
        this.schemaName = schemaName;
    }

    @Override
    public String getSchema() throws SQLException {
        return this.schemaName;
    }

    public String schemaName() {
        return F.isEmpty(this.schemaName) ? "PUBLIC" : this.schemaName;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int ms) throws SQLException {
        throw new SQLFeatureNotSupportedException("Network timeout is not supported.");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Network timeout is not supported.");
    }

    IgniteKernal ignite() {
        return (IgniteKernal)this.ignite;
    }

    String cacheName() {
        return this.cacheName;
    }

    String url() {
        return this.url;
    }

    UUID nodeId() {
        return this.nodeId;
    }

    boolean isDmlSupported() {
        return this.ignite.version().greaterThanEqual(1, 8, 0);
    }

    boolean isMultipleStatementsAllowed() {
        return this.multipleStmts;
    }

    boolean skipReducerOnUpdate() {
        return this.skipReducerOnUpdate;
    }

    boolean isLocalQuery() {
        return this.locQry;
    }

    boolean isCollocatedQuery() {
        return this.collocatedQry;
    }

    boolean isDistributedJoins() {
        return this.distributedJoins;
    }

    boolean isEnforceJoinOrder() {
        return this.enforceJoinOrder;
    }

    boolean isLazy() {
        return this.lazy;
    }

    private void ensureNotClosed() throws SQLException {
        if (this.closed) {
            throw new SQLException("Connection is closed.", "08003");
        }
    }

    JdbcStatement createStatement0() throws SQLException {
        return (JdbcStatement)this.createStatement();
    }

    PreparedStatement prepareNativeStatement(String sql) throws SQLException {
        return this.ignite().context().query().prepareNativeStatement(this.schemaName(), sql);
    }

    private static class IgniteNodeFuture
    extends GridFutureAdapter<Ignite> {
        private final AtomicInteger refCnt = new AtomicInteger(1);

        private IgniteNodeFuture() {
        }

        public boolean acquire() {
            int cur;
            do {
                if ((cur = this.refCnt.get()) != 0) continue;
                return false;
            } while (!this.refCnt.compareAndSet(cur, cur + 1));
            return true;
        }

        public boolean release() {
            int cur;
            do {
                cur = this.refCnt.get();
                assert (cur > 0);
            } while (!this.refCnt.compareAndSet(cur, cur - 1));
            return cur == 1;
        }
    }

    private static class JdbcConnectionValidationTask
    implements IgniteCallable<Boolean> {
        private static final long serialVersionUID = 0L;
        private final String cacheName;
        @IgniteInstanceResource
        private Ignite ignite;

        public JdbcConnectionValidationTask(String cacheName, Ignite ignite) {
            this.cacheName = cacheName;
            this.ignite = ignite;
        }

        @Override
        public Boolean call() {
            return this.cacheName == null || this.ignite.cache(this.cacheName) != null;
        }
    }
}

