/*
 * Decompiled with CFR 0.152.
 */
package com.sagacloud.util.split;

import com.sagacloud.util.compute_engine.util.ConstantCE;
import com.sagacloud.util.compute_engine.util.DoubleTimeObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class ArrangeUtil {
    private static ArrangeUtil instance = new ArrangeUtil();

    public static ArrangeUtil Instance() {
        return instance;
    }

    private ArrangeUtil() {
    }

    public void Filter_monotony(List<DoubleTimeObject> recordDataList, List<DoubleTimeObject> badDataList) {
        ArrayList<Integer> badIndexList = new ArrayList<Integer>();
        for (int index = 1; index < recordDataList.size(); ++index) {
            DoubleTimeObject recordData = recordDataList.get(index);
            DoubleTimeObject recordDataLast = recordDataList.get(index - 1);
            if (!(Math.abs(recordData.data_value) < Math.abs(recordDataLast.data_value))) continue;
            badIndexList.add(index);
        }
        for (int i = badIndexList.size() - 1; i >= 0; --i) {
            int badIndex = (Integer)badIndexList.get(i);
            if (badIndex >= recordDataList.size()) continue;
            int[][] offsetArrayArray = new int[][]{{1, 0}, {0, 1}, {1, 1}, {2, 0}, {0, 2}};
            boolean match_find = false;
            for (int ii = 0; ii < offsetArrayArray.length; ++ii) {
                int iii;
                int[] offsetArray = offsetArrayArray[ii];
                int left_start = badIndex - 1 - offsetArray[0];
                int right_start = badIndex + offsetArray[1];
                int[] ttt = new int[]{left_start - 3, left_start - 2, left_start - 1, left_start, right_start, right_start + 1, right_start + 2, right_start + 3};
                boolean match = true;
                int cmp_count = 0;
                for (iii = 1; iii < ttt.length; ++iii) {
                    if (ttt[iii - 1] < 0 || ttt[iii] >= recordDataList.size()) continue;
                    DoubleTimeObject recordData = recordDataList.get(ttt[iii]);
                    DoubleTimeObject recordDataLast = recordDataList.get(ttt[iii - 1]);
                    if (Math.abs(recordData.data_value) < Math.abs(recordDataLast.data_value)) {
                        match = false;
                        break;
                    }
                    ++cmp_count;
                }
                if (!match || cmp_count <= 2) continue;
                for (iii = right_start - 1; iii >= left_start + 1; --iii) {
                    DoubleTimeObject data = recordDataList.remove(iii);
                    badDataList.add(data);
                }
                match_find = true;
                break;
            }
            if (match_find) continue;
        }
    }

    public void FilterMaxMin(long FunctionId, List<DoubleTimeObject> recordDataList, List<DoubleTimeObject> badDataList) {
        int index;
        if (!ConstantCE.OriginalDataFilterMaxMap.containsKey(FunctionId) && !ConstantCE.OriginalDataFilterMinMap.containsKey(FunctionId)) {
            return;
        }
        ArrayList<Integer> badIndexList = new ArrayList<Integer>();
        for (index = 0; index < recordDataList.size(); ++index) {
            DoubleTimeObject recordData = recordDataList.get(index);
            boolean bad = false;
            if (recordData.data_value == null) {
                bad = true;
            } else {
                if (ConstantCE.OriginalDataFilterMaxMap.containsKey(FunctionId)) {
                    double max = ConstantCE.OriginalDataFilterMaxMap.get(FunctionId);
                    if (recordData.data_value > max) {
                        bad = true;
                    }
                }
                if (ConstantCE.OriginalDataFilterMinMap.containsKey(FunctionId)) {
                    double min = ConstantCE.OriginalDataFilterMinMap.get(FunctionId);
                    if (recordData.data_value < min) {
                        bad = true;
                    }
                }
                if (ConstantCE.OriginalDataFilterValuesMap.containsKey(FunctionId)) {
                    List<Double> bad_values = ConstantCE.OriginalDataFilterValuesMap.get(FunctionId);
                    for (Double value : bad_values) {
                        if (value != recordData.data_value) continue;
                        bad = true;
                        break;
                    }
                }
            }
            if (!bad) continue;
            badIndexList.add(index);
        }
        for (index = badIndexList.size() - 1; index >= 0; --index) {
            int badIndex = (Integer)badIndexList.get(index);
            DoubleTimeObject badData = recordDataList.remove(badIndex);
            badDataList.add(badData);
        }
    }

    public List<DoubleTimeObject> ComputeInterval(long funcid, String data_type, List<DoubleTimeObject> recordDataList, List<DoubleTimeObject> badDataList, Date timeFrom, Date timeTo, long millisecondsInterval) throws Exception {
        boolean fjd_interpolate = true;
        if (data_type.equals("Acc")) {
            fjd_interpolate = true;
        } else if (data_type.equals("Inst")) {
            fjd_interpolate = ConstantCE.Inst_fjd_interpolate;
        }
        for (int index_remove = recordDataList.size() - 1; index_remove >= 0; --index_remove) {
            DoubleTimeObject recordData = recordDataList.get(index_remove);
            if (recordData.data_value != null) continue;
            badDataList.add(recordData);
            recordDataList.remove(index_remove);
        }
        this.FilterMaxMin(funcid, recordDataList, badDataList);
        if (data_type.equals("Acc")) {
            this.Filter_monotony(recordDataList, badDataList);
        }
        ArrayList<DoubleTimeObject> result = new ArrayList<DoubleTimeObject>();
        int tmpIndex = 0;
        Date tmpDate = timeFrom;
        while (tmpDate.compareTo(timeTo) <= 0) {
            DoubleTimeObject before = null;
            DoubleTimeObject after = null;
            DoubleTimeObject middle = null;
            for (int indexList = tmpIndex; indexList < recordDataList.size(); ++indexList) {
                DoubleTimeObject recordData = recordDataList.get(indexList);
                long span = recordData.data_time.getTime() - tmpDate.getTime();
                if (span < 0L) {
                    tmpIndex = indexList;
                }
                if (span > -millisecondsInterval && span < 0L) {
                    before = recordData;
                    continue;
                }
                if (span == 0L) {
                    middle = recordData;
                    continue;
                }
                if (span <= 0L) continue;
                if (span >= millisecondsInterval) break;
                after = recordData;
                break;
            }
            DoubleTimeObject intervalData = null;
            if (!fjd_interpolate) {
                if (middle != null) {
                    intervalData = new DoubleTimeObject(tmpDate, 0.0);
                    intervalData.data_value = middle.data_value;
                } else if (before != null && after != null) {
                    if (tmpDate.getTime() - before.data_time.getTime() <= after.data_time.getTime() - tmpDate.getTime()) {
                        intervalData = new DoubleTimeObject(tmpDate, 0.0);
                        intervalData.data_value = before.data_value;
                    } else {
                        intervalData = new DoubleTimeObject(tmpDate, 0.0);
                        intervalData.data_value = after.data_value;
                    }
                } else if (before != null && (tmpDate.getTime() - before.data_time.getTime()) * 3L <= millisecondsInterval) {
                    intervalData = new DoubleTimeObject(tmpDate, 0.0);
                    intervalData.data_value = before.data_value;
                } else if (after != null && (after.data_time.getTime() - tmpDate.getTime()) * 3L <= millisecondsInterval) {
                    intervalData = new DoubleTimeObject(tmpDate, 0.0);
                    intervalData.data_value = after.data_value;
                }
            } else if (middle != null) {
                intervalData = new DoubleTimeObject(tmpDate, 0.0);
                intervalData.data_value = middle.data_value;
            } else if (before != null && after != null) {
                intervalData = new DoubleTimeObject(tmpDate, 0.0);
                intervalData.data_value = before.data_value + (after.data_value - before.data_value) * (double)(tmpDate.getTime() - before.data_time.getTime()) / (double)(after.data_time.getTime() - before.data_time.getTime());
            } else if (before != null && (tmpDate.getTime() - before.data_time.getTime()) * 3L <= millisecondsInterval) {
                intervalData = new DoubleTimeObject(tmpDate, 0.0);
                intervalData.data_value = before.data_value;
            } else if (after != null && (after.data_time.getTime() - tmpDate.getTime()) * 3L <= millisecondsInterval) {
                intervalData = new DoubleTimeObject(tmpDate, 0.0);
                intervalData.data_value = after.data_value;
            }
            if (intervalData != null) {
                result.add(intervalData);
            }
            tmpDate = new Date(tmpDate.getTime() + millisecondsInterval);
        }
        return result;
    }
}

