/*
 * Decompiled with CFR 0.152.
 */
package org.zillion.util.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import java.util.zip.Deflater;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.Inflater;

public class CompressUtil {
    public static String algo = "gzip";
    public static int deflate_level = 1;

    public static byte[] compress(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length == 0) {
            return bytes;
        }
        if (algo.equals("gzip")) {
            return CompressUtil.gzip_compress(bytes);
        }
        if (algo.equals("deflate")) {
            return CompressUtil.deflate_compress(bytes, deflate_level);
        }
        return null;
    }

    public static byte[] decompress(byte[] encrypted) throws IOException {
        if (encrypted == null || encrypted.length == 0) {
            return encrypted;
        }
        if (algo.equals("gzip")) {
            return CompressUtil.gzip_decompress(encrypted);
        }
        if (algo.equals("deflate")) {
            return CompressUtil.deflate_decompress(encrypted);
        }
        return null;
    }

    private static byte[] gzip_compress(byte[] bytes) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            gzip.write(bytes);
            gzip.close();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static byte[] gzip_decompress(byte[] encrypted) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(encrypted);
        try {
            int n;
            GZIPInputStream gunzip = new GZIPInputStream(in);
            byte[] buffer = new byte[1024];
            while ((n = gunzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static byte[] deflate_compress(byte[] data, int level) {
        Deflater compresser;
        byte[] output;
        block12: {
            output = new byte[]{};
            compresser = new Deflater(level);
            compresser.reset();
            compresser.setInput(data);
            compresser.finish();
            ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
            try {
                try {
                    byte[] buf = new byte[1024];
                    while (!compresser.finished()) {
                        int i = compresser.deflate(buf);
                        bos.write(buf, 0, i);
                    }
                    output = bos.toByteArray();
                }
                catch (Exception e) {
                    output = data;
                    e.printStackTrace();
                    try {
                        bos.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                bos.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        compresser.end();
        return output;
    }

    private static byte[] deflate_decompress(byte[] data) {
        Inflater decompresser;
        byte[] output;
        block12: {
            output = new byte[]{};
            decompresser = new Inflater();
            decompresser.reset();
            decompresser.setInput(data);
            ByteArrayOutputStream o = new ByteArrayOutputStream(data.length);
            try {
                try {
                    byte[] buf = new byte[1024];
                    while (!decompresser.finished()) {
                        int i = decompresser.inflate(buf);
                        o.write(buf, 0, i);
                    }
                    output = o.toByteArray();
                }
                catch (Exception e) {
                    output = data;
                    e.printStackTrace();
                    try {
                        o.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break block12;
                }
            }
            catch (Throwable throwable) {
                try {
                    o.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                throw throwable;
            }
            try {
                o.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        decompresser.end();
        return output;
    }

    public static byte[] encode(byte[] bytes, Byte[] forbid_bytes) throws IOException {
        byte tmp;
        Byte n1 = null;
        Byte n2 = null;
        int i = -128;
        while (i < 128) {
            tmp = (byte)i;
            boolean exist = false;
            Byte[] byteArray = forbid_bytes;
            int n = forbid_bytes.length;
            int n3 = 0;
            while (n3 < n) {
                byte tmp2 = byteArray[n3];
                if (tmp2 == tmp) {
                    exist = true;
                    break;
                }
                ++n3;
            }
            if (!exist) {
                if (n1 == null) {
                    n1 = tmp;
                } else if (n2 == null) {
                    n2 = tmp;
                    break;
                }
            }
            ++i;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            byte[] byArray = bytes;
            int n = bytes.length;
            int n4 = 0;
            while (n4 < n) {
                tmp = byArray[n4];
                if (tmp == n1) {
                    out.write(n1.byteValue());
                    out.write(n2.byteValue());
                } else {
                    int index = -1;
                    int i2 = 0;
                    while (i2 < forbid_bytes.length) {
                        if (forbid_bytes[i2] == tmp) {
                            index = i2;
                            break;
                        }
                        ++i2;
                    }
                    if (index == -1) {
                        out.write(tmp);
                    } else {
                        i2 = 0;
                        while (i2 < index + 2) {
                            out.write(n1.byteValue());
                            ++i2;
                        }
                        out.write(n2.byteValue());
                    }
                }
                ++n4;
            }
            byte[] byArray2 = out.toByteArray();
            return byArray2;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static byte[] decode(byte[] encrypted, Byte[] forbid_bytes) throws Exception {
        Object[] objectArray;
        Byte n1 = null;
        Byte n2 = null;
        int i = -128;
        while (i < 128) {
            byte tmp = (byte)i;
            boolean exist = false;
            objectArray = forbid_bytes;
            int n = forbid_bytes.length;
            int n3 = 0;
            while (n3 < n) {
                byte tmp2 = objectArray[n3];
                if (tmp2 == tmp) {
                    exist = true;
                    break;
                }
                ++n3;
            }
            if (!exist) {
                if (n1 == null) {
                    n1 = tmp;
                } else if (n2 == null) {
                    n2 = tmp;
                    break;
                }
            }
            ++i;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int index = 0;
            while (index < encrypted.length) {
                byte tmp = encrypted[index];
                if (tmp == n1) {
                    int index_n2 = -1;
                    int i2 = index + 1;
                    while (i2 < encrypted.length) {
                        if (encrypted[i2] == n2) {
                            index_n2 = i2;
                            break;
                        }
                        ++i2;
                    }
                    if (index_n2 == -1) {
                        throw new Exception();
                    }
                    int n1_count = index_n2 - index;
                    if (n1_count == 1) {
                        out.write(n1.byteValue());
                    } else {
                        out.write(forbid_bytes[n1_count - 2].byteValue());
                    }
                    index = index_n2 + 1;
                    continue;
                }
                out.write(tmp);
                ++index;
            }
            objectArray = out.toByteArray();
            return objectArray;
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Byte[] forbid_bytes = new Byte[]{(byte)0, (byte)1};
        String a = "1101070037;1;report;20160101000000;123456;1000;1;101;33.440&1101070037;1;report;20160101000001;123456;1001;1;101;33.441&1101070037;1;report;20160101000002;123456;1002;1;101;33.442&1101070037;1;report;20160101000003;123456;1003;1;101;33.443&1101070037;1;report;20160101000004;123456;1004;1;101;33.444&1101070037;1;report;20160101000005;123456;1005;1;101;33.445&1101070037;1;report;20160101000006;123456;1006;1;101;33.446&1101070037;1;report;20160101000007;123456;1007;1;101;33.447&1101070037;1;report;20160101000008;123456;1008;1;101;33.448&1101070037;1;report;20160101000009;123456;1009;1;101;33.449&1101070037;1;report;20160101000010;123456;1000;1;101;33.4400&1101070037;1;report;20160101000011;123456;1001;1;101;33.4411&1101070037;1;report;20160101000012;123456;1002;1;101;33.4422&1101070037;1;report;20160101000013;123456;1003;1;101;33.4433&1101070037;1;report;20160101000014;123456;1004;1;101;33.4444&1101070037;1;report;20160101000015;123456;1005;1;101;33.4455&1101070037;1;report;20160101000016;123456;1006;1;101;33.4466&1101070037;1;report;20160101000017;123456;1007;1;101;33.4477&1101070037;1;report;20160101000018;123456;1008;1;101;33.4488&1101070037;1;report;20160101000019;123456;1009;1;101;33.4499";
        int i = 0;
        while (i < 11) {
            byte[] ab = a.getBytes();
            byte[] e = CompressUtil.compress(ab);
            byte[] ee = CompressUtil.encode(e, forbid_bytes);
            byte[] ed = CompressUtil.decode(ee, forbid_bytes);
            byte[] d = CompressUtil.decompress(ed);
            System.out.println(new String(d));
            System.out.println(String.valueOf(ab.length) + "\t" + ee.length);
            a = a.substring(1);
            ++i;
        }
        byte[][] ori_bytes_array = new byte[100][];
        int ori_bytes_length = 0;
        byte[][] zip_bytes_array = new byte[ori_bytes_array.length][];
        int zip_bytes_length = 0;
        byte[][] result_bytes_array = new byte[ori_bytes_array.length][];
        int i2 = 0;
        while (i2 < ori_bytes_array.length) {
            StringBuffer sb = new StringBuffer();
            Random rand = new Random();
            int ii = 0;
            while (ii < 1000000) {
                char c = (char)(97 + rand.nextInt(26));
                sb.append(c);
                ++ii;
            }
            ori_bytes_array[i2] = sb.toString().getBytes();
            ori_bytes_length += ori_bytes_array[i2].length;
            ++i2;
        }
        zip_bytes_length = 0;
        long t1 = new Date().getTime();
        int i3 = 0;
        while (i3 < ori_bytes_array.length) {
            zip_bytes_array[i3] = CompressUtil.gzip_compress(ori_bytes_array[i3]);
            zip_bytes_length += zip_bytes_array[i3].length;
            ++i3;
        }
        long t2 = new Date().getTime();
        int i4 = 0;
        while (i4 < ori_bytes_array.length) {
            result_bytes_array[i4] = CompressUtil.gzip_decompress(zip_bytes_array[i4]);
            ++i4;
        }
        long t3 = new Date().getTime();
        System.out.println("gzip:" + 1.0 * (double)zip_bytes_length / (double)ori_bytes_length + "\t" + (t2 - t1) + "\t" + (t3 - t2));
        int level = 1;
        while (level <= 9) {
            zip_bytes_length = 0;
            long t12 = new Date().getTime();
            int i5 = 0;
            while (i5 < ori_bytes_array.length) {
                zip_bytes_array[i5] = CompressUtil.deflate_compress(ori_bytes_array[i5], level);
                zip_bytes_length += zip_bytes_array[i5].length;
                ++i5;
            }
            long t22 = new Date().getTime();
            int i6 = 0;
            while (i6 < ori_bytes_array.length) {
                result_bytes_array[i6] = CompressUtil.deflate_decompress(zip_bytes_array[i6]);
                ++i6;
            }
            long t32 = new Date().getTime();
            System.out.println("deflate " + level + ":" + 1.0 * (double)zip_bytes_length / (double)ori_bytes_length + "\t" + (t22 - t12) + "\t" + (t32 - t22));
            ++level;
        }
    }
}

