/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.ignite.Ignite;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.events.DiscoveryEvent;
import org.apache.ignite.events.Event;
import org.apache.ignite.internal.IgniteKernal;
import org.apache.ignite.internal.managers.communication.GridMessageListener;
import org.apache.ignite.internal.managers.eventstorage.GridLocalEventListener;
import org.apache.ignite.internal.processors.timeout.GridSpiTimeoutObject;
import org.apache.ignite.internal.util.IgniteExceptionRegistry;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.CU;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiPredicate;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageFactory;
import org.apache.ignite.plugin.extensions.communication.MessageFormatter;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.apache.ignite.plugin.security.SecuritySubject;
import org.apache.ignite.resources.IgniteInstanceResource;
import org.apache.ignite.resources.LoggerResource;
import org.apache.ignite.spi.IgniteNodeValidationResult;
import org.apache.ignite.spi.IgnitePortProtocol;
import org.apache.ignite.spi.IgniteSpi;
import org.apache.ignite.spi.IgniteSpiConfiguration;
import org.apache.ignite.spi.IgniteSpiConsistencyChecked;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiManagementMBean;
import org.apache.ignite.spi.IgniteSpiTimeoutObject;
import org.apache.ignite.spi.discovery.DiscoveryDataBag;
import org.jetbrains.annotations.Nullable;

public abstract class IgniteSpiAdapter
implements IgniteSpi {
    private ObjectName spiMBean;
    private long startTstamp;
    @LoggerResource
    private IgniteLogger log;
    protected Ignite ignite;
    protected String igniteInstanceName;
    private String name;
    private volatile IgniteSpiContext spiCtx = new GridDummySpiContext(null, false, null);
    private GridLocalEventListener paramsLsnr;
    private ClusterNode locNode;
    private boolean failureDetectionTimeoutEnabled = true;
    private long clientFailureDetectionTimeout;
    private long failureDetectionTimeout;
    private final AtomicBoolean startedFlag = new AtomicBoolean();

    protected IgniteSpiAdapter() {
        this.name = U.getSimpleName(this.getClass());
    }

    protected void startStopwatch() {
        this.startTstamp = U.currentTimeMillis();
    }

    public final void onBeforeStart() {
        if (!this.startedFlag.compareAndSet(false, true)) {
            throw new IllegalStateException("SPI has already been started (always create new configuration instance for each starting Ignite instances) [spi=" + this + ']');
        }
    }

    public final boolean started() {
        return this.startedFlag.get();
    }

    protected ClusterNode getLocalNode() {
        if (this.locNode != null) {
            return this.locNode;
        }
        this.locNode = this.getSpiContext().localNode();
        return this.locNode;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Ignite ignite() {
        return this.ignite;
    }

    @IgniteSpiConfiguration(optional=true)
    public IgniteSpiAdapter setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public final void onContextInitialized(final IgniteSpiContext spiCtx) throws IgniteSpiException {
        assert (spiCtx != null);
        this.spiCtx = spiCtx;
        if (!Boolean.getBoolean("IGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK")) {
            this.paramsLsnr = new GridLocalEventListener(){

                @Override
                public void onEvent(Event evt) {
                    assert (evt instanceof DiscoveryEvent) : "Invalid event [expected=10, actual=" + evt.type() + ", evt=" + evt + ']';
                    ClusterNode node = spiCtx.node(((DiscoveryEvent)evt).eventNode().id());
                    if (node != null) {
                        try {
                            IgniteSpiAdapter.this.checkConfigurationConsistency(spiCtx, node, false);
                            IgniteSpiAdapter.this.checkConfigurationConsistency0(spiCtx, node, false);
                        }
                        catch (IgniteSpiException e) {
                            U.error(IgniteSpiAdapter.this.log, "Spi consistency check failed [node=" + node.id() + ", spi=" + IgniteSpiAdapter.this.getName() + ']', e);
                        }
                    }
                }
            };
            spiCtx.addLocalEventListener(this.paramsLsnr, 10);
            Collection<ClusterNode> remotes = F.concat(false, spiCtx.remoteNodes(), spiCtx.remoteDaemonNodes());
            for (ClusterNode node : remotes) {
                this.checkConfigurationConsistency(spiCtx, node, true);
                this.checkConfigurationConsistency0(spiCtx, node, true);
            }
        }
        this.onContextInitialized0(spiCtx);
    }

    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
    }

    @Override
    public final void onContextDestroyed() {
        this.onContextDestroyed0();
        if (this.spiCtx != null && this.paramsLsnr != null) {
            this.spiCtx.removeLocalEventListener(this.paramsLsnr);
        }
        ClusterNode locNode = this.spiCtx == null ? null : this.spiCtx.localNode();
        this.spiCtx = new GridDummySpiContext(locNode, true, this.spiCtx);
    }

    @Override
    public void onClientDisconnected(IgniteFuture<?> reconnectFut) {
    }

    @Override
    public void onClientReconnected(boolean clusterRestarted) {
    }

    @IgniteInstanceResource
    protected void injectResources(Ignite ignite) {
        this.ignite = ignite;
        if (ignite != null) {
            this.igniteInstanceName = ignite.name();
        }
    }

    protected void onContextDestroyed0() {
    }

    public Collection<Object> injectables() {
        return Collections.emptyList();
    }

    public IgniteSpiContext getSpiContext() {
        return this.spiCtx;
    }

    public IgniteExceptionRegistry getExceptionRegistry() {
        return IgniteExceptionRegistry.get();
    }

    @Override
    public Map<String, Object> getNodeAttributes() throws IgniteSpiException {
        return Collections.emptyMap();
    }

    protected final void assertParameter(boolean cond, String condDesc) throws IgniteSpiException {
        if (!cond) {
            throw new IgniteSpiException("SPI parameter failed condition check: " + condDesc);
        }
    }

    protected final String startInfo() {
        return "SPI started ok [startMs=" + this.startTstamp + ", spiMBean=" + this.spiMBean + ']';
    }

    final long getStartTstamp() {
        return this.startTstamp;
    }

    protected final String stopInfo() {
        return "SPI stopped ok.";
    }

    protected final String configInfo(String name, Object val) {
        assert (name != null);
        return "Using parameter [" + name + '=' + val + ']';
    }

    private static String format(String msg, Object locVal) {
        return msg + U.nl() + ">>> => Local node:  " + locVal + U.nl();
    }

    private static String format(String msg, Object locVal, Object rmtVal) {
        return msg + U.nl() + ">>> => Local node:  " + locVal + U.nl() + ">>> => Remote node: " + rmtVal + U.nl();
    }

    protected final <T extends IgniteSpiManagementMBean> void registerMBean(String igniteInstanceName, T impl2, Class<T> mbeanItf) throws IgniteSpiException {
        if (this.ignite == null || U.IGNITE_MBEANS_DISABLED) {
            return;
        }
        MBeanServer jmx = this.ignite.configuration().getMBeanServer();
        assert (mbeanItf == null || mbeanItf.isInterface());
        assert (jmx != null);
        try {
            this.spiMBean = U.registerMBean(jmx, igniteInstanceName, "SPIs", this.getName(), impl2, mbeanItf);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Registered SPI MBean: " + this.spiMBean);
            }
        }
        catch (JMException e) {
            throw new IgniteSpiException("Failed to register SPI MBean: " + this.spiMBean, e);
        }
    }

    protected final void unregisterMBean() throws IgniteSpiException {
        if (this.spiMBean != null && this.ignite != null) {
            assert (!U.IGNITE_MBEANS_DISABLED);
            MBeanServer jmx = this.ignite.configuration().getMBeanServer();
            assert (jmx != null);
            try {
                jmx.unregisterMBean(this.spiMBean);
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Unregistered SPI MBean: " + this.spiMBean);
                }
            }
            catch (JMException e) {
                throw new IgniteSpiException("Failed to unregister SPI MBean: " + this.spiMBean, e);
            }
        }
    }

    protected final boolean isNodeStopping() {
        return this.spiCtx.isStopping();
    }

    private boolean checkOptional() {
        IgniteSpiConsistencyChecked ann = U.getAnnotation(this.getClass(), IgniteSpiConsistencyChecked.class);
        return ann != null && ann.optional();
    }

    private boolean checkEnabled() {
        return U.getAnnotation(this.getClass(), IgniteSpiConsistencyChecked.class) != null;
    }

    private boolean checkClient() {
        IgniteSpiConsistencyChecked ann = U.getAnnotation(this.getClass(), IgniteSpiConsistencyChecked.class);
        return ann != null && ann.checkClient();
    }

    protected void checkConfigurationConsistency0(IgniteSpiContext spiCtx, ClusterNode node, boolean starting) throws IgniteSpiException {
    }

    private void checkConfigurationConsistency(IgniteSpiContext spiCtx, ClusterNode node, boolean starting) throws IgniteSpiException {
        assert (spiCtx != null);
        assert (node != null);
        boolean optional = this.checkOptional();
        boolean enabled = this.checkEnabled();
        boolean checkClient = this.checkClient();
        if (!enabled) {
            return;
        }
        if (!checkClient && (CU.clientNode(this.getLocalNode()) || CU.clientNode(node))) {
            return;
        }
        String clsAttr = this.createSpiAttributeName("org.apache.ignite.spi.class");
        String name = this.getName();
        SB sb = new SB();
        String locCls = (String)spiCtx.localNode().attribute(clsAttr);
        String rmtCls = (String)node.attribute(clsAttr);
        assert (locCls != null) : "Local SPI class name attribute not found: " + clsAttr;
        boolean isSpiConsistent = false;
        String tipStr = " (fix configuration or set -DIGNITE_SKIP_CONFIGURATION_CONSISTENCY_CHECK=true system property)";
        if (rmtCls == null) {
            if (!optional && starting) {
                throw new IgniteSpiException("Remote SPI with the same name is not configured" + tipStr + " [name=" + name + ", loc=" + locCls + ']');
            }
            sb.a(IgniteSpiAdapter.format(">>> Remote SPI with the same name is not configured: " + name, locCls));
        } else if (!locCls.equals(rmtCls)) {
            if (!optional && starting) {
                throw new IgniteSpiException("Remote SPI with the same name is of different type" + tipStr + " [name=" + name + ", loc=" + locCls + ", rmt=" + rmtCls + ']');
            }
            sb.a(IgniteSpiAdapter.format(">>> Remote SPI with the same name is of different type: " + name, locCls, rmtCls));
        } else {
            isSpiConsistent = true;
        }
        if (optional && !isSpiConsistent) {
            return;
        }
        if (isSpiConsistent) {
            List<String> attrs = this.getConsistentAttributeNames();
            for (String attr : attrs) {
                if (attr.equals(clsAttr)) continue;
                Object rmtVal = node.attribute(attr);
                Object locVal = spiCtx.localNode().attribute(attr);
                if (locVal == null && rmtVal == null || locVal != null && rmtVal != null && locVal.equals(rmtVal)) continue;
                sb.a(IgniteSpiAdapter.format(">>> Remote node has different " + this.getName() + " SPI attribute " + attr, locVal, rmtVal));
            }
        }
        if (sb.length() > 0) {
            String msg = starting ? U.nl() + U.nl() + ">>> +--------------------------------------------------------------------+" + U.nl() + ">>> + Courtesy notice that starting node has inconsistent configuration. +" + U.nl() + ">>> + Ignore this message if you are sure that this is done on purpose.  +" + U.nl() + ">>> +--------------------------------------------------------------------+" + U.nl() + ">>> Remote Node ID: " + node.id().toString().toUpperCase() + U.nl() + sb : U.nl() + U.nl() + ">>> +-------------------------------------------------------------------+" + U.nl() + ">>> + Courtesy notice that joining node has inconsistent configuration. +" + U.nl() + ">>> + Ignore this message if you are sure that this is done on purpose. +" + U.nl() + ">>> +-------------------------------------------------------------------+" + U.nl() + ">>> Remote Node ID: " + node.id().toString().toUpperCase() + U.nl() + sb;
            U.courtesy(this.log, msg);
        }
    }

    protected List<String> getConsistentAttributeNames() {
        return Collections.emptyList();
    }

    protected String createSpiAttributeName(String attrName) {
        return U.spiAttribute(this, attrName);
    }

    protected void addTimeoutObject(IgniteSpiTimeoutObject obj) {
        this.spiCtx.addTimeoutObject(obj);
    }

    protected void removeTimeoutObject(IgniteSpiTimeoutObject obj) {
        this.spiCtx.removeTimeoutObject(obj);
    }

    protected void initFailureDetectionTimeout() {
        if (this.failureDetectionTimeoutEnabled) {
            this.failureDetectionTimeout = this.ignite.configuration().getFailureDetectionTimeout();
            if (this.failureDetectionTimeout <= 0L) {
                throw new IgniteSpiException("Invalid failure detection timeout value: " + this.failureDetectionTimeout);
            }
            if (this.failureDetectionTimeout <= 10L) {
                this.log.warning("Failure detection timeout is too low, it may lead to unpredictable behaviour [failureDetectionTimeout=" + this.failureDetectionTimeout + ']');
            } else if (this.failureDetectionTimeout <= this.ignite.configuration().getMetricsUpdateFrequency()) {
                this.log.warning("'IgniteConfiguration.failureDetectionTimeout' should be greater then 'IgniteConfiguration.metricsUpdateFrequency' to prevent unnecessary status checking.");
            }
        } else if (this.ignite.configuration().getFailureDetectionTimeout() != IgniteConfiguration.DFLT_FAILURE_DETECTION_TIMEOUT) {
            this.log.warning("Failure detection timeout will be ignored (one of SPI parameters has been set explicitly)");
        }
        this.clientFailureDetectionTimeout = this.ignite.configuration().getClientFailureDetectionTimeout();
        if (this.clientFailureDetectionTimeout <= 0L) {
            throw new IgniteSpiException("Invalid client failure detection timeout value: " + this.clientFailureDetectionTimeout);
        }
        if (this.clientFailureDetectionTimeout <= 10L) {
            this.log.warning("Client failure detection timeout is too low, it may lead to unpredictable behaviour [clientFailureDetectionTimeout=" + this.clientFailureDetectionTimeout + ']');
        }
        if (this.clientFailureDetectionTimeout < this.ignite.configuration().getMetricsUpdateFrequency()) {
            throw new IgniteSpiException("Inconsistent configuration ('IgniteConfiguration.clientFailureDetectionTimeout' must be greater or equal to 'IgniteConfiguration.metricsUpdateFrequency').");
        }
    }

    public void failureDetectionTimeoutEnabled(boolean enabled) {
        this.failureDetectionTimeoutEnabled = enabled;
    }

    public boolean failureDetectionTimeoutEnabled() {
        return this.failureDetectionTimeoutEnabled;
    }

    public long clientFailureDetectionTimeout() {
        return this.clientFailureDetectionTimeout;
    }

    public long failureDetectionTimeout() {
        return this.failureDetectionTimeout;
    }

    private class GridDummySpiContext
    implements IgniteSpiContext {
        private final ClusterNode locNode;
        private final boolean stopping;
        private final MessageFactory msgFactory;
        private final MessageFormatter msgFormatter;

        GridDummySpiContext(ClusterNode locNode, @Nullable boolean stopping, IgniteSpiContext spiCtx) {
            MessageFormatter msgFormatter0;
            this.locNode = locNode;
            this.stopping = stopping;
            MessageFactory msgFactory0 = spiCtx != null ? spiCtx.messageFactory() : null;
            MessageFormatter messageFormatter = msgFormatter0 = spiCtx != null ? spiCtx.messageFormatter() : null;
            if (msgFactory0 == null) {
                msgFactory0 = new MessageFactory(){

                    @Override
                    @Nullable
                    public Message create(short type) {
                        throw new IgniteException("Failed to read message, node is not started.");
                    }
                };
            }
            if (msgFormatter0 == null) {
                msgFormatter0 = new MessageFormatter(){

                    @Override
                    public MessageWriter writer(UUID rmtNodeId) {
                        throw new IgniteException("Failed to write message, node is not started.");
                    }

                    @Override
                    public MessageReader reader(UUID rmtNodeId, MessageFactory msgFactory) {
                        throw new IgniteException("Failed to read message, node is not started.");
                    }
                };
            }
            this.msgFactory = msgFactory0;
            this.msgFormatter = msgFormatter0;
        }

        @Override
        public void addLocalEventListener(GridLocalEventListener lsnr, int ... types) {
        }

        @Override
        public void addMessageListener(GridMessageListener lsnr, String topic) {
        }

        @Override
        public void addLocalMessageListener(Object topic, IgniteBiPredicate<UUID, ?> p) {
        }

        @Override
        public void recordEvent(Event evt) {
        }

        @Override
        public void registerPort(int port, IgnitePortProtocol proto) {
        }

        @Override
        public void deregisterPort(int port, IgnitePortProtocol proto) {
        }

        @Override
        public void deregisterPorts() {
        }

        @Override
        public <K, V> V get(String cacheName, K key) {
            return null;
        }

        @Override
        public <K, V> V put(String cacheName, K key, V val, long ttl) {
            return null;
        }

        @Override
        public <K, V> V putIfAbsent(String cacheName, K key, V val, long ttl) {
            return null;
        }

        @Override
        public <K, V> V remove(String cacheName, K key) {
            return null;
        }

        @Override
        public <K> boolean containsKey(String cacheName, K key) {
            return false;
        }

        @Override
        public int partition(String cacheName, Object key) {
            return -1;
        }

        @Override
        public Collection<ClusterNode> nodes() {
            return this.locNode == null ? Collections.emptyList() : Collections.singletonList(this.locNode);
        }

        @Override
        public ClusterNode localNode() {
            return this.locNode;
        }

        @Override
        public Collection<ClusterNode> remoteDaemonNodes() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public ClusterNode node(UUID nodeId) {
            return null;
        }

        @Override
        public Collection<ClusterNode> remoteNodes() {
            return Collections.emptyList();
        }

        @Override
        public boolean pingNode(UUID nodeId) {
            return this.locNode != null && nodeId.equals(this.locNode.id());
        }

        @Override
        public boolean removeLocalEventListener(GridLocalEventListener lsnr) {
            return false;
        }

        @Override
        public boolean isEventRecordable(int ... types) {
            return true;
        }

        @Override
        public void removeLocalMessageListener(Object topic, IgniteBiPredicate<UUID, ?> p) {
        }

        @Override
        public boolean removeMessageListener(GridMessageListener lsnr, String topic) {
            return false;
        }

        @Override
        public void send(ClusterNode node, Serializable msg, String topic) {
        }

        @Override
        @Nullable
        public IgniteNodeValidationResult validateNode(ClusterNode node) {
            return null;
        }

        @Override
        @Nullable
        public IgniteNodeValidationResult validateNode(ClusterNode node, DiscoveryDataBag discoData) {
            return null;
        }

        @Override
        public Collection<SecuritySubject> authenticatedSubjects() {
            return Collections.emptyList();
        }

        @Override
        public SecuritySubject authenticatedSubject(UUID subjId) {
            return null;
        }

        @Override
        public MessageFormatter messageFormatter() {
            return this.msgFormatter;
        }

        @Override
        public MessageFactory messageFactory() {
            return this.msgFactory;
        }

        @Override
        public boolean isStopping() {
            return this.stopping;
        }

        @Override
        public boolean tryFailNode(UUID nodeId, @Nullable String warning) {
            return false;
        }

        @Override
        public void failNode(UUID nodeId, @Nullable String warning) {
        }

        @Override
        public void addTimeoutObject(IgniteSpiTimeoutObject obj) {
            Ignite ignite0 = IgniteSpiAdapter.this.ignite;
            if (!(ignite0 instanceof IgniteKernal)) {
                throw new IgniteSpiException("Wrong Ignite instance is set: " + ignite0);
            }
            ((IgniteKernal)ignite0).context().timeout().addTimeoutObject(new GridSpiTimeoutObject(obj));
        }

        @Override
        public void removeTimeoutObject(IgniteSpiTimeoutObject obj) {
            Ignite ignite0 = IgniteSpiAdapter.this.ignite;
            if (!(ignite0 instanceof IgniteKernal)) {
                throw new IgniteSpiException("Wrong Ignite instance is set: " + ignite0);
            }
            ((IgniteKernal)ignite0).context().timeout().removeTimeoutObject(new GridSpiTimeoutObject(obj));
        }

        @Override
        public Map<String, Object> nodeAttributes() {
            return Collections.emptyMap();
        }

        @Override
        public boolean communicationFailureResolveSupported() {
            return false;
        }

        @Override
        public void resolveCommunicationFailure(ClusterNode node, Exception err) {
            throw new UnsupportedOperationException();
        }
    }
}

