/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record.delta;

import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.pagemem.PageMemory;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.pagemem.wal.record.delta.PageDeltaRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.PageMetaIO;
import org.apache.ignite.internal.util.typedef.internal.S;

public class MetaPageUpdateNextSnapshotId
extends PageDeltaRecord {
    private final long nextSnapshotId;

    public MetaPageUpdateNextSnapshotId(int grpId, long pageId, long nextSnapshotId) {
        super(grpId, pageId);
        this.nextSnapshotId = nextSnapshotId;
    }

    @Override
    public void applyDelta(PageMemory pageMem, long pageAddr) throws IgniteCheckedException {
        PageMetaIO io = PageMetaIO.VERSIONS.forPage(pageAddr);
        io.setNextSnapshotTag(pageAddr, this.nextSnapshotId);
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.META_PAGE_UPDATE_NEXT_SNAPSHOT_ID;
    }

    public long nextSnapshotId() {
        return this.nextSnapshotId;
    }

    @Override
    public String toString() {
        return S.toString(MetaPageUpdateNextSnapshotId.class, this, "super", super.toString());
    }
}

