/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.node;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.apache.ignite.configuration.ClientConnectorConfiguration;
import org.apache.ignite.configuration.ConnectorConfiguration;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.internal.visor.VisorDataTransferObject;
import org.apache.ignite.internal.visor.node.VisorExecutorConfiguration;

public class VisorExecutorServiceConfiguration
extends VisorDataTransferObject {
    private static final long serialVersionUID = 0L;
    private int pubPoolSize;
    private int sysPoolSz;
    private int mgmtPoolSize;
    private int igfsPoolSize;
    private int p2pPoolSz;
    private int rebalanceThreadPoolSize;
    private int restPoolSz;
    private int cbPoolSize;
    private int dataStreamerPoolSize;
    private int qryPoolSize;
    private int stripedPoolSize;
    private int svcPoolSize;
    private int utilityCachePoolSize;
    private int cliConnCfgPoolSize;
    private List<VisorExecutorConfiguration> executors;

    public VisorExecutorServiceConfiguration() {
    }

    public VisorExecutorServiceConfiguration(IgniteConfiguration c) {
        this.pubPoolSize = c.getPublicThreadPoolSize();
        this.sysPoolSz = c.getSystemThreadPoolSize();
        this.mgmtPoolSize = c.getManagementThreadPoolSize();
        this.p2pPoolSz = c.getPeerClassLoadingThreadPoolSize();
        this.igfsPoolSize = c.getIgfsThreadPoolSize();
        this.rebalanceThreadPoolSize = c.getRebalanceThreadPoolSize();
        ConnectorConfiguration cc = c.getConnectorConfiguration();
        if (cc != null) {
            this.restPoolSz = cc.getThreadPoolSize();
        }
        this.cbPoolSize = c.getAsyncCallbackPoolSize();
        this.dataStreamerPoolSize = c.getDataStreamerThreadPoolSize();
        this.qryPoolSize = c.getQueryThreadPoolSize();
        this.stripedPoolSize = c.getStripedPoolSize();
        this.svcPoolSize = c.getServiceThreadPoolSize();
        this.utilityCachePoolSize = c.getUtilityCacheThreadPoolSize();
        ClientConnectorConfiguration scc = c.getClientConnectorConfiguration();
        if (scc != null) {
            this.cliConnCfgPoolSize = scc.getThreadPoolSize();
        }
        this.executors = VisorExecutorConfiguration.list(c.getExecutorConfiguration());
    }

    public int getPublicThreadPoolSize() {
        return this.pubPoolSize;
    }

    public int getSystemThreadPoolSize() {
        return this.sysPoolSz;
    }

    public int getManagementThreadPoolSize() {
        return this.mgmtPoolSize;
    }

    public int getIgfsThreadPoolSize() {
        return this.igfsPoolSize;
    }

    public int getPeerClassLoadingThreadPoolSize() {
        return this.p2pPoolSz;
    }

    public int getRebalanceThreadPoolSize() {
        return this.rebalanceThreadPoolSize;
    }

    public int getRestThreadPoolSize() {
        return this.restPoolSz;
    }

    public int getCallbackPoolSize() {
        return this.cbPoolSize;
    }

    public int getDataStreamerPoolSize() {
        return this.dataStreamerPoolSize;
    }

    public int getQueryThreadPoolSize() {
        return this.qryPoolSize;
    }

    public int getStripedPoolSize() {
        return this.stripedPoolSize;
    }

    public int getServiceThreadPoolSize() {
        return this.svcPoolSize;
    }

    public int getUtilityCacheThreadPoolSize() {
        return this.utilityCachePoolSize;
    }

    public int getClientConnectorConfigurationThreadPoolSize() {
        return this.cliConnCfgPoolSize;
    }

    public List<VisorExecutorConfiguration> getExecutors() {
        return this.executors;
    }

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        out.writeInt(this.pubPoolSize);
        out.writeInt(this.sysPoolSz);
        out.writeInt(this.mgmtPoolSize);
        out.writeInt(this.igfsPoolSize);
        out.writeInt(this.p2pPoolSz);
        out.writeInt(this.rebalanceThreadPoolSize);
        out.writeInt(this.restPoolSz);
        out.writeInt(this.cbPoolSize);
        out.writeInt(this.dataStreamerPoolSize);
        out.writeInt(this.qryPoolSize);
        out.writeInt(this.stripedPoolSize);
        out.writeInt(this.svcPoolSize);
        out.writeInt(this.utilityCachePoolSize);
        out.writeInt(this.cliConnCfgPoolSize);
        U.writeCollection(out, this.executors);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.pubPoolSize = in.readInt();
        this.sysPoolSz = in.readInt();
        this.mgmtPoolSize = in.readInt();
        this.igfsPoolSize = in.readInt();
        this.p2pPoolSz = in.readInt();
        this.rebalanceThreadPoolSize = in.readInt();
        this.restPoolSz = in.readInt();
        this.cbPoolSize = in.readInt();
        this.dataStreamerPoolSize = in.readInt();
        this.qryPoolSize = in.readInt();
        this.stripedPoolSize = in.readInt();
        this.svcPoolSize = in.readInt();
        this.utilityCachePoolSize = in.readInt();
        this.cliConnCfgPoolSize = in.readInt();
        this.executors = U.readList(in);
    }

    public String toString() {
        return S.toString(VisorExecutorServiceConfiguration.class, this);
    }
}

