/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util;

import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.util.tostring.GridToStringExclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

public class GridStripedReadWriteLock {
    @GridToStringExclude
    private final ReadWriteLock[] locks;

    public GridStripedReadWriteLock(int concurrencyLevel) {
        this.locks = new ReadWriteLock[concurrencyLevel];
        for (int i = 0; i < concurrencyLevel; ++i) {
            this.locks[i] = new ReentrantReadWriteLock();
        }
    }

    public int concurrencyLevel() {
        return this.locks.length;
    }

    public ReadWriteLock[] getAllLocks() {
        return this.locks;
    }

    public ReadWriteLock getLock(int key) {
        return this.locks[U.safeAbs(key) % this.locks.length];
    }

    public ReadWriteLock getLock(long key) {
        return this.locks[U.safeAbs((int)(key % (long)this.locks.length))];
    }

    public ReadWriteLock getLock(@Nullable Object o) {
        return o == null ? this.locks[0] : this.getLock(o.hashCode());
    }

    public String toString() {
        return S.toString(GridStripedReadWriteLock.class, this, "concurrency", this.locks.length);
    }
}

