/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.pool;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.managers.communication.GridIoPolicy;
import org.apache.ignite.internal.processors.GridProcessorAdapter;
import org.apache.ignite.internal.processors.plugin.IgnitePluginProcessor;
import org.apache.ignite.plugin.extensions.communication.IoPool;
import org.jetbrains.annotations.Nullable;

public class PoolProcessor
extends GridProcessorAdapter {
    private final IoPool[] extPools = new IoPool[128];
    private final Map<String, ? extends ExecutorService> customExecs;

    public PoolProcessor(GridKernalContext ctx) {
        super(ctx);
        IoPool[] executorExtensions;
        IgnitePluginProcessor plugins = ctx.plugins();
        if (plugins != null && (executorExtensions = (IoPool[])ctx.plugins().extensions(IoPool.class)) != null) {
            for (IoPool ex : executorExtensions) {
                byte id = ex.id();
                if (id < 0) {
                    throw new IgniteException("Failed to register IO executor pool because its ID is negative: " + id);
                }
                if (GridIoPolicy.isReservedGridIoPolicy(id)) {
                    throw new IgniteException("Failed to register IO executor pool because its ID in in the reserved range: " + id);
                }
                if (this.extPools[id] != null) {
                    throw new IgniteException("Failed to register IO executor pool because its ID as already used: " + id);
                }
                this.extPools[id] = ex;
            }
        }
        this.customExecs = ctx.customExecutors();
    }

    @Override
    public void stop(boolean cancel) throws IgniteCheckedException {
        Arrays.fill(this.extPools, null);
    }

    public Executor p2pPool() {
        return this.ctx.getPeerClassLoadingExecutorService();
    }

    public Executor poolForPolicy(byte plc) throws IgniteCheckedException {
        switch (plc) {
            case 1: {
                return this.ctx.getPeerClassLoadingExecutorService();
            }
            case 2: {
                return this.ctx.getSystemExecutorService();
            }
            case 0: {
                return this.ctx.getExecutorService();
            }
            case 3: {
                return this.ctx.getManagementExecutorService();
            }
            case 4: {
                return this.ctx.getAffinityExecutorService();
            }
            case 7: {
                assert (this.ctx.getIndexingExecutorService() != null) : "Indexing pool is not configured.";
                return this.ctx.getIndexingExecutorService();
            }
            case 5: {
                assert (this.ctx.utilityCachePool() != null) : "Utility cache pool is not configured.";
                return this.ctx.utilityCachePool();
            }
            case 6: {
                assert (this.ctx.getIgfsExecutorService() != null) : "IGFS pool is not configured.";
                return this.ctx.getIgfsExecutorService();
            }
            case 11: {
                assert (this.ctx.getServiceExecutorService() != null) : "Service pool is not configured.";
                return this.ctx.getServiceExecutorService();
            }
            case 9: {
                assert (this.ctx.getDataStreamerExecutorService() != null) : "Data streamer pool is not configured.";
                return this.ctx.getDataStreamerExecutorService();
            }
            case 10: {
                assert (this.ctx.getQueryExecutorService() != null) : "Query pool is not configured.";
                return this.ctx.getQueryExecutorService();
            }
            case 12: {
                assert (this.ctx.getSchemaExecutorService() != null) : "Query pool is not configured.";
                return this.ctx.getSchemaExecutorService();
            }
        }
        if (plc < 0) {
            throw new IgniteCheckedException("Policy cannot be negative: " + plc);
        }
        if (GridIoPolicy.isReservedGridIoPolicy(plc)) {
            throw new IgniteCheckedException("Policy is reserved for internal usage (range 0-31): " + plc);
        }
        IoPool pool = this.extPools[plc];
        if (pool == null) {
            throw new IgniteCheckedException("No pool is registered for policy: " + plc);
        }
        assert (plc == pool.id());
        Executor res = pool.executor();
        if (res == null) {
            throw new IgniteCheckedException("Thread pool for policy is null: " + plc);
        }
        return res;
    }

    @Nullable
    public Executor customExecutor(String name) {
        assert (name != null);
        Executor exec = null;
        if (this.customExecs != null) {
            exec = this.customExecs.get(name);
        }
        return exec;
    }
}

